/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermaldynamics.duct.attachments.servo;

import cofh.lib.util.helpers.ItemHelper;
import cofh.repack.codechicken.lib.vec.Cuboid6;
import cofh.thermaldynamics.block.TileTDBase;
import cofh.thermaldynamics.duct.Duct;
import cofh.thermaldynamics.duct.attachments.filter.FilterLogic;
import cofh.thermaldynamics.duct.attachments.servo.ServoBase;
import cofh.thermaldynamics.duct.item.ItemGrid;
import cofh.thermaldynamics.duct.item.TileItemDuct;
import cofh.thermaldynamics.duct.item.TravelingItem;
import cofh.thermaldynamics.multiblock.Route;
import cofh.thermaldynamics.multiblock.RouteCache;
import cofh.thermaldynamics.multiblock.listtypes.ListWrapper;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class ServoItem
extends ServoBase {
    public static int[] range = new int[]{Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE, Integer.MAX_VALUE};
    public static int[] maxSize = new int[]{4, 16, 64, 64, 64};
    public static boolean[] multiStack = new boolean[]{false, false, false, true, true};
    public LinkedList<ItemStack> stuffedItems = new LinkedList();
    public TileItemDuct itemDuct;
    public RouteCache cache = null;
    public ListWrapper<Route> routeList = new ListWrapper();
    public static int[] tickDelays = new int[]{60, 40, 20, 10, 10};
    public static byte[] speedBoost = new byte[]{1, 1, 1, 2, 3};
    public IInventory cachedInv;
    public ISidedInventory cachedSidedInv;
    public TileItemDuct.CacheType cacheType;

    public ServoItem(TileTDBase tileTDBase, byte by, int n) {
        super(tileTDBase, by, n);
        this.itemDuct = (TileItemDuct)tileTDBase;
    }

    public ServoItem(TileTDBase tileTDBase, byte by) {
        super(tileTDBase, by);
        this.itemDuct = (TileItemDuct)tileTDBase;
    }

    @Override
    public int getId() {
        return 2;
    }

    @Override
    public void writeToNBT(NBTTagCompound nBTTagCompound) {
        super.writeToNBT(nBTTagCompound);
        if (this.isStuffed()) {
            NBTTagList nBTTagList = new NBTTagList();
            for (ItemStack itemStack : this.stuffedItems) {
                NBTTagCompound nBTTagCompound2 = new NBTTagCompound();
                ItemHelper.writeItemStackToNBT((ItemStack)itemStack, (NBTTagCompound)nBTTagCompound2);
                nBTTagList.func_74742_a((NBTBase)nBTTagCompound2);
            }
            nBTTagCompound.func_74782_a("StuffedInv", (NBTBase)nBTTagList);
        }
    }

    @Override
    public void readFromNBT(NBTTagCompound nBTTagCompound) {
        super.readFromNBT(nBTTagCompound);
        this.stuffedItems.clear();
        if (nBTTagCompound.func_150297_b("StuffedInv", 9)) {
            NBTTagList nBTTagList = nBTTagCompound.func_150295_c("StuffedInv", 10);
            for (int i = 0; i < nBTTagList.func_74745_c(); ++i) {
                ItemStack itemStack = ItemHelper.readItemStackFromNBT((NBTTagCompound)nBTTagList.func_150305_b(i));
                if (itemStack == null || itemStack.func_77973_b() == null) continue;
                this.stuffedItems.add(itemStack);
            }
        }
        this.stuffed = this.isStuffed();
    }

    @Override
    public boolean canStuff() {
        return true;
    }

    @Override
    public void stuffItem(ItemStack itemStack) {
        for (ItemStack itemStack2 : this.stuffedItems) {
            if (!ItemHelper.itemsEqualWithMetadata((ItemStack)itemStack, (ItemStack)itemStack2, (boolean)true)) continue;
            itemStack2.field_77994_a += itemStack.field_77994_a;
            if (itemStack2.field_77994_a < 0) {
                itemStack2.field_77994_a = Integer.MAX_VALUE;
            }
            return;
        }
        this.stuffedItems.add(itemStack.func_77946_l());
        this.onNeighborChange();
    }

    @Override
    public List<ItemStack> getDrops() {
        List<ItemStack> list = super.getDrops();
        if (this.isStuffed()) {
            block0: for (ItemStack itemStack : this.stuffedItems) {
                ItemStack itemStack2 = itemStack.func_77946_l();
                while (itemStack2.field_77994_a > 0 && list.size() <= 30) {
                    if (itemStack2.field_77994_a <= itemStack.func_77976_d()) {
                        list.add(ItemHelper.cloneStack((ItemStack)itemStack2));
                        continue block0;
                    }
                    list.add(itemStack2.func_77979_a(itemStack.func_77976_d()));
                }
            }
        }
        return list;
    }

    public int tickDelay() {
        return tickDelays[this.type];
    }

    @Override
    public boolean onWrenched() {
        Cuboid6 cuboid6 = this.getCuboid();
        if (this.isStuffed()) {
            for (ItemStack itemStack : this.stuffedItems) {
                while (itemStack.field_77994_a > 0) {
                    this.dropItemStack(itemStack.func_77979_a(Math.min(itemStack.field_77994_a, itemStack.func_77976_d())));
                }
            }
            this.stuffedItems.clear();
            this.onNeighborChange();
            return true;
        }
        return super.onWrenched();
    }

    @Override
    public void tick(int n) {
        if (n == 0) {
            if (this.isPowered && (this.isValidInput || this.isStuffed()) && this.itemDuct.world().func_82737_E() % (long)this.tickDelay() == 0L) {
                ItemGrid.toTick.add(this);
            }
            return;
        }
        if (!this.isPowered || this.itemDuct.world().func_82737_E() % (long)this.tickDelay() != 0L) {
            return;
        }
        if (!this.verifyCache()) {
            return;
        }
        if (this.cache.outputRoutes.isEmpty()) {
            return;
        }
        if (n == 1) {
            if (this.isStuffed()) {
                this.handleStuffedItems();
            } else if (this.stuffed) {
                this.onNeighborChange();
            }
        } else if (n == 2 && !this.stuffed) {
            if (!this.isValidInput) {
                return;
            }
            this.handleItemSending();
        }
    }

    public boolean verifyCache() {
        RouteCache routeCache = this.itemDuct.getCache(false);
        if (!routeCache.isFinishedGenerating()) {
            return false;
        }
        if (routeCache != this.cache || this.routeList.type != this.getSortType()) {
            this.cache = routeCache;
            this.routeList.setList(this.cache.outputRoutes, this.getSortType());
        }
        return true;
    }

    public void handleItemSending() {
        block11: {
            block10: {
                if (this.cacheType != TileItemDuct.CacheType.ISIDEDINV) break block10;
                int[] nArray = this.cachedSidedInv.func_94128_d(this.side ^ 1);
                for (int i = 0; i < nArray.length; ++i) {
                    TravelingItem travelingItem;
                    int n = nArray[i];
                    ItemStack itemStack = this.cachedSidedInv.func_70301_a(n);
                    if (itemStack == null || (itemStack = this.limitOutput(itemStack.func_77946_l(), this.cachedInv, n, this.side)) == null || itemStack.field_77994_a == 0 || !this.cachedSidedInv.func_102008_b(n, itemStack, this.side ^ 1) || !this.filter.matchesFilter(itemStack) || (travelingItem = this.getRouteForItem(itemStack)) == null) continue;
                    int n2 = travelingItem.stack.field_77994_a;
                    travelingItem.stack = this.cachedSidedInv.func_70298_a(n, travelingItem.stack.field_77994_a);
                    if (travelingItem.stack == null || travelingItem.stack.field_77994_a <= 0) {
                        this.cachedSidedInv.func_70296_d();
                        continue;
                    }
                    if (multiStack[this.type] && travelingItem.stack.field_77994_a < n2) {
                        ++i;
                        while (i < nArray.length && travelingItem.stack.field_77994_a < n2) {
                            n = nArray[i];
                            itemStack = this.cachedSidedInv.func_70301_a(n);
                            if (ItemHelper.itemsEqualWithMetadata((ItemStack)travelingItem.stack, (ItemStack)itemStack, (boolean)true) && this.cachedSidedInv.func_102008_b(n, itemStack, this.side ^ 1) && (itemStack = this.cachedSidedInv.func_70298_a(n, n2 - travelingItem.stack.field_77994_a)) != null) {
                                travelingItem.stack.field_77994_a += itemStack.field_77994_a;
                            }
                            ++i;
                        }
                    }
                    this.cachedSidedInv.func_70296_d();
                    this.itemDuct.insertNewItem(travelingItem);
                    return;
                }
                break block11;
            }
            if (this.cacheType != TileItemDuct.CacheType.IINV) break block11;
            for (int i = 0; i < this.cachedInv.func_70302_i_(); ++i) {
                TravelingItem travelingItem;
                ItemStack itemStack = this.cachedInv.func_70301_a(i);
                if (itemStack == null || (itemStack = this.limitOutput(itemStack.func_77946_l(), this.cachedInv, i, this.side)) == null || itemStack.field_77994_a == 0 || !this.filter.matchesFilter(itemStack) || (travelingItem = this.getRouteForItem(itemStack)) == null) continue;
                int n = travelingItem.stack.field_77994_a;
                travelingItem.stack = this.cachedInv.func_70298_a(i, travelingItem.stack.field_77994_a);
                if (travelingItem.stack == null || travelingItem.stack.field_77994_a <= 0) {
                    this.cachedInv.func_70296_d();
                    continue;
                }
                if (multiStack[this.type] && travelingItem.stack.field_77994_a < n) {
                    ++i;
                    while (i < this.cachedInv.func_70302_i_() && travelingItem.stack.field_77994_a < n) {
                        itemStack = this.cachedInv.func_70301_a(i);
                        if (ItemHelper.itemsEqualWithMetadata((ItemStack)travelingItem.stack, (ItemStack)itemStack, (boolean)true) && (itemStack = this.cachedInv.func_70298_a(i, n - travelingItem.stack.field_77994_a)) != null) {
                            travelingItem.stack.field_77994_a += itemStack.field_77994_a;
                        }
                        ++i;
                    }
                }
                this.cachedInv.func_70296_d();
                this.itemDuct.insertNewItem(travelingItem);
                return;
            }
        }
    }

    public void handleStuffedItems() {
        Iterator iterator = this.stuffedItems.iterator();
        while (iterator.hasNext()) {
            ItemStack itemStack = (ItemStack)iterator.next();
            ItemStack itemStack2 = itemStack.func_77946_l();
            itemStack2.field_77994_a = Math.min(itemStack2.field_77994_a, itemStack2.func_77976_d());
            TravelingItem travelingItem = this.getRouteForItem(itemStack2);
            if (travelingItem == null) continue;
            itemStack.field_77994_a -= travelingItem.stack.field_77994_a;
            if (itemStack.field_77994_a <= 0) {
                iterator.remove();
            }
            this.itemDuct.insertNewItem(travelingItem);
            return;
        }
    }

    public byte getSpeed() {
        return speedBoost[this.type];
    }

    public static TravelingItem findRouteForItem(ItemStack itemStack, Iterable<Route> iterable, TileItemDuct tileItemDuct, int n, int n2, byte by) {
        if (itemStack == null || itemStack.field_77994_a == 0) {
            return null;
        }
        itemStack = itemStack.func_77946_l();
        if (itemStack.field_77994_a == 0) {
            return null;
        }
        for (Route route : iterable) {
            int n3;
            if (route.pathDirections.size() > n2) continue;
            TileItemDuct.RouteInfo routeInfo = route.endPoint.canRouteItem(itemStack);
            if (!routeInfo.canRoute || (n3 = itemStack.field_77994_a - routeInfo.stackSize) <= 0) continue;
            Route route2 = route.copy();
            route2.pathDirections.add(routeInfo.side);
            itemStack.field_77994_a -= routeInfo.stackSize;
            return new TravelingItem(itemStack, tileItemDuct, route2, (byte)(n ^ 1), by);
        }
        return null;
    }

    public int getMaxRange() {
        return range[this.type];
    }

    public ItemStack limitOutput(ItemStack itemStack, IInventory iInventory, int n, byte by) {
        itemStack.field_77994_a = Math.min(itemStack.field_77994_a, this.filter.getLevel(0));
        return itemStack;
    }

    @Override
    public void onNeighborChange() {
        if (this.stuffed != !this.stuffedItems.isEmpty()) {
            this.stuffed = this.isStuffed();
            this.tile.func_145831_w().func_147471_g(((TileEntity)this.tile).field_145851_c, ((TileEntity)this.tile).field_145848_d, ((TileEntity)this.tile).field_145849_e);
        }
        super.onNeighborChange();
    }

    @Override
    public boolean isStuffed() {
        return !this.stuffedItems.isEmpty();
    }

    @Override
    public boolean isValidTile(TileEntity tileEntity) {
        return tileEntity instanceof IInventory;
    }

    @Override
    public void clearCache() {
        this.cacheType = TileItemDuct.CacheType.NONE;
        this.cachedInv = null;
        this.cachedSidedInv = null;
    }

    @Override
    public void cacheTile(TileEntity tileEntity) {
        this.cachedInv = (IInventory)tileEntity;
        if (tileEntity instanceof ISidedInventory) {
            this.cacheType = TileItemDuct.CacheType.ISIDEDINV;
            this.cachedSidedInv = (ISidedInventory)tileEntity;
        } else {
            this.cacheType = TileItemDuct.CacheType.IINV;
        }
    }

    public ItemStack insertItem(ItemStack itemStack) {
        if (!this.filter.matchesFilter(itemStack)) {
            return itemStack;
        }
        ItemStack itemStack2 = this.limitOutput(itemStack.func_77946_l(), null, -1, (byte)0);
        TravelingItem travelingItem = this.getRouteForItem(itemStack2);
        if (travelingItem == null) {
            return itemStack;
        }
        itemStack.field_77994_a -= travelingItem.stack.field_77994_a;
        this.itemDuct.insertNewItem(travelingItem);
        return itemStack.field_77994_a > 0 ? itemStack : null;
    }

    public TravelingItem getRouteForItem(ItemStack itemStack) {
        if (!this.verifyCache()) {
            return null;
        }
        return ServoItem.findRouteForItem(itemStack, this.routeList, this.itemDuct, this.side, this.getMaxRange(), this.getSpeed());
    }

    public ListWrapper.SortType getSortType() {
        int n = this.filter.getLevel(1);
        return ListWrapper.SortType.values()[n];
    }

    @Override
    public FilterLogic createFilterLogic() {
        return new FilterLogic(this.type, Duct.Type.ITEM, this);
    }
}

