/*
 * Decompiled with CFR 0.152.
 */
package hats.common.thread;

import hats.common.Hats;
import hats.common.core.HatHandler;
import ichun.common.core.techne.TC2Info;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ThreadHatsReader
extends Thread {
    public final File hatsFolder;
    public final boolean shouldDownload;
    public final boolean loadGuiOnEnd;

    public ThreadHatsReader(File hatsFolder, boolean shouldDownload, boolean loadGuiOnEnd) {
        this.hatsFolder = hatsFolder;
        this.shouldDownload = shouldDownload;
        this.loadGuiOnEnd = loadGuiOnEnd;
        this.setName("Hats Download/Read Hats Thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        File[] files;
        File[] favs;
        if (this.shouldDownload) {
            int hatDownloaded = 0;
            try {
                URL var1 = new URL("http://www.creeperrepo.net/ichun/static/hats.xml");
                DocumentBuilderFactory var2 = DocumentBuilderFactory.newInstance();
                DocumentBuilder var3 = var2.newDocumentBuilder();
                URLConnection con = var1.openConnection();
                con.setConnectTimeout(60000);
                con.setReadTimeout(60000);
                Document var4 = var3.parse(con.getInputStream());
                NodeList var5 = var4.getElementsByTagName("File");
                for (int var6 = 0; var6 < 2; ++var6) {
                    for (int var7 = 0; var7 < var5.getLength(); ++var7) {
                        Node var8 = var5.item(var7);
                        if (var8.getNodeType() != 1) continue;
                        Element var9 = (Element)var8;
                        String var10 = var9.getElementsByTagName("Path").item(0).getChildNodes().item(0).getNodeValue();
                        long var11 = Long.parseLong(var9.getElementsByTagName("Size").item(0).getChildNodes().item(0).getNodeValue());
                        String url = var9.getElementsByTagName("URL").item(0).getChildNodes().item(0).getNodeValue();
                        if (var11 <= 0L || !this.downloadResource(new URL(url = url.replaceAll(" ", "%20")), new File(this.hatsFolder, var10), var11)) continue;
                        ++hatDownloaded;
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (hatDownloaded != 0) {
                Hats.console("Downloaded " + hatDownloaded + " hats from Creeperhost Hat Repository");
            }
        }
        int hatCount = 0;
        HatHandler.reloadingHats = true;
        Hats.proxy.clearAllHats();
        File fav = new File(this.hatsFolder, "/Favourites");
        if (!fav.exists()) {
            fav.mkdirs();
        }
        for (File file : favs = fav.listFiles()) {
            File hat;
            if (file.isDirectory() || !file.getName().endsWith(".tcn") && !file.getName().endsWith(".tc2") || (hat = new File(this.hatsFolder, file.getName())).exists()) continue;
            FileInputStream inStream = null;
            FileOutputStream outStream = null;
            try {
                int length;
                inStream = new FileInputStream(file);
                outStream = new FileOutputStream(hat);
                byte[] buffer = new byte[1024];
                while ((length = ((InputStream)inStream).read(buffer)) > 0) {
                    ((OutputStream)outStream).write(buffer, 0, length);
                }
            }
            catch (Exception e) {
                // empty catch block
            }
            try {
                if (inStream != null) {
                    ((InputStream)inStream).close();
                }
            }
            catch (IOException e) {
                // empty catch block
            }
            try {
                if (outStream == null) continue;
                ((OutputStream)outStream).close();
            }
            catch (IOException e) {
                // empty catch block
            }
        }
        int convertCount = this.convertFolderToTC2(this.hatsFolder);
        if (convertCount != 0) {
            Hats.console("Converted " + convertCount + (convertCount == 1 ? " hat" : " hats") + " from Techne 1 format to Techne 2 format.");
        }
        for (File file : files = this.hatsFolder.listFiles()) {
            if (file.isDirectory() || !HatHandler.readHatFromFile(file)) continue;
            ++hatCount;
        }
        int contribHats = 0;
        for (File file : files) {
            if (!file.isDirectory() || file.getName().equalsIgnoreCase("Disabled")) continue;
            if (file.getName().equalsIgnoreCase("Contributors")) {
                hatCount += (contribHats += HatHandler.loadCategory(file));
                continue;
            }
            hatCount += HatHandler.loadCategory(file);
        }
        Hats.console((this.loadGuiOnEnd ? "Reloaded " : "Loaded ") + Integer.toString(hatCount) + (hatCount == 1 ? " hat" : " hats. " + contribHats + " are contributor hats."));
        if (this.loadGuiOnEnd) {
            HatHandler.reloadAndOpenGui();
        }
        HatHandler.reloadingHats = false;
    }

    private int convertFolderToTC2(File folder) {
        File[] files;
        int converted = 0;
        for (File file : files = folder.listFiles()) {
            TC2Info info;
            if (file.isDirectory()) {
                converted += this.convertFolderToTC2(file);
                continue;
            }
            if (!file.getName().endsWith(".tcn") || (info = TC2Info.readTechneFile((File)file)) == null) continue;
            info.saveAsFile(new File(file.getParentFile(), file.getName().substring(0, file.getName().length() - 1) + "2"), true);
            file.delete();
            ++converted;
        }
        return converted;
    }

    public boolean downloadResource(URL par1URL, File par2File, long size) throws IOException {
        if (par2File.exists()) {
            if (par2File.length() == size || HatHandler.isHatReadable(par2File)) {
                return false;
            }
        } else if (!par2File.getParentFile().exists()) {
            par2File.getParentFile().mkdirs();
        }
        byte[] var5 = new byte[4096];
        URLConnection con = par1URL.openConnection();
        con.setConnectTimeout(15000);
        con.setReadTimeout(15000);
        DataInputStream var6 = new DataInputStream(con.getInputStream());
        DataOutputStream var7 = new DataOutputStream(new FileOutputStream(par2File));
        boolean var8 = false;
        while (true) {
            int var9;
            if ((var9 = var6.read(var5)) < 0) {
                var6.close();
                var7.close();
                return true;
            }
            var7.write(var5, 0, var9);
        }
    }
}

