/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.items.armor;

import cofh.api.energy.IEnergyContainerItem;
import com.brandon3055.draconicevolution.common.items.armor.DraconicArmor;
import com.brandon3055.draconicevolution.common.items.armor.WyvernArmor;
import com.brandon3055.draconicevolution.common.utills.ItemNBTHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;

public class ArmorEffectHandler {
    public static boolean getHasFlight(EntityPlayer player) {
        return ArmorEffectHandler.isDraconicArmor(player, 3);
    }

    public static boolean getFlightLock(EntityPlayer player) {
        return ItemNBTHelper.getBoolean(player.func_71124_b(3), "ArmorFlightLock", false);
    }

    public static boolean getHasSwiftness(EntityPlayer player) {
        return ArmorEffectHandler.isDraconicArmor(player, 2) || ArmorEffectHandler.isWyvernArmor(player, 2);
    }

    public static int getSwiftnessLevel(EntityPlayer player) {
        int i = ArmorEffectHandler.isWyvernArmor(player, 2) ? 2 : (ArmorEffectHandler.isDraconicArmor(player, 2) ? 4 : 0);
        return player.func_70051_ag() || !ItemNBTHelper.getBoolean(player.func_71124_b(2), "ArmorSprintOnly", false) ? i * 2 : i;
    }

    public static float getSwiftnessMultiplier(EntityPlayer player) {
        return ItemNBTHelper.getFloat(player.func_71124_b(2), "ArmorSpeedMult", 1.0f);
    }

    public static boolean getHasJumpBoost(EntityPlayer player) {
        return (ArmorEffectHandler.isDraconicArmor(player, 1) || ArmorEffectHandler.isWyvernArmor(player, 1)) && ArmorEffectHandler.extractEnergy(player, (ArmorEffectHandler.getJumpLevel(player) + 1) * 80, 1);
    }

    public static int getJumpLevel(EntityPlayer player) {
        int i = ArmorEffectHandler.isWyvernArmor(player, 1) ? 2 : (ArmorEffectHandler.isDraconicArmor(player, 1) ? 4 : 0);
        return player.func_70051_ag() || !ItemNBTHelper.getBoolean(player.func_71124_b(1), "ArmorSprintOnly", false) ? i * 2 : i;
    }

    public static float getJumpMultiplier(EntityPlayer player) {
        return ItemNBTHelper.getFloat(player.func_71124_b(1), "ArmorJumpMult", 1.0f);
    }

    public static boolean getFireImunity(EntityPlayer player) {
        if (ArmorEffectHandler.isDraconicArmor(player, 3) && ArmorEffectHandler.extractEnergy(player, 80, 3)) {
            return true;
        }
        return ArmorEffectHandler.isWyvernArmor(player, 1) && ArmorEffectHandler.isWyvernArmor(player, 2) && ArmorEffectHandler.isWyvernArmor(player, 3) && ArmorEffectHandler.isWyvernArmor(player, 4);
    }

    public static boolean getHasHighStep(EntityPlayer player) {
        return ArmorEffectHandler.isDraconicArmor(player, 1) && ItemNBTHelper.getBoolean(player.func_71124_b(1), "ArmorHillStep", true);
    }

    public static boolean isWyvernArmor(EntityPlayer player, int slot) {
        int slotType = 4 - slot;
        ItemStack armor = player.func_71124_b(slot);
        return armor != null && armor.func_77973_b() instanceof WyvernArmor && ((WyvernArmor)armor.func_77973_b()).field_77881_a == slotType;
    }

    public static boolean isDraconicArmor(EntityPlayer player, int slot) {
        int slotType = 4 - slot;
        ItemStack armor = player.func_71124_b(slot);
        return armor != null && armor.func_77973_b() instanceof DraconicArmor && ((DraconicArmor)armor.func_77973_b()).field_77881_a == slotType;
    }

    public static boolean extractEnergy(EntityPlayer player, int amount, int slot) {
        if (player.func_71124_b(slot).func_77973_b() instanceof IEnergyContainerItem) {
            return ((IEnergyContainerItem)player.func_71124_b(slot).func_77973_b()).extractEnergy(player.func_71124_b(slot), amount, false) == amount;
        }
        return false;
    }
}

