/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.blocks;

import com.brandon3055.draconicevolution.common.blocks.BlockContainerDE;
import com.brandon3055.draconicevolution.common.utills.InventoryUtils;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public abstract class BlockCustomDrop
extends BlockContainerDE {
    public BlockCustomDrop(Material material) {
        super(material);
    }

    protected abstract boolean dropInventory();

    protected abstract boolean hasCustomDropps();

    protected abstract void getCustomTileEntityDrops(TileEntity var1, List<ItemStack> var2);

    private void getCustomDrops(TileEntity te, List<ItemStack> droppes) {
        if (te == null) {
            return;
        }
        if (this.hasCustomDropps()) {
            this.getCustomTileEntityDrops(te, droppes);
        }
        if (this.dropInventory() && te instanceof IInventory) {
            droppes.addAll(InventoryUtils.getInventoryContents((IInventory)te));
            for (int i = 0; i < ((IInventory)te).func_70302_i_(); ++i) {
                ((IInventory)te).func_70299_a(i, null);
            }
        }
    }

    public boolean removedByPlayer(World world, EntityPlayer player, int x, int y, int z, boolean willHarvest) {
        if (willHarvest) {
            TileEntity te = world.func_147438_o(x, y, z);
            boolean result = super.removedByPlayer(world, player, x, y, z, willHarvest);
            if (result) {
                ArrayList teDrops = Lists.newArrayList();
                this.getCustomDrops(te, teDrops);
                for (ItemStack drop : teDrops) {
                    this.func_149642_a(world, x, y, z, drop);
                }
            }
            return result;
        }
        return super.removedByPlayer(world, player, x, y, z, willHarvest);
    }

    public ArrayList<ItemStack> getDrops(World world, int x, int y, int z, int metadata, int fortune) {
        ArrayList result = Lists.newArrayList();
        if (!this.hasCustomDropps()) {
            result.addAll(super.getDrops(world, x, y, z, metadata, fortune));
        }
        if (this.hasCustomDropps() || this.dropInventory()) {
            TileEntity te = world.func_147438_o(x, y, z);
            this.getCustomDrops(te, result);
        }
        return result;
    }
}

