/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.tileentities;

import appeng.api.config.Actionable;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.util.AECableType;
import appeng.api.util.DimensionalCoord;
import appeng.tile.TileEvent;
import appeng.tile.events.TileEventType;
import appeng.tile.grid.AENetworkTile;
import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IAspectSource;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.integration.tc.EssentiaTransportHelper;
import thaumicenergistics.integration.tc.IEssentiaTransportWithSimulate;

public class TileEssentiaVibrationChamber
extends AENetworkTile
implements IGridTickable,
IEssentiaTransportWithSimulate,
IAspectSource {
    private static final byte STATE_OFF = 0;
    private static final byte STATE_IGNIS = 1;
    private static final byte STATE_POTENTIA = 2;
    private static final int TICKRATE_IDLE = 40;
    private static final int TICKRATE_URGENT = 10;
    private static final int MAX_ESSENTIA_STORED = 64;
    private int storedEssentiaAmount = 0;
    private Aspect storedEssentiaAspect = null;
    private TickRateModulation tickRate = TickRateModulation.SAME;
    private int suctionRotationTimer = 1;

    protected ItemStack getItemFromTile(Object obj) {
        return ThEApi.instance().blocks().EssentiaVibrationChamber.getStack();
    }

    public int addEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return this.addEssentia(aspect, amount, side, Actionable.MODULATE);
    }

    @Override
    public int addEssentia(Aspect aspect, int amount, ForgeDirection side, Actionable mode) {
        if (this.storedEssentiaAspect != null && this.storedEssentiaAspect != aspect) {
            return 0;
        }
        int addedAmount = Math.min(amount, 64 - this.storedEssentiaAmount);
        if (addedAmount > 0 && mode == Actionable.MODULATE) {
            if (this.storedEssentiaAspect == null) {
                this.storedEssentiaAspect = aspect;
            }
            this.storedEssentiaAmount += addedAmount;
            this.tickRate = this.storedEssentiaAmount < 10 ? TickRateModulation.URGENT : TickRateModulation.FASTER;
            this.markForUpdate();
            this.func_70296_d();
        }
        return addedAmount;
    }

    public int addToContainer(Aspect aspect, int amount) {
        return this.addEssentia(aspect, amount, null, Actionable.MODULATE);
    }

    public boolean canInputFrom(ForgeDirection side) {
        return side != this.getForward();
    }

    public boolean canOutputTo(ForgeDirection side) {
        return false;
    }

    public int containerContains(Aspect aspect) {
        return aspect == this.storedEssentiaAspect ? this.storedEssentiaAmount : 0;
    }

    public boolean doesContainerAccept(Aspect aspect) {
        if (this.storedEssentiaAspect != null) {
            return aspect == this.storedEssentiaAspect;
        }
        return aspect == Aspect.FIRE || aspect == Aspect.ENERGY;
    }

    @Deprecated
    public boolean doesContainerContain(AspectList aspectList) {
        if (this.storedEssentiaAspect == null) {
            return false;
        }
        return aspectList.aspects.containsKey(this.storedEssentiaAspect);
    }

    public boolean doesContainerContainAmount(Aspect aspect, int amount) {
        if (this.storedEssentiaAspect == null || this.storedEssentiaAspect != aspect) {
            return false;
        }
        return this.storedEssentiaAmount >= amount;
    }

    public AspectList getAspects() {
        AspectList aspectList = new AspectList();
        if (this.storedEssentiaAspect != null) {
            aspectList.add(this.storedEssentiaAspect, this.storedEssentiaAmount);
        }
        return aspectList;
    }

    public AECableType getCableConnectionType(ForgeDirection dir) {
        return AECableType.COVERED;
    }

    public int getEssentiaAmount(ForgeDirection side) {
        return this.storedEssentiaAmount;
    }

    public Aspect getEssentiaType(ForgeDirection side) {
        return this.storedEssentiaAspect;
    }

    public DimensionalCoord getLocation() {
        return new DimensionalCoord((TileEntity)this);
    }

    public int getMinimumSuction() {
        return 0;
    }

    public int getSuctionAmount(ForgeDirection side) {
        return this.storedEssentiaAmount < 64 ? 128 : 0;
    }

    public Aspect getSuctionType(ForgeDirection side) {
        if (this.storedEssentiaAspect != null) {
            return this.storedEssentiaAspect;
        }
        if (this.suctionRotationTimer > 100) {
            if (this.suctionRotationTimer > 200) {
                this.suctionRotationTimer = 0;
            }
            return Aspect.ENERGY;
        }
        return Aspect.FIRE;
    }

    public TickingRequest getTickingRequest(IGridNode node) {
        return new TickingRequest(10, 40, false, false);
    }

    public boolean isConnectable(ForgeDirection side) {
        return side != this.getForward();
    }

    @TileEvent(value=TileEventType.NETWORK_READ)
    @SideOnly(value=Side.CLIENT)
    public boolean onReceiveNetworkData(ByteBuf stream) {
        byte state = stream.readByte();
        this.storedEssentiaAspect = state == 2 ? Aspect.ENERGY : (state == 1 ? Aspect.FIRE : null);
        this.storedEssentiaAmount = stream.readByte();
        return true;
    }

    @TileEvent(value=TileEventType.NETWORK_WRITE)
    public void onSendNetworkData(ByteBuf stream) throws IOException {
        if (this.storedEssentiaAspect == Aspect.ENERGY) {
            stream.writeByte(2);
        } else if (this.storedEssentiaAspect == Aspect.FIRE) {
            stream.writeByte(1);
        } else {
            stream.writeByte(0);
        }
        stream.writeByte((int)((byte)this.storedEssentiaAmount));
    }

    public boolean renderExtendedTube() {
        return false;
    }

    public void setAspects(AspectList aspectList) {
    }

    public void setOwner(EntityPlayer player) {
        this.gridProxy.setOwner(player);
    }

    public void setSuction(Aspect aspect, int amount) {
    }

    public TileEssentiaVibrationChamber setupChamberTile() {
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.gridProxy.setIdlePowerUsage(0.0);
        }
        return this;
    }

    public int takeEssentia(Aspect aspect, int amount, ForgeDirection side) {
        return 0;
    }

    public boolean takeFromContainer(Aspect aspect, int amount) {
        return false;
    }

    @Deprecated
    public boolean takeFromContainer(AspectList arg0) {
        return false;
    }

    public TickRateModulation tickingRequest(IGridNode node, int ticksSinceLastCall) {
        this.tickRate = TickRateModulation.SLOWER;
        if (this.storedEssentiaAmount < 64) {
            EssentiaTransportHelper.instance.takeEssentiaFromTransportNeighbors(this, this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
        if (this.storedEssentiaAspect == null) {
            this.suctionRotationTimer += ticksSinceLastCall;
        }
        return this.tickRate;
    }
}

