/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.registries;

import appeng.api.AEApi;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.ResourceLocation;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.crafting.IArcaneRecipe;
import thaumcraft.api.research.ResearchCategories;
import thaumcraft.api.research.ResearchItem;
import thaumcraft.api.research.ResearchPage;
import thaumcraft.common.config.Config;
import thaumicenergistics.ThaumicEnergistics;
import thaumicenergistics.api.IConfig;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.integration.tc.PseudoResearchItem;
import thaumicenergistics.items.ItemFocusAEWrench;
import thaumicenergistics.items.ItemMaterial;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.registries.BlockEnum;
import thaumicenergistics.registries.RecipeRegistry;

public class ResearchRegistry {
    private static final int COMPLEXITY_SMALL = 1;
    private static final int COMPLEXITY_MEDIUM = 2;
    private static final int COMPLEXITY_LARGE = 3;
    private static final String TERESEARCH_TAB = "thaumicenergistics";
    private static final ResourceLocation TAB_ICON = new ResourceLocation("thaumicenergistics", "textures/research/tab.icon.png");
    private static final ResourceLocation RESEARCH_BACKGROUND = new ResourceLocation("thaumicenergistics", "textures/research/Research.Background.png");

    /*
     * Enabled aggressive block sorting
     */
    private static void addPseudoParents() {
        PseudoResearchTypes[] pseudoTypes;
        IConfig teConfig = ThaumicEnergistics.config;
        PseudoResearchTypes[] arr$ = pseudoTypes = PseudoResearchTypes.values();
        int len$ = arr$.length;
        int i$ = 0;
        while (true) {
            block10: {
                if (i$ >= len$) {
                    return;
                }
                PseudoResearchTypes type = arr$[i$];
                switch (type) {
                    case DUPE: {
                        if (teConfig.allowedToDuplicateCertusQuartz()) break;
                        break block10;
                    }
                    case JAR: {
                        if (!Config.allowMirrors && teConfig.allowedToCraftInfusionProvider()) break;
                        break block10;
                    }
                    case MIRROR: {
                        if (Config.allowMirrors && teConfig.allowedToCraftInfusionProvider()) break;
                        break block10;
                    }
                    case INFUSION: {
                        if (teConfig.allowedToCraftInfusionProvider()) break;
                        break block10;
                    }
                    case WARDED: {
                        if (!Config.wardedStone) break block10;
                    }
                }
                if (!(type == PseudoResearchTypes.JAR && Config.allowMirrors || type == PseudoResearchTypes.MIRROR && !Config.allowMirrors)) {
                    type.registerPsudeoResearch();
                }
            }
            ++i$;
        }
    }

    private static void registerACT() {
        AspectList actAspectList = new AspectList();
        actAspectList.add(Aspect.CRAFT, 5);
        actAspectList.add(Aspect.ENERGY, 3);
        actAspectList.add(Aspect.MECHANISM, 3);
        actAspectList.add(Aspect.VOID, 3);
        ItemStack actIcon = AEPartsEnum.ArcaneCraftingTerminal.getStack();
        ResearchPage[] actPages = new ResearchPage[]{new ResearchPage(ResearchTypes.ARCANETERMINAL.getPageName(1)), new ResearchPage(RecipeRegistry.PART_ARCANE_TERMINAL)};
        ResearchTypes.ARCANETERMINAL.createResearchItem(actAspectList, 1, actIcon, actPages);
        ResearchTypes.ARCANETERMINAL.researchItem.setParents(new String[]{ResearchTypes.BASIC.getKey()});
        ResearchTypes.ARCANETERMINAL.researchItem.registerResearchItem();
    }

    private static void registerArcaneAssembler() {
        AspectList assemblerAspectList = new AspectList();
        assemblerAspectList.add(Aspect.CRAFT, 5);
        assemblerAspectList.add(Aspect.MECHANISM, 3);
        assemblerAspectList.add(Aspect.MIND, 3);
        assemblerAspectList.add(Aspect.EXCHANGE, 3);
        assemblerAspectList.add(Aspect.AURA, 3);
        assemblerAspectList.add(Aspect.GREED, 3);
        ItemStack assemblerIcon = ThEApi.instance().blocks().ArcaneAssembler.getStack();
        ResearchPage[] assemblerPages = new ResearchPage[]{new ResearchPage(ResearchTypes.ARCANEASSEMBLER.getPageName(1)), new ResearchPage(RecipeRegistry.BLOCK_ARCANE_ASSEMBLER), new ResearchPage(ResearchTypes.ARCANEASSEMBLER.getPageName(2)), new ResearchPage(ResearchTypes.ARCANEASSEMBLER.getPageName(3))};
        ResearchTypes.ARCANEASSEMBLER.createResearchItem(assemblerAspectList, 3, assemblerIcon, assemblerPages);
        ResearchTypes.ARCANEASSEMBLER.researchItem.setParents(new String[]{ResearchTypes.VISINTERFACE.getKey()});
        ResearchTypes.ARCANEASSEMBLER.researchItem.setParentsHidden(new String[]{ResearchTypes.ARCANETERMINAL.getKey()});
        ResearchTypes.ARCANEASSEMBLER.researchItem.setConcealed();
        ResearchTypes.ARCANEASSEMBLER.researchItem.setItemTriggers(new ItemStack[]{(ItemStack)AEApi.instance().definitions().blocks().molecularAssembler().maybeStack(1).get()});
        ResearchTypes.ARCANEASSEMBLER.researchItem.registerResearchItem();
    }

    private static void registerBasic() {
        ResearchTypes.BASIC.researchItem = new ResearchItem(ResearchTypes.BASIC.getKey(), TERESEARCH_TAB, new AspectList(), 0, 0, 0, TAB_ICON);
        ResearchTypes.BASIC.researchItem.setPages(new ResearchPage[]{new ResearchPage(ResearchTypes.BASIC.getPageName(1))});
        ResearchTypes.BASIC.researchItem.setStub().setRound().setAutoUnlock();
        ResearchTypes.BASIC.researchItem.registerResearchItem();
    }

    private static void registerCertusDupe() {
        AspectList certusDupeAspects = new AspectList();
        certusDupeAspects.add(Aspect.CRYSTAL, 5);
        ItemStack certusDupeIcon = (ItemStack)AEApi.instance().definitions().materials().certusQuartzCrystal().maybeStack(1).get();
        ResearchPage[] certusDupePages = new ResearchPage[]{new ResearchPage(ResearchTypes.CERTUSDUPE.getPageName(1)), new ResearchPage(RecipeRegistry.DUPE_CERTUS), new ResearchPage(RecipeRegistry.DUPE_NETHER_QUARTZ)};
        ResearchTypes.CERTUSDUPE.createResearchItem(certusDupeAspects, 1, certusDupeIcon, certusDupePages);
        ResearchTypes.CERTUSDUPE.researchItem.setParents(new String[]{PseudoResearchTypes.DUPE.getKey()});
        ResearchTypes.CERTUSDUPE.researchItem.setParentsHidden(new String[]{"ALCHEMICALDUPLICATION"});
        ResearchTypes.CERTUSDUPE.researchItem.setSecondary().setConcealed();
        ResearchTypes.CERTUSDUPE.researchItem.setItemTriggers(new ItemStack[]{certusDupeIcon});
        ResearchTypes.CERTUSDUPE.researchItem.registerResearchItem();
    }

    private static void registerCores() {
        AspectList coreAspectList = new AspectList();
        coreAspectList.add(Aspect.SLIME, 3);
        coreAspectList.add(Aspect.MAGIC, 5);
        coreAspectList.add(Aspect.MECHANISM, 5);
        coreAspectList.add(Aspect.EXCHANGE, 5);
        ItemStack coreIcon = ItemMaterial.MaterialTypes.COALESCENCE_CORE.getItemStack();
        ResearchPage[] corePages = new ResearchPage[]{new ResearchPage(ResearchTypes.CORES.getPageName(1)), new ResearchPage(ResearchTypes.CORES.getPageName(2)), new ResearchPage(RecipeRegistry.MATERIAL_COALESCENCE_CORE), new ResearchPage(RecipeRegistry.MATERIAL_DIFFUSION_CORE)};
        ResearchTypes.CORES.createResearchItem(coreAspectList, 2, coreIcon, corePages);
        ResearchTypes.CORES.researchItem.setParents(new String[]{ResearchTypes.BASIC.getKey(), PseudoResearchTypes.DISTILESSENTIA.getKey()});
        ResearchTypes.CORES.researchItem.setParentsHidden(new String[]{"DISTILESSENTIA"});
        ResearchTypes.CORES.researchItem.registerResearchItem();
    }

    private static void registerEssentiaProvider() {
        AspectList essentiaProviderList = new AspectList();
        essentiaProviderList.add(Aspect.MECHANISM, 3);
        essentiaProviderList.add(Aspect.MAGIC, 5);
        essentiaProviderList.add(Aspect.ORDER, 3);
        essentiaProviderList.add(Aspect.SENSES, 7);
        ItemStack essentiaProviderIcon = new ItemStack(BlockEnum.ESSENTIA_PROVIDER.getBlock(), 1);
        ResearchPage[] essentiaProviderPages = new ResearchPage[]{new ResearchPage(ResearchTypes.ESSENTIAPROVIDER.getPageName(1)), new ResearchPage(RecipeRegistry.BLOCK_ESSENTIA_PROVIDER)};
        ResearchTypes.ESSENTIAPROVIDER.createResearchItem(essentiaProviderList, 3, essentiaProviderIcon, essentiaProviderPages);
        ResearchTypes.ESSENTIAPROVIDER.researchItem.setParents(new String[]{ResearchTypes.IO.getKey()});
        ResearchTypes.ESSENTIAPROVIDER.researchItem.setParentsHidden(new String[]{"INFUSION", "TUBEFILTER"});
        ResearchTypes.ESSENTIAPROVIDER.researchItem.setConcealed();
        ResearchTypes.ESSENTIAPROVIDER.researchItem.registerResearchItem();
    }

    private static void registerEssentiaTerminal() {
        AspectList etAspectList = new AspectList();
        etAspectList.add(Aspect.EXCHANGE, 5);
        etAspectList.add(Aspect.SENSES, 5);
        etAspectList.add(Aspect.ENERGY, 3);
        etAspectList.add(Aspect.WATER, 3);
        ItemStack etIcon = AEPartsEnum.EssentiaTerminal.getStack();
        ResearchPage[] etPages = new ResearchPage[]{new ResearchPage(ResearchTypes.ESSENTIATERMINAL.getPageName(1)), new ResearchPage(RecipeRegistry.PART_ESSENTIA_TERMINAL), new ResearchPage(RecipeRegistry.WIRELESS_ESSENTIA_TERMINAL), new ResearchPage(RecipeRegistry.PART_ESSENTIA_LEVEL_EMITTER)};
        ResearchTypes.ESSENTIATERMINAL.createResearchItem(etAspectList, 1, etIcon, etPages);
        ResearchTypes.ESSENTIATERMINAL.researchItem.setParents(new String[]{ResearchTypes.CORES.getKey()});
        ResearchTypes.ESSENTIATERMINAL.researchItem.setConcealed();
        ResearchTypes.ESSENTIATERMINAL.researchItem.setSecondary();
        ResearchTypes.ESSENTIATERMINAL.researchItem.registerResearchItem();
    }

    private static void registerGearboxes() {
        AspectList igbAspects = new AspectList();
        igbAspects.add(Aspect.MECHANISM, 6);
        igbAspects.add(Aspect.METAL, 4);
        igbAspects.add(Aspect.EXCHANGE, 4);
        ItemStack igbIcon = ThEApi.instance().items().IronGear.getStack();
        ResearchPage[] igbPages = new ResearchPage[]{new ResearchPage(ResearchTypes.IRONGEARBOX.getPageName(1)), new ResearchPage(ResearchTypes.IRONGEARBOX.getPageName(2)), new ResearchPage(RecipeRegistry.MATERIAL_IRON_GEAR), new ResearchPage(RecipeRegistry.BLOCK_IRONGEARBOX)};
        ResearchTypes.IRONGEARBOX.createResearchItem(igbAspects, 1, igbIcon, igbPages);
        ResearchTypes.IRONGEARBOX.researchItem.setSecondary().registerResearchItem();
        AspectList tgbAspects = new AspectList();
        tgbAspects.add(Aspect.MECHANISM, 10);
        tgbAspects.add(Aspect.MAGIC, 8);
        tgbAspects.add(Aspect.METAL, 5);
        ItemStack tgbIcon = ThEApi.instance().blocks().ThaumiumGearBox.getStack();
        ResearchPage[] tgbPages = new ResearchPage[]{new ResearchPage(ResearchTypes.THAUMIUMGEARBOX.getPageName(1)), new ResearchPage(RecipeRegistry.BLOCK_THAUMIUMGEARBOX)};
        ResearchTypes.THAUMIUMGEARBOX.createResearchItem(tgbAspects, 1, tgbIcon, tgbPages);
        ResearchTypes.THAUMIUMGEARBOX.researchItem.setParents(new String[]{ResearchTypes.IRONGEARBOX.getKey(), PseudoResearchTypes.COREUSE.getKey()});
        ResearchTypes.THAUMIUMGEARBOX.researchItem.setParentsHidden(new String[]{"COREUSE"});
        ResearchTypes.THAUMIUMGEARBOX.researchItem.setSecondary().registerResearchItem();
    }

    private static void registerInfusionProvider() {
        AspectList infusionProviderList = new AspectList();
        infusionProviderList.add(Aspect.MECHANISM, 3);
        infusionProviderList.add(Aspect.MAGIC, 3);
        infusionProviderList.add(Aspect.EXCHANGE, 7);
        infusionProviderList.add(Aspect.MOTION, 7);
        infusionProviderList.add(Aspect.SENSES, 5);
        ItemStack infusionProviderIcon = new ItemStack(BlockEnum.INFUSION_PROVIDER.getBlock(), 1);
        ResearchPage[] infusionProviderPages = new ResearchPage[]{new ResearchPage(ResearchTypes.INFUSIONPROVIDER.getPageName(1)), new ResearchPage(RecipeRegistry.BLOCK_INFUSION_PROVIDER)};
        String researchKeyMirrorOrJar = Config.allowMirrors ? "MIRROR" : "JARLABEL";
        String pseudoKeyMirrorOrJar = Config.allowMirrors ? PseudoResearchTypes.MIRROR.getKey() : PseudoResearchTypes.JAR.getKey();
        ResearchTypes.INFUSIONPROVIDER.createResearchItem(infusionProviderList, 3, infusionProviderIcon, infusionProviderPages);
        ResearchTypes.INFUSIONPROVIDER.researchItem.setParents(new String[]{ResearchTypes.IO.getKey(), pseudoKeyMirrorOrJar, PseudoResearchTypes.INFUSION.getKey()});
        ResearchTypes.INFUSIONPROVIDER.researchItem.setParentsHidden(new String[]{researchKeyMirrorOrJar, "INFUSION"});
        ResearchTypes.INFUSIONPROVIDER.researchItem.setConcealed().setSpecial();
        ResearchTypes.INFUSIONPROVIDER.researchItem.registerResearchItem();
    }

    private static void registerIO() {
        AspectList ioAspectList = new AspectList();
        ioAspectList.add(Aspect.MECHANISM, 5);
        ioAspectList.add(Aspect.METAL, 3);
        ioAspectList.add(Aspect.CRYSTAL, 3);
        ioAspectList.add(Aspect.AIR, 3);
        ItemStack ioIcon = AEPartsEnum.EssentiaExportBus.getStack();
        ResearchPage[] ioPages = new ResearchPage[]{new ResearchPage(ResearchTypes.IO.getPageName(1)), new ResearchPage(ResearchTypes.IO.getPageName(2)), new ResearchPage(RecipeRegistry.PART_IMPORT_BUS), new ResearchPage(RecipeRegistry.PART_EXPORT_BUS), new ResearchPage(RecipeRegistry.PART_STORAGE_BUS)};
        ResearchTypes.IO.createResearchItem(ioAspectList, 2, ioIcon, ioPages);
        ResearchTypes.IO.researchItem.setParents(new String[]{ResearchTypes.CORES.getKey(), PseudoResearchTypes.TUBEFILTER.getKey()});
        ResearchTypes.IO.researchItem.setParentsHidden(new String[]{"TUBEFILTER"});
        ResearchTypes.IO.researchItem.setConcealed();
        ResearchTypes.IO.researchItem.registerResearchItem();
    }

    private static void registerKnowledgeInscriber() {
        AspectList kiAspectList = new AspectList();
        kiAspectList.add(Aspect.MIND, 5);
        kiAspectList.add(Aspect.MECHANISM, 3);
        kiAspectList.add(Aspect.CRAFT, 3);
        kiAspectList.add(Aspect.EXCHANGE, 1);
        ItemStack kiIcon = ThEApi.instance().blocks().KnowledgeInscriber.getStack();
        ResearchPage[] kiPages = new ResearchPage[]{new ResearchPage(ResearchTypes.KNOWLEDGEINSCRIBER.getPageName(1)), new ResearchPage(RecipeRegistry.ITEM_KNOWLEDGE_CORE), new ResearchPage(RecipeRegistry.BLOCK_KNOWLEDGE_INSCRIBER), new ResearchPage(ResearchTypes.KNOWLEDGEINSCRIBER.getPageName(2))};
        ResearchTypes.KNOWLEDGEINSCRIBER.createResearchItem(kiAspectList, 1, kiIcon, kiPages);
        ResearchTypes.KNOWLEDGEINSCRIBER.researchItem.setSecondary();
        ResearchTypes.KNOWLEDGEINSCRIBER.researchItem.setParents(new String[]{ResearchTypes.ARCANEASSEMBLER.getKey()});
        ResearchTypes.KNOWLEDGEINSCRIBER.researchItem.setConcealed();
        ResearchTypes.KNOWLEDGEINSCRIBER.researchItem.registerResearchItem();
    }

    private static void registerStorage() {
        String[] storageParents;
        AspectList storageAspectList = new AspectList();
        storageAspectList.add(Aspect.VOID, 5);
        storageAspectList.add(Aspect.ENERGY, 5);
        storageAspectList.add(Aspect.CRYSTAL, 3);
        storageAspectList.add(Aspect.METAL, 3);
        ItemStack storageIcon = ThEApi.instance().items().EssentiaCell_64k.getStack();
        IArcaneRecipe[] storageComponentRecipes = new IArcaneRecipe[]{RecipeRegistry.STORAGE_COMPONENT_4K, RecipeRegistry.STORAGE_COMPONENT_16K, RecipeRegistry.STORAGE_COMPONENT_64K};
        IRecipe[] storageCellsShaped = new IRecipe[]{RecipeRegistry.STORAGE_CELL_1K_SHAPED, RecipeRegistry.STORAGE_CELL_4K_SHAPED, RecipeRegistry.STORAGE_CELL_16K_SHAPED, RecipeRegistry.STORAGE_CELL_64K_SHAPED};
        IRecipe[] storageCellsShapeless = new IRecipe[]{RecipeRegistry.STORAGE_CELL_1K_SHAPELESS, RecipeRegistry.STORAGE_CELL_4K_SHAPELESS, RecipeRegistry.STORAGE_CELL_16K_SHAPELESS, RecipeRegistry.STORAGE_CELL_64K_SHAPELESS};
        ResearchPage[] storagePages = new ResearchPage[]{new ResearchPage(ResearchTypes.STORAGE.getPageName(1)), new ResearchPage(ResearchTypes.STORAGE.getPageName(2)), new ResearchPage(RecipeRegistry.STORAGE_COMPONENT_1K), new ResearchPage(storageComponentRecipes), new ResearchPage(RecipeRegistry.STORAGE_CASING), new ResearchPage(storageCellsShaped), new ResearchPage(storageCellsShapeless), new ResearchPage(RecipeRegistry.BLOCK_CELL_WORKBENCH)};
        if (Config.wardedStone) {
            storageParents = new String[3];
            storageParents[2] = PseudoResearchTypes.WARDED.getKey();
        } else {
            storageParents = new String[]{ResearchTypes.BASIC.getKey(), PseudoResearchTypes.DISTILESSENTIA.getKey()};
        }
        ResearchTypes.STORAGE.createResearchItem(storageAspectList, 2, storageIcon, storagePages);
        ResearchTypes.STORAGE.researchItem.setParents(storageParents);
        ResearchTypes.STORAGE.researchItem.setParentsHidden(new String[]{"DISTILESSENTIA"});
        ResearchTypes.STORAGE.researchItem.registerResearchItem();
    }

    private static void registerVisRelayInterface() {
        AspectList vriAspects = new AspectList();
        vriAspects.add(Aspect.AURA, 5);
        vriAspects.add(Aspect.ENERGY, 4);
        vriAspects.add(Aspect.VOID, 3);
        vriAspects.add(Aspect.MECHANISM, 2);
        ItemStack vriIcon = AEPartsEnum.VisInterface.getStack();
        ResearchPage[] vriPages = new ResearchPage[]{new ResearchPage(ResearchTypes.VISINTERFACE.getPageName(1)), new ResearchPage(RecipeRegistry.PART_VIS_INTERFACE), new ResearchPage(ResearchTypes.VISINTERFACE.getPageName(2)), new ResearchPage(ResearchTypes.VISINTERFACE.getPageName(3))};
        ResearchTypes.VISINTERFACE.createResearchItem(vriAspects, 2, vriIcon, vriPages);
        ResearchTypes.VISINTERFACE.researchItem.setParents(new String[]{ResearchTypes.BASIC.getKey(), PseudoResearchTypes.VISPOWER.getKey()});
        ResearchTypes.VISINTERFACE.researchItem.setParentsHidden(new String[]{"VISPOWER"});
        ResearchTypes.VISINTERFACE.researchItem.registerResearchItem();
    }

    private static void registerWrenchFocus() {
        AspectList focusAspects = new AspectList();
        focusAspects.add(Aspect.MECHANISM, 6);
        focusAspects.add(Aspect.TOOL, 5);
        focusAspects.add(Aspect.MAGIC, 3);
        ItemStack focusIcon = ThEApi.instance().items().WandFocusAEWrench.getStack();
        ResearchPage[] focusPages = new ResearchPage[]{new ResearchPage(ResearchTypes.FOCUSWRENCH.getPageName(1)), new ResearchPage(RecipeRegistry.ITEM_WRENCH_FOCUS)};
        ResearchTypes.FOCUSWRENCH.createResearchItem(focusAspects, 1, focusIcon, focusPages);
        ResearchTypes.FOCUSWRENCH.researchItem.setParents(new String[]{PseudoResearchTypes.FOCUSFIRE.getKey()}).setSecondary();
        ResearchTypes.FOCUSWRENCH.researchItem.registerResearchItem();
    }

    public static void registerResearch() {
        ResearchCategories.registerCategory((String)TERESEARCH_TAB, (ResourceLocation)TAB_ICON, (ResourceLocation)RESEARCH_BACKGROUND);
        ResearchRegistry.registerBasic();
        ResearchRegistry.registerACT();
        ResearchRegistry.registerCores();
        ResearchRegistry.registerStorage();
        ResearchRegistry.registerIO();
        ResearchRegistry.registerEssentiaTerminal();
        if (RecipeRegistry.MATERIAL_IRON_GEAR != null) {
            ResearchRegistry.registerGearboxes();
        }
        if (ThaumicEnergistics.config.allowedToCraftInfusionProvider()) {
            ResearchRegistry.registerInfusionProvider();
        }
        if (ThaumicEnergistics.config.allowedToCraftEssentiaProvider()) {
            ResearchRegistry.registerEssentiaProvider();
        }
        ResearchRegistry.registerVisRelayInterface();
        if (ThaumicEnergistics.config.allowedToDuplicateCertusQuartz()) {
            ResearchRegistry.registerCertusDupe();
        }
        ResearchRegistry.registerArcaneAssembler();
        ResearchRegistry.registerKnowledgeInscriber();
        if (ItemFocusAEWrench.isWrenchEnabled()) {
            ResearchRegistry.registerWrenchFocus();
        }
        ResearchRegistry.addPseudoParents();
    }

    public static enum ResearchTypes {
        BASIC("RESEARCH", 0, 0),
        CORES("CORES", -1, -2),
        STORAGE("STORAGE", -1, 2),
        IO("IO", -2, -2),
        ARCANETERMINAL("ARCANETERM", 0, -4),
        ESSENTIATERMINAL("ESSTERM", -1, -4),
        ESSENTIAPROVIDER("ESSPROV", -2, -4),
        INFUSIONPROVIDER("INFPROV", -5, -2),
        VISINTERFACE("VISINT", 2, 0),
        IRONGEARBOX("IRONGEARBOX", 3, 2),
        THAUMIUMGEARBOX("THAUMGBOX", 3, 3),
        CERTUSDUPE("CERTUSDUPE", -5, -5),
        ARCANEASSEMBLER("ARCANEASSEMBLER", 4, 0),
        KNOWLEDGEINSCRIBER("KNOWLEDGEINSCRIBER", 4, -2),
        FOCUSWRENCH("FOCUSWRENCH", -3, -7);

        private String internalName;
        private int column;
        private int row;
        ResearchItem researchItem;

        private ResearchTypes(String internalName, int column, int row) {
            this.internalName = "TE" + internalName;
            this.row = row;
            this.column = column;
        }

        public String getKey() {
            return "thaumicenergistics." + this.internalName;
        }

        public ResearchItem getResearchItem() {
            return this.researchItem;
        }

        void createResearchItem(AspectList aspectList, int complexity, ItemStack icon, ResearchPage[] pages) {
            this.researchItem = new ResearchItem(this.getKey(), ResearchRegistry.TERESEARCH_TAB, aspectList, this.column, this.row, complexity, icon);
            this.researchItem.setPages(pages);
        }

        String getPageName(int index) {
            return "thaumicenergistics.research_page." + this.internalName + "." + index;
        }
    }

    private static enum PseudoResearchTypes {
        DISTILESSENTIA("DISTILESSENTIA", "ALCHEMY", -2, 0),
        TUBEFILTER("TUBEFILTER", "ALCHEMY", -3, 0),
        MIRROR("MIRROR", "ARTIFICE", -4, 0),
        JAR("JARLABEL", "ALCHEMY", -4, 0),
        INFUSION("INFUSION", "ARTIFICE", -6, 0),
        VISPOWER("VISPOWER", "THAUMATURGY", 2, -1),
        COREUSE("COREUSE", "GOLEMANCY", 4, 3),
        DUPE("ALCHEMICALDUPLICATION", "ALCHEMY", -5, -6),
        WARDED("WARDEDARCANA", "ARTIFICE", 0, 2),
        FOCUSFIRE("FOCUSFIRE", "THAUMATURGY", -4, -7);

        private String realResearchKey;
        private String realResearchCategory;
        private int column;
        private int row;
        private PseudoResearchItem researchItem;

        private PseudoResearchTypes(String key, String cat, int column, int row) {
            this.realResearchCategory = cat;
            this.realResearchKey = key;
            this.column = column;
            this.row = row;
        }

        public String getKey() {
            return "thaumicenergistics.Pseudo." + this.realResearchKey;
        }

        public void registerPsudeoResearch() {
            this.researchItem = PseudoResearchItem.newPseudo(this.getKey(), ResearchRegistry.TERESEARCH_TAB, this.realResearchKey, this.realResearchCategory, this.column, this.row);
            this.researchItem.registerResearchItem();
        }
    }
}

