/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.parts;

import appeng.api.config.SecurityPermissions;
import appeng.api.config.SortDir;
import appeng.api.config.SortOrder;
import appeng.api.config.ViewItems;
import appeng.api.implementations.items.IMemoryCard;
import appeng.api.implementations.items.MemoryCardMessages;
import appeng.api.networking.IGridNode;
import appeng.api.networking.ticking.IGridTickable;
import appeng.api.networking.ticking.TickRateModulation;
import appeng.api.networking.ticking.TickingRequest;
import appeng.api.parts.IPartCollisionHelper;
import appeng.api.parts.IPartRenderHelper;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.ITerminalHost;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEItemStack;
import appeng.api.util.AEColor;
import appeng.api.util.IConfigManager;
import appeng.items.storage.ItemViewCell;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.IIcon;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.common.items.wands.ItemWandCasting;
import thaumicenergistics.container.ContainerPartArcaneCraftingTerminal;
import thaumicenergistics.gui.GuiArcaneCraftingTerminal;
import thaumicenergistics.integration.tc.DigiVisSourceData;
import thaumicenergistics.integration.tc.IDigiVisSource;
import thaumicenergistics.parts.AbstractAEPartBase;
import thaumicenergistics.registries.AEPartsEnum;
import thaumicenergistics.registries.EnumCache;
import thaumicenergistics.texture.BlockTextureManager;

public class AEPartArcaneCraftingTerminal
extends AbstractAEPartBase
implements IInventory,
IGridTickable,
ITerminalHost {
    private static final int MY_INVENTORY_SIZE = 16;
    public static final int WAND_SLOT_INDEX = 9;
    public static final int RESULT_SLOT_INDEX = 10;
    public static final int VIEW_SLOT_MIN = 11;
    public static final int VIEW_SLOT_MAX = 15;
    private static final String INVENTORY_NBT_KEY = "TEACT_Inventory";
    private static final String SLOT_NBT_KEY = "Slot#";
    private static final String SORT_ORDER_NBT_KEY = "SortOrder";
    private static final String SORT_DIRECTION_NBT_KEY = "SortDirection";
    private static final String VIEW_MODE_NBT_KEY = "ViewMode";
    private static final String VIS_INTERFACE_NBT_KEY = "VisInterface";
    private static final double IDLE_POWER_DRAIN = 0.5;
    private final ItemStack[] slots = new ItemStack[16];
    private List<ContainerPartArcaneCraftingTerminal> listeners = new ArrayList<ContainerPartArcaneCraftingTerminal>();
    private SortOrder sortingOrder = SortOrder.NAME;
    private SortDir sortingDirection = SortDir.ASCENDING;
    private ViewItems viewMode = ViewItems.ALL;
    private DigiVisSourceData visSourceInfo = new DigiVisSourceData();

    public AEPartArcaneCraftingTerminal() {
        super(AEPartsEnum.ArcaneCraftingTerminal);
    }

    public static boolean isItemValidCraftingWand(ItemStack stack) {
        if (stack == null) {
            return false;
        }
        Item item = stack.func_77973_b();
        if (item == null) {
            return false;
        }
        if (!(item instanceof ItemWandCasting)) {
            return false;
        }
        return !((ItemWandCasting)item).isStaff(stack);
    }

    private boolean isSlotInRange(int slotIndex) {
        return slotIndex >= 0 && slotIndex < 16;
    }

    private void notifyListeners(int slotIndex) {
        boolean notifyCrafting = slotIndex <= 10;
        for (ContainerPartArcaneCraftingTerminal listener : this.listeners) {
            if (listener == null) continue;
            if (notifyCrafting) {
                listener.func_75130_a(this);
                continue;
            }
            listener.onViewCellChange();
        }
    }

    @Override
    protected boolean canPlayerOpenGui(int playerID) {
        return this.doesPlayerHaveSecurityClearance(playerID, SecurityPermissions.EXTRACT) && this.doesPlayerHaveSecurityClearance(playerID, SecurityPermissions.INJECT);
    }

    @Override
    public int cableConnectionRenderTo() {
        return 3;
    }

    public void func_70305_f() {
    }

    public ItemStack func_70298_a(int slotIndex, int amount) {
        ItemStack slotStack;
        ItemStack returnStack = null;
        if (this.isSlotInRange(slotIndex) && (slotStack = this.slots[slotIndex]) != null) {
            if (amount >= slotStack.field_77994_a) {
                returnStack = slotStack.func_77946_l();
                this.slots[slotIndex].field_77994_a = 0;
            } else {
                returnStack = slotStack.func_77979_a(amount);
            }
            if (this.slots[slotIndex].field_77994_a == 0) {
                this.slots[slotIndex] = null;
            }
            this.notifyListeners(slotIndex);
        }
        return returnStack;
    }

    @Override
    public void getBoxes(IPartCollisionHelper helper) {
        helper.addBox(2.0, 2.0, 14.0, 14.0, 14.0, 16.0);
        helper.addBox(5.0, 5.0, 13.0, 11.0, 11.0, 14.0);
    }

    @Override
    public IIcon getBreakingTexture() {
        return BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[0];
    }

    @Override
    public Object getClientGuiElement(EntityPlayer player) {
        return new GuiArcaneCraftingTerminal(this, player);
    }

    public IConfigManager getConfigManager() {
        return null;
    }

    @Override
    public void getDrops(List<ItemStack> drops, boolean wrenched) {
        if (wrenched) {
            return;
        }
        for (int slotIndex = 0; slotIndex < 16; ++slotIndex) {
            ItemStack slotStack;
            if (slotIndex == 10 || (slotStack = this.slots[slotIndex]) == null) continue;
            drops.add(slotStack);
        }
    }

    public IMEMonitor<IAEFluidStack> getFluidInventory() {
        return this.getGridBlock().getFluidMonitor();
    }

    @Override
    public double getIdlePowerUsage() {
        return 0.5;
    }

    public String func_145825_b() {
        return "thaumicenergistics.arcane.crafting.terminal.inventory";
    }

    public int func_70297_j_() {
        return 64;
    }

    public IMEMonitor<IAEItemStack> getItemInventory() {
        return this.getGridBlock().getItemMonitor();
    }

    @Override
    public int getLightLevel() {
        return this.isActive ? 10 : 0;
    }

    @Override
    public Object getServerGuiElement(EntityPlayer player) {
        return new ContainerPartArcaneCraftingTerminal(this, player);
    }

    public int func_70302_i_() {
        return 16;
    }

    public SortDir getSortingDirection() {
        return this.sortingDirection;
    }

    public SortOrder getSortingOrder() {
        return this.sortingOrder;
    }

    public ItemStack func_70301_a(int slotIndex) {
        if (this.isSlotInRange(slotIndex)) {
            return this.slots[slotIndex];
        }
        return null;
    }

    public ItemStack func_70304_b(int slotIndex) {
        if (this.isSlotInRange(slotIndex)) {
            return this.slots[slotIndex];
        }
        return null;
    }

    public TickingRequest getTickingRequest(IGridNode grid) {
        return new TickingRequest(2, 20, false, false);
    }

    public ViewItems getViewMode() {
        return this.viewMode;
    }

    public World getWorldObj() {
        return this.hostTile.func_145831_w();
    }

    public boolean func_145818_k_() {
        return true;
    }

    public boolean func_94041_b(int slotIndex, ItemStack proposedStack) {
        if (this.isSlotInRange(slotIndex)) {
            if (proposedStack == null) {
                return true;
            }
            if (slotIndex == 9) {
                return AEPartArcaneCraftingTerminal.isItemValidCraftingWand(proposedStack);
            }
            if (slotIndex >= 11 && slotIndex <= 15) {
                return proposedStack.func_77973_b() instanceof ItemViewCell;
            }
            return true;
        }
        return false;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return true;
    }

    public void func_70296_d() {
        this.hostTile.func_70296_d();
    }

    @Override
    public boolean onActivate(EntityPlayer player, Vec3 position) {
        ItemStack playerHolding = player.field_71071_by.func_70448_g();
        if (playerHolding != null && playerHolding.func_77973_b() instanceof IMemoryCard) {
            IMemoryCard memoryCard = (IMemoryCard)playerHolding.func_77973_b();
            String settingsName = memoryCard.getSettingsName(playerHolding);
            if (settingsName.equals(DigiVisSourceData.SOURCE_UNLOC_NAME)) {
                NBTTagCompound data = memoryCard.getData(playerHolding);
                this.visSourceInfo.readFromNBT(data);
                memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_LOADED);
                this.func_70296_d();
            } else if (settingsName.equals("gui.appliedenergistics2.Blank")) {
                this.visSourceInfo.clearData();
                memoryCard.notifyUser(player, MemoryCardMessages.SETTINGS_CLEARED);
                this.func_70296_d();
            }
            return true;
        }
        return super.onActivate(player, position);
    }

    public void func_70295_k_() {
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        if (data.func_74764_b(INVENTORY_NBT_KEY)) {
            NBTTagList nbtTagList = (NBTTagList)data.func_74781_a(INVENTORY_NBT_KEY);
            for (int listIndex = 0; listIndex < nbtTagList.func_74745_c(); ++listIndex) {
                NBTTagCompound nbtCompound = nbtTagList.func_150305_b(listIndex);
                byte slotIndex = nbtCompound.func_74771_c(SLOT_NBT_KEY);
                if (!this.isSlotInRange(slotIndex)) continue;
                this.slots[slotIndex] = ItemStack.func_77949_a((NBTTagCompound)nbtCompound);
            }
        }
        if (data.func_74764_b(SORT_ORDER_NBT_KEY)) {
            this.sortingOrder = EnumCache.AE_SORT_ORDERS[data.func_74762_e(SORT_ORDER_NBT_KEY)];
        }
        if (data.func_74764_b(SORT_DIRECTION_NBT_KEY)) {
            this.sortingDirection = EnumCache.AE_SORT_DIRECTIONS[data.func_74762_e(SORT_DIRECTION_NBT_KEY)];
        }
        if (data.func_74764_b(VIEW_MODE_NBT_KEY)) {
            this.viewMode = EnumCache.AE_VIEW_ITEMS[data.func_74762_e(VIEW_MODE_NBT_KEY)];
        }
        this.visSourceInfo.readFromNBT(data, VIS_INTERFACE_NBT_KEY);
    }

    public void registerListener(ContainerPartArcaneCraftingTerminal container) {
        if (!this.listeners.contains((Object)container)) {
            this.listeners.add(container);
        }
    }

    public void removeListener(ContainerPartArcaneCraftingTerminal container) {
        this.listeners.remove((Object)container);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderInventory(IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator ts = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[3];
        helper.setTexture(side, side, side, BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[0], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderInventoryBox(renderer);
        helper.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
        ts.func_78378_d(AbstractAEPartBase.INVENTORY_OVERLAY_COLOR);
        helper.renderInventoryFace(BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
        ts.func_78378_d(AEColor.Black.mediumVariant);
        helper.renderInventoryFace(BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderInventoryBusLights(helper, renderer);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void renderStatic(int x, int y, int z, IPartRenderHelper helper, RenderBlocks renderer) {
        Tessellator tessellator = Tessellator.field_78398_a;
        IIcon side = BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[3];
        helper.setTexture(side, side, side, BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[0], side, side);
        helper.setBounds(2.0f, 2.0f, 14.0f, 14.0f, 14.0f, 16.0f);
        helper.renderBlock(x, y, z, renderer);
        if (this.isActive()) {
            tessellator.func_78380_c(0xD000D0);
            helper.setBounds(2.0f, 2.0f, 15.0f, 14.0f, 14.0f, 16.0f);
            tessellator.func_78378_d(this.host.getColor().blackVariant);
            helper.renderFace(x, y, z, BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[2], ForgeDirection.SOUTH, renderer);
            tessellator.func_78378_d(this.host.getColor().mediumVariant);
            helper.renderFace(x, y, z, BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[1], ForgeDirection.SOUTH, renderer);
            tessellator.func_78380_c(0xA000A0);
            tessellator.func_78378_d(AEColor.Lime.blackVariant);
            helper.renderFace(x, y, z, BlockTextureManager.ARCANE_CRAFTING_TERMINAL.getTextures()[4], ForgeDirection.SOUTH, renderer);
        }
        helper.setBounds(5.0f, 5.0f, 13.0f, 11.0f, 11.0f, 14.0f);
        this.renderStaticBusLights(x, y, z, helper, renderer);
    }

    public void func_70299_a(int slotIndex, ItemStack slotStack) {
        if (this.setInventorySlotContentsWithoutNotify(slotIndex, slotStack)) {
            this.notifyListeners(slotIndex);
        }
    }

    public boolean setInventorySlotContentsWithoutNotify(int slotIndex, ItemStack slotStack) {
        if (this.isSlotInRange(slotIndex)) {
            this.slots[slotIndex] = slotStack;
            return true;
        }
        return false;
    }

    public void setSorts(SortOrder order, SortDir dir, ViewItems viewMode) {
        this.sortingDirection = dir;
        this.sortingOrder = order;
        this.viewMode = viewMode;
        this.func_70296_d();
    }

    public TickRateModulation tickingRequest(IGridNode node, int TicksSinceLastCall) {
        if (this.gridBlock == null || !this.visSourceInfo.getHasData()) {
            return TickRateModulation.IDLE;
        }
        ItemStack stack = this.func_70301_a(9);
        if (stack == null) {
            return TickRateModulation.IDLE;
        }
        ItemWandCasting wand = (ItemWandCasting)stack.func_77973_b();
        AspectList neededVis = wand.getAspectsWithRoom(stack);
        if (neededVis.size() <= 0) {
            return TickRateModulation.IDLE;
        }
        IDigiVisSource visSource = this.visSourceInfo.tryGetSource(this.gridBlock.getGrid());
        if (visSource == null) {
            return TickRateModulation.IDLE;
        }
        for (Aspect vis : neededVis.getAspects()) {
            int amountToDrain = wand.getMaxVis(stack) - wand.getVis(stack, vis);
            int amountDrained = visSource.consumeVis(vis, amountToDrain);
            if (amountDrained <= 0) continue;
            wand.addRealVis(stack, vis, amountDrained, true);
        }
        return TickRateModulation.URGENT;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        NBTTagList nbtList = new NBTTagList();
        for (int slotId = 0; slotId < 16; ++slotId) {
            if (this.slots[slotId] == null) continue;
            NBTTagCompound nbtCompound = new NBTTagCompound();
            nbtCompound.func_74774_a(SLOT_NBT_KEY, (byte)slotId);
            this.slots[slotId].func_77955_b(nbtCompound);
            nbtList.func_74742_a((NBTBase)nbtCompound);
        }
        data.func_74782_a(INVENTORY_NBT_KEY, (NBTBase)nbtList);
        data.func_74768_a(SORT_DIRECTION_NBT_KEY, this.sortingDirection.ordinal());
        data.func_74768_a(SORT_ORDER_NBT_KEY, this.sortingOrder.ordinal());
        data.func_74768_a(VIEW_MODE_NBT_KEY, this.viewMode.ordinal());
        this.visSourceInfo.writeToNBT(data, VIS_INTERFACE_NBT_KEY);
    }
}

