/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.network.packet.AbstractServerPacket;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;

public class PacketServerEssentiaStorageBus
extends AbstractServerPacket {
    private static final byte MODE_REQUEST_FULL_UPDATE = 0;
    private static final byte MODE_REQUEST_SET_VOID = 1;
    private AEPartEssentiaStorageBus part;
    private boolean isVoidAllowed;

    public PacketServerEssentiaStorageBus createRequestFullUpdate(EntityPlayer player, AEPartEssentiaStorageBus part) {
        this.player = player;
        this.mode = 0;
        this.part = part;
        return this;
    }

    public PacketServerEssentiaStorageBus createRequestSetVoidAllowed(EntityPlayer player, AEPartEssentiaStorageBus part, boolean isVoidAllowed) {
        this.player = player;
        this.mode = 1;
        this.part = part;
        this.isVoidAllowed = isVoidAllowed;
        return this;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                this.part.onClientRequestFullUpdate(this.player);
                break;
            }
            case 1: {
                this.part.onClientRequestSetVoidMode(this.player, this.isVoidAllowed);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.part = (AEPartEssentiaStorageBus)AbstractPacket.readPart(stream);
                break;
            }
            case 1: {
                this.part = (AEPartEssentiaStorageBus)AbstractPacket.readPart(stream);
                this.isVoidAllowed = stream.readBoolean();
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                AbstractPacket.writePart(this.part, stream);
                break;
            }
            case 1: {
                AbstractPacket.writePart(this.part, stream);
                stream.writeBoolean(this.isVoidAllowed);
            }
        }
    }
}

