/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.network.packet.server;

import io.netty.buffer.ByteBuf;
import net.minecraft.entity.player.EntityPlayer;
import thaumcraft.api.aspects.Aspect;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.container.AbstractContainerCellTerminalBase;
import thaumicenergistics.network.packet.AbstractPacket;
import thaumicenergistics.network.packet.AbstractServerPacket;

public class PacketServerEssentiaCellTerminal
extends AbstractServerPacket {
    private static final byte MODE_SELECTED_ASPECT = 0;
    private static final byte MODE_FULL_UPDATE = 1;
    private static final byte MODE_SORT_CHANGE = 2;
    private Aspect currentAspect;
    private AspectStackComparator.ComparatorMode sortMode;

    public PacketServerEssentiaCellTerminal createFullUpdateRequest(EntityPlayer player) {
        this.player = player;
        this.mode = 1;
        return this;
    }

    public PacketServerEssentiaCellTerminal createRequestChangeSortMode(EntityPlayer player, AspectStackComparator.ComparatorMode sortMode) {
        this.player = player;
        this.mode = (byte)2;
        this.sortMode = sortMode;
        return this;
    }

    public PacketServerEssentiaCellTerminal createUpdateSelectedAspect(EntityPlayer player, Aspect currentAspect) {
        this.player = player;
        this.mode = 0;
        this.currentAspect = currentAspect;
        return this;
    }

    @Override
    public void execute() {
        switch (this.mode) {
            case 0: {
                if (this.player == null || !(this.player.field_71070_bA instanceof AbstractContainerCellTerminalBase)) break;
                ((AbstractContainerCellTerminalBase)this.player.field_71070_bA).onReceivedSelectedAspect(this.currentAspect);
                break;
            }
            case 1: {
                if (this.player == null || !(this.player.field_71070_bA instanceof AbstractContainerCellTerminalBase)) break;
                ((AbstractContainerCellTerminalBase)this.player.field_71070_bA).onClientRequestFullUpdate();
                break;
            }
            case 2: {
                if (this.player == null || !(this.player.field_71070_bA instanceof AbstractContainerCellTerminalBase)) break;
                ((AbstractContainerCellTerminalBase)this.player.field_71070_bA).onClientRequestSortModeChange(this.sortMode, this.player);
            }
        }
    }

    @Override
    public void readData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                this.currentAspect = AbstractPacket.readAspect(stream);
                break;
            }
            case 2: {
                this.sortMode = AspectStackComparator.ComparatorMode.VALUES[stream.readInt()];
            }
        }
    }

    @Override
    public void writeData(ByteBuf stream) {
        switch (this.mode) {
            case 0: {
                AbstractPacket.writeAspect(this.currentAspect, stream);
                break;
            }
            case 2: {
                stream.writeInt(this.sortMode.ordinal());
            }
        }
    }
}

