/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.items;

import appeng.api.AEApi;
import appeng.api.implementations.tiles.IChestOrDrive;
import appeng.api.implementations.tiles.IMEChest;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.security.IActionHost;
import appeng.api.networking.security.PlayerSource;
import appeng.api.storage.ICellHandler;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEInventoryHandler;
import appeng.api.storage.ISaveProvider;
import appeng.api.storage.IStorageMonitorable;
import appeng.api.storage.StorageChannel;
import appeng.core.localization.GuiText;
import java.util.Collections;
import java.util.List;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumRarity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.input.Keyboard;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.aspect.AspectStackComparator;
import thaumicenergistics.gui.ThEGuiHandler;
import thaumicenergistics.inventory.HandlerItemEssentiaCell;
import thaumicenergistics.inventory.HandlerItemEssentiaCellCreative;
import thaumicenergistics.items.AbstractStorageBase;
import thaumicenergistics.registries.ItemEnum;
import thaumicenergistics.registries.ThEStrings;
import thaumicenergistics.texture.BlockTextureManager;

public class ItemEssentiaCell
extends AbstractStorageBase
implements ICellHandler {
    private static final double[] IDLE_DRAIN_AMOUNTS = new double[]{0.5, 1.0, 1.5, 2.0, 0.0};
    private static final int MAX_TYPES = 12;
    private static final int CREATIVE_MAX_TYPES = 63;
    private static final int CELL_STATUS_MISSING = 0;
    private static final int CELL_STATUS_HAS_ROOM = 1;
    private static final int CELL_STATUS_TYPES_FULL = 2;
    private static final int CELL_STATUS_FULL = 3;
    private IIcon[] icons;

    public ItemEssentiaCell() {
        AEApi.instance().registries().cell().addCellHandler((ICellHandler)this);
        this.func_77625_d(1);
        this.func_77656_e(0);
        this.func_77627_a(true);
    }

    private void addContentsToCellDescription(HandlerItemEssentiaCell cellHandler, List displayList, EntityPlayer player) {
        List<AspectStack> cellAspects = cellHandler.getStoredEssentia();
        Collections.sort(cellAspects, new AspectStackComparator());
        for (AspectStack currentStack : cellAspects) {
            if (currentStack == null) continue;
            String aspectChatColor = currentStack.getChatColor();
            if (aspectChatColor == null) {
                aspectChatColor = EnumChatFormatting.WHITE.toString();
            }
            String aspectInfo = String.format("%s%s%s x %d", aspectChatColor, currentStack.getAspectName(player), EnumChatFormatting.WHITE.toString(), currentStack.amount);
            displayList.add(aspectInfo);
        }
    }

    public void func_77624_a(ItemStack essentiaCell, EntityPlayer player, List displayList, boolean advancedItemTooltips) {
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(essentiaCell, null, StorageChannel.FLUIDS);
        if (!(handler instanceof HandlerItemEssentiaCell)) {
            return;
        }
        HandlerItemEssentiaCell cellHandler = (HandlerItemEssentiaCell)handler;
        String bytesTip = String.format(ThEStrings.Tooltip_CellBytes.getLocalized(), cellHandler.getUsedBytes(), cellHandler.getTotalBytes());
        String typesTip = String.format(ThEStrings.Tooltip_CellTypes.getLocalized(), cellHandler.getUsedTypes(), cellHandler.getTotalTypes());
        displayList.add(bytesTip);
        displayList.add(typesTip);
        if (cellHandler.isPartitioned()) {
            displayList.add(GuiText.Partitioned.getLocal());
        }
        if (cellHandler.getUsedTypes() > 0) {
            if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
                this.addContentsToCellDescription(cellHandler, displayList, player);
            } else {
                displayList.add(EnumChatFormatting.WHITE.toString() + EnumChatFormatting.ITALIC.toString() + ThEStrings.Tooltip_CellDetails.getLocalized());
            }
        }
    }

    public double cellIdleDrain(ItemStack itemStack, IMEInventory handler) {
        return IDLE_DRAIN_AMOUNTS[itemStack.func_77960_j()];
    }

    public IMEInventoryHandler getCellInventory(ItemStack essentiaCell, ISaveProvider saveProvider, StorageChannel channel) {
        if (channel != StorageChannel.FLUIDS || essentiaCell.func_77973_b() != this) {
            return null;
        }
        if (essentiaCell.func_77960_j() == 4) {
            return new HandlerItemEssentiaCellCreative(essentiaCell, saveProvider);
        }
        return new HandlerItemEssentiaCell(essentiaCell, saveProvider);
    }

    public IIcon func_77617_a(int dmg) {
        int index = MathHelper.func_76125_a((int)dmg, (int)0, (int)AbstractStorageBase.SIZES.length);
        return this.icons[index];
    }

    public EnumRarity func_77613_e(ItemStack itemStack) {
        int index = MathHelper.func_76125_a((int)itemStack.func_77960_j(), (int)0, (int)AbstractStorageBase.RARITIES.length);
        return AbstractStorageBase.RARITIES[index];
    }

    public int getStatusForCell(ItemStack essentiaCell, IMEInventory handler) {
        if (handler == null) {
            return 0;
        }
        HandlerItemEssentiaCell cellHandler = (HandlerItemEssentiaCell)handler;
        if (cellHandler.isCreative()) {
            return 2;
        }
        if (cellHandler.getUsedBytes() == cellHandler.getTotalBytes()) {
            return 3;
        }
        if (cellHandler.getUsedTypes() == cellHandler.getTotalTypes()) {
            return 2;
        }
        return 1;
    }

    public void func_150895_a(Item item, CreativeTabs creativeTab, List listSubItems) {
        for (int i = 0; i < AbstractStorageBase.SIZES.length; ++i) {
            listSubItems.add(new ItemStack(item, 1, i));
        }
    }

    public IIcon getTopTexture_Dark() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[0];
    }

    public IIcon getTopTexture_Light() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[2];
    }

    public IIcon getTopTexture_Medium() {
        return BlockTextureManager.ESSENTIA_TERMINAL.getTextures()[1];
    }

    public String func_77658_a() {
        return "thaumicenergistics.item.essentia.cell";
    }

    public String func_77667_c(ItemStack itemStack) {
        switch (itemStack.func_77960_j()) {
            case 0: {
                return ThEStrings.Item_EssentiaCell_1k.getUnlocalized();
            }
            case 1: {
                return ThEStrings.Item_EssentiaCell_4k.getUnlocalized();
            }
            case 2: {
                return ThEStrings.Item_EssentiaCell_16k.getUnlocalized();
            }
            case 3: {
                return ThEStrings.Item_EssentiaCell_64k.getUnlocalized();
            }
            case 4: {
                return ThEStrings.Item_EssentiaCell_Creative.getUnlocalized();
            }
        }
        return "";
    }

    public boolean isCell(ItemStack itemStack) {
        return itemStack.func_77973_b() == this;
    }

    public int maxStorage(ItemStack essentiaCell) {
        return AbstractStorageBase.SIZES[Math.max(0, essentiaCell.func_77960_j())];
    }

    public int maxTypes(ItemStack essentiaCell) {
        if (essentiaCell.func_77960_j() == 4) {
            return 63;
        }
        return 12;
    }

    public ItemStack func_77659_a(ItemStack essentiaCell, World world, EntityPlayer player) {
        if (!player.func_70093_af()) {
            return essentiaCell;
        }
        if (essentiaCell.func_77960_j() == 4) {
            return essentiaCell;
        }
        IMEInventoryHandler handler = AEApi.instance().registries().cell().getCellInventory(essentiaCell, null, StorageChannel.FLUIDS);
        if (!(handler instanceof HandlerItemEssentiaCell)) {
            return essentiaCell;
        }
        HandlerItemEssentiaCell cellHandler = (HandlerItemEssentiaCell)handler;
        if (cellHandler.getUsedBytes() == 0L && player.field_71071_by.func_70441_a(ItemEnum.STORAGE_CASING.getItemStackWithSize(1))) {
            return ItemEnum.STORAGE_COMPONENT.getItemStackWithDamage(essentiaCell.func_77960_j());
        }
        return essentiaCell;
    }

    public void openChestGui(EntityPlayer player, IChestOrDrive chest, ICellHandler cellHandler, IMEInventoryHandler inv, ItemStack itemStack, StorageChannel channel) {
        IStorageMonitorable monitorable;
        if (channel != StorageChannel.FLUIDS) {
            return;
        }
        if (chest != null && (monitorable = ((IMEChest)chest).getMonitorable(ForgeDirection.UNKNOWN, (BaseActionSource)new PlayerSource(player, (IActionHost)chest))) != null) {
            TileEntity chestEntity = (TileEntity)chest;
            ThEGuiHandler.launchGui(10, player, chestEntity.func_145831_w(), chestEntity.field_145851_c, chestEntity.field_145848_d, chestEntity.field_145849_e);
        }
    }

    public void func_94581_a(IIconRegister iconRegister) {
        this.icons = new IIcon[AbstractStorageBase.SUFFIXES.length];
        for (int i = 0; i < AbstractStorageBase.SUFFIXES.length; ++i) {
            this.icons[i] = iconRegister.func_94245_a("thaumicenergistics:essentia.cell." + AbstractStorageBase.SUFFIXES[i]);
        }
    }
}

