/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.inventory;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.IncludeExclude;
import appeng.api.networking.IGridNode;
import appeng.api.networking.events.MENetworkCellArrayUpdate;
import appeng.api.networking.events.MENetworkEvent;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.networking.storage.IBaseMonitor;
import appeng.api.storage.IMEInventory;
import appeng.api.storage.IMEMonitor;
import appeng.api.storage.IMEMonitorHandlerReceiver;
import appeng.api.storage.StorageChannel;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import appeng.me.storage.MEInventoryHandler;
import appeng.tile.misc.TileInterface;
import appeng.util.Platform;
import net.minecraft.tileentity.TileEntity;
import thaumicenergistics.inventory.AbstractHandlerEssentiaStorageBus;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;

class HandlerEssentiaStorageBusInterface
extends AbstractHandlerEssentiaStorageBus
implements IMEMonitorHandlerReceiver<IAEFluidStack> {
    private TileInterface MEInterface = null;
    private MEInventoryHandler<IAEFluidStack> handler;
    private int handlerHash;
    private boolean canPostUpdate = true;
    private boolean haltChanges = false;

    public HandlerEssentiaStorageBusInterface(AEPartEssentiaStorageBus part) {
        super(part);
    }

    @Override
    public boolean canAccept(IAEFluidStack fluidStack) {
        if (this.isFluidEssentiaGas(fluidStack) && this.handler != null) {
            return this.handler.canAccept((IAEStack)fluidStack);
        }
        return false;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource source) {
        if (this.isFluidEssentiaGas(request) && this.handler != null) {
            this.haltChanges = true;
            IAEFluidStack extractedGas = (IAEFluidStack)this.handler.extractItems((IAEStack)request, mode, source);
            this.haltChanges = false;
            return extractedGas;
        }
        return null;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        if (this.handler != null) {
            IItemList subGridFluids = this.handler.getAvailableItems(AEApi.instance().storage().createFluidList());
            for (IAEFluidStack fluid : subGridFluids) {
                if (!this.isFluidEssentiaGas(fluid)) continue;
                out.add((IAEStack)fluid);
            }
        }
        return out;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource source) {
        if (this.isFluidEssentiaGas(input) && this.handler != null) {
            this.haltChanges = true;
            IAEFluidStack remainingGas = (IAEFluidStack)this.handler.injectItems((IAEStack)input, mode, source);
            this.haltChanges = false;
            return remainingGas;
        }
        return input;
    }

    public boolean isValid(Object verificationToken) {
        return this.handler == verificationToken;
    }

    public void onListUpdate() {
        if (this.canPostUpdate) {
            this.canPostUpdate = false;
            try {
                this.partStorageBus.getGridBlock().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean onNeighborChange() {
        TileEntity tileEntity = this.getFaceingTile();
        if (tileEntity instanceof TileInterface) {
            int newHandlerHash = Platform.generateTileHash((TileEntity)tileEntity);
            if (this.handlerHash == newHandlerHash && this.handlerHash != 0) {
                return false;
            }
            try {
                this.partStorageBus.getGridBlock().getGrid().postEvent((MENetworkEvent)new MENetworkCellArrayUpdate());
            }
            catch (Exception e) {
                // empty catch block
            }
            this.handlerHash = newHandlerHash;
            this.MEInterface = (TileInterface)tileEntity;
            this.handler = null;
            IMEMonitor inv = this.MEInterface.getFluidInventory();
            if (inv != null) {
                this.handler = new MEInventoryHandler((IMEInventory)inv, StorageChannel.FLUIDS);
                this.handler.setBaseAccess(this.getAccess());
                this.handler.setWhitelist(IncludeExclude.WHITELIST);
                this.handler.setPriority(this.getPriority());
                if (inv instanceof IMEMonitor) {
                    inv.addListener((IMEMonitorHandlerReceiver)this, this.handler);
                }
            }
            return true;
        }
        this.handlerHash = 0;
        this.MEInterface = null;
        if (this.handler != null) {
            this.handler = null;
            return true;
        }
        return false;
    }

    public void postChange(IBaseMonitor<IAEFluidStack> monitor, Iterable<IAEFluidStack> change, BaseActionSource actionSource) {
        if (this.haltChanges) {
            return;
        }
        this.postAlterationToHostGrid(change);
        this.haltChanges = true;
    }

    @Override
    public void tickingRequest(IGridNode node, int TicksSinceLastCall) {
        this.canPostUpdate = true;
    }

    @Override
    public boolean validForPass(int pass) {
        if (this.handler != null) {
            return this.handler.validForPass(pass);
        }
        return false;
    }
}

