/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.inventory;

import appeng.api.AEApi;
import appeng.api.config.Actionable;
import appeng.api.config.PowerMultiplier;
import appeng.api.networking.IGridNode;
import appeng.api.networking.energy.IEnergyGrid;
import appeng.api.networking.security.BaseActionSource;
import appeng.api.storage.data.IAEFluidStack;
import appeng.api.storage.data.IAEStack;
import appeng.api.storage.data.IItemList;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.fluids.FluidStack;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.IAspectContainer;
import thaumcraft.common.tiles.TileEssentiaReservoir;
import thaumcraft.common.tiles.TileJarFillableVoid;
import thaumicenergistics.aspect.AspectStack;
import thaumicenergistics.fluids.GaseousEssentia;
import thaumicenergistics.integration.tc.EssentiaConversionHelper;
import thaumicenergistics.integration.tc.EssentiaTileContainerHelper;
import thaumicenergistics.inventory.AbstractHandlerEssentiaStorageBus;
import thaumicenergistics.parts.AEPartEssentiaStorageBus;

class HandlerEssentiaStorageBusContainer
extends AbstractHandlerEssentiaStorageBus {
    private static final double POWER_DRAIN_PER_ESSENTIA = 0.5;
    private IAspectContainer aspectContainer;

    public HandlerEssentiaStorageBusContainer(AEPartEssentiaStorageBus part) {
        super(part);
    }

    private boolean allowAny() {
        for (Aspect filteredAspect : this.filteredAspects) {
            if (filteredAspect == null) continue;
            return false;
        }
        return true;
    }

    private List<AspectStack> getAvailableEssentia() {
        if (this.aspectContainer == null) {
            return null;
        }
        if (!TEAPI.transportPermissions().canExtractFromAspectContainerTile(this.aspectContainer)) {
            return null;
        }
        List<AspectStack> containerStacks = EssentiaTileContainerHelper.instance.getAspectStacksFromContainer(this.aspectContainer);
        if (containerStacks == null || containerStacks.isEmpty()) {
            return null;
        }
        ArrayList<AspectStack> essentiaList = new ArrayList<AspectStack>();
        boolean skipFilterCheck = this.allowAny();
        for (AspectStack essentia : containerStacks) {
            GaseousEssentia gas;
            if (!skipFilterCheck && !this.filteredAspects.contains(essentia.aspect) || (gas = GaseousEssentia.getGasFromAspect(essentia.aspect)) == null) continue;
            essentiaList.add(new AspectStack(essentia.aspect, essentia.amount));
        }
        return essentiaList;
    }

    private boolean takePowerFromNetwork(int essentiaAmount, Actionable mode) {
        IEnergyGrid eGrid = this.partStorageBus.getGridBlock().getEnergyGrid();
        if (eGrid == null) {
            return false;
        }
        double powerDrain = 0.5 * (double)essentiaAmount;
        return eGrid.extractAEPower(powerDrain, mode, PowerMultiplier.CONFIG) >= powerDrain;
    }

    @Override
    protected boolean canTransferGas(GaseousEssentia essentiaGas) {
        if (this.allowAny()) {
            return true;
        }
        return super.canTransferGas(essentiaGas);
    }

    @Override
    public boolean canAccept(IAEFluidStack fluidStack) {
        if (this.aspectContainer == null) {
            return false;
        }
        if (!this.hasSecurityPermission()) {
            return false;
        }
        if (!this.isFluidEssentiaGas(fluidStack)) {
            return false;
        }
        if (!TEAPI.transportPermissions().canInjectToAspectContainerTile(this.aspectContainer)) {
            return false;
        }
        if (!this.canTransferGas((GaseousEssentia)fluidStack.getFluid())) {
            return false;
        }
        if (this.aspectContainer instanceof TileEssentiaReservoir) {
            return true;
        }
        AspectStack containerStack = EssentiaTileContainerHelper.instance.getAspectStackFromContainer(this.aspectContainer);
        if (containerStack == null) {
            return true;
        }
        Aspect gasAspect = ((GaseousEssentia)fluidStack.getFluid()).getAspect();
        return gasAspect == containerStack.aspect;
    }

    @Override
    public IAEFluidStack extractItems(IAEFluidStack request, Actionable mode, BaseActionSource source) {
        if (this.aspectContainer == null || request == null) {
            return null;
        }
        if (!this.isFluidEssentiaGas(request)) {
            return null;
        }
        FluidStack toDrain = request.getFluidStack();
        if (!this.canTransferGas((GaseousEssentia)toDrain.getFluid())) {
            return null;
        }
        FluidStack drained = EssentiaTileContainerHelper.instance.extractFromContainer(this.aspectContainer, toDrain, Actionable.SIMULATE);
        if (drained == null || drained.amount == 0) {
            return null;
        }
        int drainedAmount_EU = (int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(drained.amount);
        if (!this.takePowerFromNetwork(drainedAmount_EU, Actionable.SIMULATE)) {
            return null;
        }
        if (mode == Actionable.MODULATE) {
            EssentiaTileContainerHelper.instance.extractFromContainer(this.aspectContainer, toDrain, Actionable.MODULATE);
            this.takePowerFromNetwork(drainedAmount_EU, Actionable.MODULATE);
        }
        IAEFluidStack extractedFluid = request.copy();
        extractedFluid.setStackSize((long)drained.amount);
        return extractedFluid;
    }

    @Override
    public IItemList<IAEFluidStack> getAvailableItems(IItemList<IAEFluidStack> out) {
        List<AspectStack> essentiaList;
        if (this.aspectContainer != null && (essentiaList = this.getAvailableEssentia()) != null) {
            for (AspectStack essentia : essentiaList) {
                GaseousEssentia gas = GaseousEssentia.getGasFromAspect(essentia.aspect);
                out.add((IAEStack)EssentiaConversionHelper.instance.createAEFluidStackInEssentiaUnits(gas, essentia.amount));
            }
        }
        return out;
    }

    @Override
    public IAEFluidStack injectItems(IAEFluidStack input, Actionable mode, BaseActionSource source) {
        int remaining_FU;
        int filled_FU;
        boolean canVoid;
        if (this.aspectContainer == null || input == null || !this.canAccept(input)) {
            return input;
        }
        FluidStack toFill = input.getFluidStack();
        if (!this.canTransferGas((GaseousEssentia)toFill.getFluid())) {
            return input;
        }
        boolean bl = canVoid = this.isVoidAllowed() && this.aspectContainer instanceof TileJarFillableVoid;
        if (canVoid) {
            filled_FU = (int)input.getStackSize();
        } else {
            filled_FU = (int)EssentiaTileContainerHelper.instance.injectIntoContainer(this.aspectContainer, input, Actionable.SIMULATE);
            if (filled_FU == 0) {
                return input;
            }
        }
        int filled_EU = (int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(filled_FU);
        if (!this.takePowerFromNetwork(filled_EU, Actionable.SIMULATE)) {
            return input;
        }
        if (mode == Actionable.MODULATE) {
            filled_FU = (int)EssentiaTileContainerHelper.instance.injectIntoContainer(this.aspectContainer, input, Actionable.MODULATE);
            this.takePowerFromNetwork(filled_EU, Actionable.MODULATE);
            filled_EU = (int)EssentiaConversionHelper.instance.convertFluidAmountToEssentiaAmount(filled_FU);
        }
        if ((remaining_FU = toFill.amount - filled_FU) == 0) {
            return null;
        }
        if (canVoid) {
            this.postAlterationToHostGrid((Iterable<IAEFluidStack>)ImmutableList.of((Object)AEApi.instance().storage().createFluidStack(new FluidStack(toFill.getFluid(), -remaining_FU))));
            return null;
        }
        IAEFluidStack remainingFluid = input.copy();
        remainingFluid.setStackSize((long)remaining_FU);
        return remainingFluid;
    }

    @Override
    public boolean onNeighborChange() {
        TileEntity tileEntity = this.getFaceingTile();
        if (tileEntity instanceof IAspectContainer) {
            if (this.aspectContainer != tileEntity) {
                this.aspectContainer = (IAspectContainer)tileEntity;
            }
            return true;
        }
        if (this.aspectContainer != null) {
            this.aspectContainer = null;
            return true;
        }
        return false;
    }

    @Override
    public void tickingRequest(IGridNode node, int TicksSinceLastCall) {
    }

    @Override
    public boolean validForPass(int pass) {
        if (this.aspectContainer != null) {
            boolean hasStored;
            boolean hasFilters = !this.allowAny();
            boolean bl = hasStored = !EssentiaTileContainerHelper.instance.getAspectStacksFromContainer(this.aspectContainer).isEmpty();
            if (pass == 1) {
                return hasFilters || hasStored;
            }
            return !hasFilters && !hasStored;
        }
        return false;
    }
}

