/*
 * Decompiled with CFR 0.152.
 */
package thaumicenergistics.integration.tc;

import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import org.apache.commons.lang3.tuple.ImmutablePair;
import thaumcraft.api.aspects.Aspect;
import thaumcraft.api.aspects.AspectList;
import thaumcraft.api.aspects.IEssentiaContainerItem;
import thaumcraft.common.blocks.BlockJarItem;
import thaumcraft.common.blocks.ItemJarFilled;
import thaumcraft.common.config.ConfigBlocks;
import thaumcraft.common.config.ConfigItems;
import thaumcraft.common.items.ItemEssence;
import thaumcraft.common.items.ItemResource;
import thaumicenergistics.api.IEssentiaContainerPermission;
import thaumicenergistics.api.ITransportPermissions;
import thaumicenergistics.api.ThEApi;
import thaumicenergistics.aspect.AspectStack;

public final class EssentiaItemContainerHelper {
    public static final EssentiaItemContainerHelper instance = new EssentiaItemContainerHelper();
    private static final String JAR_LABEL_NBT_KEY = "AspectFilter";
    private static final int JAR_CAPACITY = 64;
    private static final int PHIAL_CAPACITY = 8;
    private ITransportPermissions perms = ThEApi.instance().transportPermissions();

    private EssentiaItemContainerHelper() {
    }

    public ItemStack createEmptyJar(int metadata) {
        return new ItemStack(ConfigBlocks.blockJar, 1, metadata);
    }

    public ItemStack createEmptyPhial() {
        return new ItemStack(ConfigItems.itemEssence, 1, 0);
    }

    public ItemStack createFilledJar(Aspect aspect, int amount, int metadata, boolean withLabel) {
        ItemStack jar;
        if (aspect == null || amount <= 0 && !withLabel) {
            jar = this.createEmptyJar(metadata);
        } else {
            jar = new ItemStack(ConfigItems.itemJarFilled, 1, metadata);
            if (amount > 0) {
                if (amount > 64) {
                    amount = 64;
                }
                ((ItemJarFilled)jar.func_77973_b()).setAspects(jar, new AspectList().add(aspect, amount));
            }
            if (withLabel) {
                this.setJarLabel(jar, aspect);
            }
        }
        return jar;
    }

    public ItemStack createFilledPhial(Aspect aspect) {
        if (aspect == null) {
            return this.createEmptyPhial();
        }
        ItemStack phial = new ItemStack(ConfigItems.itemEssence, 1, 1);
        ((ItemEssence)phial.func_77973_b()).setAspects(phial, new AspectList().add(aspect, 8));
        return phial;
    }

    public boolean doesJarHaveLabel(ItemStack jar) {
        return this.getJarLabelAspect(jar) != null;
    }

    public ImmutablePair<Integer, ItemStack> extractFromContainer(ItemStack container, AspectStack aspectStack) {
        if (container == null) {
            return null;
        }
        if (!this.isContainer(container)) {
            return null;
        }
        Item containerItem = container.func_77973_b();
        IEssentiaContainerPermission info = this.getContainerInfo(containerItem, container.func_77960_j());
        if (info == null) {
            return null;
        }
        AspectList aspectList = ((IEssentiaContainerItem)containerItem).getAspects(container);
        if (aspectStack.aspect != aspectList.getAspects()[0]) {
            return null;
        }
        int containerAmountStored = aspectList.getAmount(aspectStack.aspect);
        if (containerAmountStored <= 0) {
            return null;
        }
        int amountToDrain = (int)aspectStack.amount;
        if (!info.canHoldPartialAmount()) {
            if (amountToDrain < info.maximumCapacity()) {
                return null;
            }
            if (amountToDrain > info.maximumCapacity()) {
                amountToDrain = info.maximumCapacity();
            }
        } else if (amountToDrain > containerAmountStored) {
            amountToDrain = containerAmountStored;
        }
        ItemStack resultStack = null;
        if (amountToDrain == containerAmountStored || amountToDrain == info.maximumCapacity()) {
            if (containerItem instanceof ItemEssence) {
                resultStack = this.createEmptyPhial();
            } else if (containerItem instanceof ItemJarFilled) {
                resultStack = this.doesJarHaveLabel(container) ? this.createFilledJar(aspectStack.aspect, 0, container.func_77960_j(), true) : this.createEmptyJar(container.func_77960_j());
            }
        }
        if (resultStack == null) {
            resultStack = container.func_77946_l();
            aspectList.reduce(aspectStack.aspect, amountToDrain);
            ((IEssentiaContainerItem)resultStack.func_77973_b()).setAspects(resultStack, aspectList);
        }
        return new ImmutablePair((Object)amountToDrain, (Object)resultStack);
    }

    public ImmutablePair<Integer, ItemStack> extractFromContainer(ItemStack container, int drainAmount_EU) {
        if (container == null) {
            return null;
        }
        AspectStack stack = new AspectStack(this.getAspectInContainer(container), drainAmount_EU);
        return this.extractFromContainer(container, stack);
    }

    public Aspect getAspectFromLabel(ItemStack label) {
        if (!this.isLabel(label)) {
            return null;
        }
        ItemResource rLabel = (ItemResource)label.func_77973_b();
        AspectList aspects = rLabel.getAspects(label);
        if (aspects == null || aspects.size() == 0) {
            return null;
        }
        return aspects.getAspects()[0];
    }

    public Aspect getAspectInContainer(ItemStack container) {
        AspectList aspectList;
        if (this.isLabel(container)) {
            return this.getAspectFromLabel(container);
        }
        if (container != null && container.func_77973_b() instanceof IEssentiaContainerItem && this.isContainerWhitelisted(container) && (aspectList = ((IEssentiaContainerItem)container.func_77973_b()).getAspects(container)) != null) {
            return aspectList.getAspects()[0];
        }
        return null;
    }

    public AspectStack getAspectStackFromContainer(ItemStack container) {
        Aspect aspect = this.getAspectInContainer(container);
        if (aspect == null) {
            return null;
        }
        int stored = this.getContainerStoredAmount(container);
        return new AspectStack(aspect, stored);
    }

    public int getContainerCapacity(ItemStack container) {
        Item containerItem;
        IEssentiaContainerPermission info;
        if (container != null && (info = this.getContainerInfo(containerItem = container.func_77973_b(), container.func_77960_j())) != null) {
            return info.maximumCapacity();
        }
        return 0;
    }

    public IEssentiaContainerPermission getContainerInfo(Item item, int metadata) {
        if (item != null) {
            return this.perms.getEssentiaContainerInfo(item.getClass(), metadata);
        }
        return null;
    }

    public IEssentiaContainerPermission getContainerInfo(ItemStack itemStack) {
        if (itemStack != null) {
            return this.perms.getEssentiaContainerInfo(itemStack.func_77973_b().getClass(), itemStack.func_77960_j());
        }
        return null;
    }

    public int getContainerStoredAmount(ItemStack container) {
        if (container != null && container.func_77973_b() instanceof IEssentiaContainerItem && this.isContainerWhitelisted(container)) {
            AspectList storedList = ((IEssentiaContainerItem)container.func_77973_b()).getAspects(container);
            if (storedList == null) {
                return 0;
            }
            return storedList.getAmount(storedList.getAspects()[0]);
        }
        return 0;
    }

    public Aspect getJarLabelAspect(ItemStack jar) {
        Aspect labelAspect = null;
        if (jar.func_77973_b() instanceof ItemJarFilled && jar.func_77942_o() && jar.field_77990_d.func_74764_b(JAR_LABEL_NBT_KEY)) {
            String tag = jar.field_77990_d.func_74779_i(JAR_LABEL_NBT_KEY);
            labelAspect = Aspect.getAspect((String)tag);
        }
        return labelAspect;
    }

    public ImmutablePair<Integer, ItemStack> injectIntoContainer(ItemStack container, AspectStack aspectStack) {
        if (container == null) {
            return null;
        }
        if (!this.isContainer(container)) {
            return null;
        }
        if (this.doesJarHaveLabel(container) && aspectStack.aspect != this.getJarLabelAspect(container)) {
            return null;
        }
        Item containerItem = container.func_77973_b();
        IEssentiaContainerPermission info = this.getContainerInfo(containerItem, container.func_77960_j());
        if (info == null) {
            return null;
        }
        int containerAmountStored = this.getContainerStoredAmount(container);
        int remainaingStorage = info.maximumCapacity() - containerAmountStored;
        if (remainaingStorage <= 0) {
            return null;
        }
        int amountToFill = (int)aspectStack.amount;
        if (!info.canHoldPartialAmount()) {
            if (amountToFill < info.maximumCapacity()) {
                return null;
            }
            if (amountToFill > info.maximumCapacity()) {
                amountToFill = info.maximumCapacity();
            }
        } else if (amountToFill > containerAmountStored + info.maximumCapacity()) {
            amountToFill = info.maximumCapacity() - containerAmountStored;
        }
        ItemStack resultStack = null;
        if (containerItem instanceof ItemEssence) {
            resultStack = this.createFilledPhial(aspectStack.aspect);
        } else if (containerItem instanceof BlockJarItem) {
            resultStack = this.createFilledJar(aspectStack.aspect, amountToFill, container.func_77960_j(), false);
        }
        if (resultStack == null) {
            resultStack = container.func_77946_l();
            AspectList aspectList = ((IEssentiaContainerItem)containerItem).getAspects(container);
            if (aspectList == null) {
                aspectList = new AspectList();
            }
            aspectList.add(aspectStack.aspect, amountToFill);
            ((IEssentiaContainerItem)resultStack.func_77973_b()).setAspects(resultStack, aspectList);
        }
        return new ImmutablePair((Object)amountToFill, (Object)resultStack);
    }

    public boolean isContainer(ItemStack container) {
        if (container != null) {
            return this.isContainerWhitelisted(container);
        }
        return false;
    }

    public boolean isContainerEmpty(ItemStack container) {
        return this.getContainerStoredAmount(container) == 0;
    }

    public boolean isContainerFilled(ItemStack container) {
        return this.getContainerStoredAmount(container) > 0;
    }

    public boolean isContainerOrLabel(ItemStack stack) {
        return this.isContainer(stack) || this.isLabel(stack);
    }

    public boolean isContainerWhitelisted(Item container, int metadata) {
        return this.getContainerInfo(container, metadata) != null;
    }

    public boolean isContainerWhitelisted(ItemStack container) {
        return this.getContainerInfo(container) != null;
    }

    public boolean isLabel(ItemStack stack) {
        if (stack != null) {
            return stack.func_77973_b() instanceof ItemResource && stack.func_77960_j() == 13;
        }
        return false;
    }

    public void registerThaumcraftContainers() {
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemEssence.class, 8, 0, false);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemEssence.class, 8, 1, false);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemJarFilled.class, 64, 0, true);
        this.perms.addEssentiaContainerItemToTransportPermissions(ItemJarFilled.class, 64, 3, true);
    }

    public ItemStack setJarLabel(ItemStack jar, Aspect OverrideAspect) {
        Aspect labelAspect;
        if (jar.func_77973_b() instanceof ItemJarFilled && (labelAspect = OverrideAspect != null ? OverrideAspect : this.getAspectInContainer(jar)) != null) {
            if (!jar.func_77942_o()) {
                jar.field_77990_d = new NBTTagCompound();
            }
            jar.field_77990_d.func_74778_a(JAR_LABEL_NBT_KEY, labelAspect.getTag());
        }
        return jar;
    }

    public void setLabelAspect(ItemStack label, Aspect aspect) {
        if (!this.isLabel(label)) {
            return;
        }
        ItemResource rLabel = (ItemResource)label.func_77973_b();
        AspectList aspects = new AspectList();
        aspects.add(aspect, 1);
        rLabel.setAspects(label, aspects);
    }
}

