/*
 * Decompiled with CFR 0.152.
 */
package extracells.proxy;

import appeng.api.AEApi;
import appeng.api.IAppEngApi;
import appeng.api.recipes.IRecipeHandler;
import appeng.api.recipes.IRecipeLoader;
import cpw.mods.fml.common.registry.GameRegistry;
import extracells.registries.BlockEnum;
import extracells.registries.ItemEnum;
import extracells.tileentity.TileEntityCertusTank;
import extracells.tileentity.TileEntityFluidCrafter;
import extracells.tileentity.TileEntityFluidFiller;
import extracells.tileentity.TileEntityFluidInterface;
import extracells.tileentity.TileEntityHardMeDrive;
import extracells.tileentity.TileEntityVibrationChamberFluid;
import extracells.tileentity.TileEntityWalrus;
import extracells.util.FuelBurnTime;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraftforge.fluids.FluidRegistry;

public class CommonProxy {
    public void addRecipes(File configFolder) {
        IRecipeHandler recipeHandler = AEApi.instance().registries().recipes().createNewRecipehandler();
        File externalRecipe = new File(configFolder.getPath() + File.separator + "AppliedEnergistics2" + File.separator + "extracells.recipe");
        if (externalRecipe.exists()) {
            recipeHandler.parseRecipes((IRecipeLoader)new ExternalRecipeLoader(), externalRecipe.getPath());
        } else {
            recipeHandler.parseRecipes((IRecipeLoader)new InternalRecipeLoader(), "main.recipe");
        }
        recipeHandler.injectRecipes();
    }

    public void registerBlocks() {
        for (BlockEnum current : BlockEnum.values()) {
            GameRegistry.registerBlock((Block)current.getBlock(), current.getItemBlockClass(), (String)current.getInternalName());
        }
    }

    public void registerItems() {
        for (ItemEnum current : ItemEnum.values()) {
            GameRegistry.registerItem((Item)current.getItem(), (String)current.getInternalName());
        }
    }

    public void registerMovables() {
        IAppEngApi api = AEApi.instance();
        api.registries().movable().whiteListTileEntity(TileEntityCertusTank.class);
        api.registries().movable().whiteListTileEntity(TileEntityWalrus.class);
        api.registries().movable().whiteListTileEntity(TileEntityFluidCrafter.class);
        api.registries().movable().whiteListTileEntity(TileEntityFluidInterface.class);
        api.registries().movable().whiteListTileEntity(TileEntityFluidFiller.class);
        api.registries().movable().whiteListTileEntity(TileEntityHardMeDrive.class);
        api.registries().movable().whiteListTileEntity(TileEntityVibrationChamberFluid.class);
    }

    public void registerRenderers() {
    }

    public void registerTileEntities() {
        GameRegistry.registerTileEntity(TileEntityCertusTank.class, (String)"tileEntityCertusTank");
        GameRegistry.registerTileEntity(TileEntityWalrus.class, (String)"tileEntityWalrus");
        GameRegistry.registerTileEntity(TileEntityFluidCrafter.class, (String)"tileEntityFluidCrafter");
        GameRegistry.registerTileEntity(TileEntityFluidInterface.class, (String)"tileEntityFluidInterface");
        GameRegistry.registerTileEntity(TileEntityFluidFiller.class, (String)"tileEntityFluidFiller");
        GameRegistry.registerTileEntity(TileEntityHardMeDrive.class, (String)"tileEntityHardMEDrive");
        GameRegistry.registerTileEntity(TileEntityVibrationChamberFluid.class, (String)"tileEntityVibrationChamberFluid");
    }

    public void registerFluidBurnTimes() {
        FuelBurnTime.registerFuel(FluidRegistry.LAVA, 800);
    }

    private class InternalRecipeLoader
    implements IRecipeLoader {
        private InternalRecipeLoader() {
        }

        public BufferedReader getFile(String path) throws Exception {
            InputStream resourceAsStream = this.getClass().getResourceAsStream("/assets/extracells/recipes/" + path);
            InputStreamReader reader = new InputStreamReader(resourceAsStream, "UTF-8");
            return new BufferedReader(reader);
        }
    }

    private class ExternalRecipeLoader
    implements IRecipeLoader {
        private ExternalRecipeLoader() {
        }

        public BufferedReader getFile(String path) throws Exception {
            return new BufferedReader(new FileReader(new File(path)));
        }
    }
}

