/*
 * Decompiled with CFR 0.152.
 */
package tonius.neiintegration.mods.forestry;

import codechicken.lib.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import forestry.factory.gadgets.MachineBottler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import tonius.neiintegration.PositionedFluidTank;
import tonius.neiintegration.RecipeHandlerBase;
import tonius.neiintegration.Utils;

public class RecipeHandlerBottler
extends RecipeHandlerBase {
    private static Class<? extends GuiContainer> guiClass;
    private static List<MachineBottler.Recipe> recipes;

    @Override
    public void prepare() {
        guiClass = Utils.getClass("forestry.factory.gui.GuiBottler");
        for (FluidContainerRegistry.FluidContainerData container : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            MachineBottler.Recipe recipe = MachineBottler.RecipeManager.findMatchingRecipe((FluidStack)container.fluid, (ItemStack)container.emptyContainer);
            if (recipe == null) continue;
            recipes.add(recipe);
        }
    }

    @Override
    public String getRecipeID() {
        return "forestry.bottler";
    }

    public String getRecipeName() {
        return Utils.translate("tile.for.factory.0.name", false);
    }

    public String getGuiTexture() {
        return "forestry:textures/gui/bottler.png";
    }

    public void loadTransferRects() {
        this.addTransferRect(75, 27, 24, 17);
    }

    public Class<? extends GuiContainer> getGuiClass() {
        return guiClass;
    }

    public void drawBackground(int recipe) {
        this.changeToGuiTexture();
        GuiDraw.drawTexturedModalRect((int)43, (int)0, (int)48, (int)11, (int)123, (int)65);
    }

    public void drawExtras(int recipe) {
        this.drawProgressBar(75, 27, 176, 74, 24, 17, 40, 0);
    }

    @Override
    public void loadAllRecipes() {
        for (MachineBottler.Recipe recipe : recipes) {
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    @Override
    public void loadCraftingRecipes(ItemStack result) {
        for (MachineBottler.Recipe recipe : recipes) {
            if (!Utils.areStacksSameTypeCraftingSafe(recipe.bottled, result)) continue;
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(ItemStack ingred) {
        super.loadUsageRecipes(ingred);
        for (MachineBottler.Recipe recipe : recipes) {
            if (!Utils.areStacksSameTypeCraftingSafe(recipe.can, ingred)) continue;
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    @Override
    public void loadUsageRecipes(FluidStack ingred) {
        for (MachineBottler.Recipe recipe : recipes) {
            if (!Utils.areFluidsSameType(recipe.input, ingred)) continue;
            this.arecipes.add(new CachedBottlerRecipe(recipe));
        }
    }

    static {
        recipes = new ArrayList<MachineBottler.Recipe>();
    }

    public class CachedBottlerRecipe
    extends RecipeHandlerBase.CachedBaseRecipe {
        public PositionedFluidTank fluid;
        public PositionedStack input;
        public PositionedStack output;

        public CachedBottlerRecipe(MachineBottler.Recipe recipe) {
            if (recipe.input != null) {
                this.fluid = new PositionedFluidTank(recipe.input, 10000, new Rectangle(48, 6, 16, 58), RecipeHandlerBottler.this.getGuiTexture(), new Point(176, 0));
            }
            if (recipe.can != null) {
                this.input = new PositionedStack((Object)recipe.can, 111, 8);
            }
            if (recipe.bottled != null) {
                this.output = new PositionedStack((Object)recipe.bottled, 111, 44);
            }
        }

        public PositionedStack getIngredient() {
            return this.input;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        @Override
        public PositionedFluidTank getFluidTank() {
            return this.fluid;
        }
    }
}

