/*
 * Decompiled with CFR 0.152.
 */
package openmods.sync;

import com.google.common.base.Preconditions;
import java.lang.reflect.Field;
import openmods.Log;
import openmods.sync.DummySyncableObject;
import openmods.sync.ISyncableObject;
import openmods.sync.SyncMap;
import openmods.utils.FieldsSelector;

public class SyncObjectScanner
extends FieldsSelector {
    public static final SyncObjectScanner INSTANCE = new SyncObjectScanner();

    @Override
    protected boolean shouldInclude(Field field) {
        return ISyncableObject.class.isAssignableFrom(field.getType());
    }

    @Override
    protected Field[] listFields(Class<?> cls) {
        return cls.getDeclaredFields();
    }

    public void registerAllFields(SyncMap<?> map, Object target) {
        for (Field field : this.getFields(target.getClass())) {
            ISyncableObject obj;
            try {
                obj = (ISyncableObject)field.get(target);
                Preconditions.checkNotNull((Object)obj, (Object)"Null field value");
            }
            catch (Exception e) {
                obj = DummySyncableObject.INSTANCE;
                Log.severe(e, "Exception while registering synced field '%s' of object '%s'", field, target);
            }
            String fieldName = field.getName();
            map.put(fieldName, obj);
        }
    }
}

