/*
 * Decompiled with CFR 0.152.
 */
package openmods.serializable.cls;

import com.google.common.base.Preconditions;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.lang.reflect.Field;
import openmods.reflection.FieldAccess;
import openmods.serializable.IObjectSerializer;
import openmods.utils.io.IStreamSerializer;
import openmods.utils.io.TypeRW;

public class SerializableField<T>
extends FieldAccess<Object>
implements IObjectSerializer<T> {
    private final IStreamSerializer<Object> serializer;

    public SerializableField(Field field, IStreamSerializer<Object> serializer) {
        super(field);
        Preconditions.checkNotNull(serializer, (Object)"Empty serializer");
        this.serializer = serializer;
    }

    public SerializableField(Field field) {
        super(field);
        Class<?> fieldType = field.getType();
        this.serializer = TypeRW.STREAM_SERIALIZERS.get(fieldType);
        Preconditions.checkNotNull(this.serializer, (Object)"Invalid field type");
    }

    @Override
    public void writeToStream(T target, DataOutput output) throws IOException {
        Object value = this.get(target);
        this.serializer.writeToStream(value, output);
    }

    @Override
    public void readFromStream(T target, DataInput input) throws IOException {
        Object value = this.serializer.readFromStream(input);
        this.set(target, value);
    }
}

