/*
 * Decompiled with CFR 0.152.
 */
package openmods.reflection;

import com.google.common.base.Preconditions;
import com.google.common.collect.BiMap;
import com.google.common.collect.ImmutableBiMap;

public class TypeUtils {
    public static final BiMap<Class<?>, Class<?>> PRIMITIVE_TYPES_MAP = ImmutableBiMap.builder().put(Boolean.TYPE, Boolean.class).put(Byte.TYPE, Byte.class).put(Character.TYPE, Character.class).put(Short.TYPE, Short.class).put(Integer.TYPE, Integer.class).put(Long.TYPE, Long.class).put(Float.TYPE, Float.class).put(Double.TYPE, Double.class).put(Void.TYPE, Void.class).build();

    public static Class<?> toObjectType(Class<?> cls) {
        return cls.isPrimitive() ? (Class)PRIMITIVE_TYPES_MAP.get(cls) : cls;
    }

    public static void isInstance(Object o, Class<?> mainCls, Class<?> ... extraCls) {
        Preconditions.checkArgument((boolean)mainCls.isInstance(o), (String)"%s is not instance of %s", (Object[])new Object[]{o, mainCls});
        for (Class<?> cls : extraCls) {
            Preconditions.checkArgument((boolean)cls.isInstance(o), (String)"%s is not instance of %s", (Object[])new Object[]{o, cls});
        }
    }

    public static boolean compareTypes(Class<?> left, Class<?> right) {
        if (left.isPrimitive()) {
            left = (Class)PRIMITIVE_TYPES_MAP.get(left);
        }
        if (right.isPrimitive()) {
            right = (Class)PRIMITIVE_TYPES_MAP.get(right);
        }
        return left.equals(right);
    }
}

