/*
 * Decompiled with CFR 0.152.
 */
package openmods.context;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Map;
import openmods.context.VariableKey;

public class ContextManager {
    private static final ThreadLocal<Frame> top = new ThreadLocal<Frame>(){

        @Override
        protected Frame initialValue() {
            return new Frame(null);
        }
    };

    public static void push() {
        Frame prevTop = top.get();
        Frame newTop = new Frame(prevTop);
        top.set(newTop);
    }

    public static void pop() {
        Frame currentTop = top.get();
        Preconditions.checkState((currentTop != null ? 1 : 0) != 0, (Object)"Trying to pop, but no context available");
        Frame newTop = currentTop.prev;
        Preconditions.checkState((newTop != null ? 1 : 0) != 0, (Object)"Trying to pop last frame");
        top.set(newTop);
    }

    public static <T> T get(VariableKey<T> key) {
        Frame currentTop = top.get();
        Preconditions.checkState((currentTop != null ? 1 : 0) != 0, (Object)"No context on stack");
        return (T)currentTop.get(key);
    }

    public static <T> T remove(VariableKey<T> key) {
        Frame currentTop = top.get();
        Preconditions.checkState((currentTop != null ? 1 : 0) != 0, (Object)"No context on stack");
        return (T)currentTop.remove(key);
    }

    public static <T> void set(VariableKey<T> key, T value) {
        Frame currentTop = top.get();
        Preconditions.checkState((currentTop != null ? 1 : 0) != 0, (Object)"No context on stack");
        currentTop.put(key, value);
    }

    private static class Frame {
        private final Frame prev;
        private final Map<VariableKey<?>, Object> values = Maps.newHashMap();

        public Frame(Frame prev) {
            this.prev = prev;
        }

        private <T> T get(VariableKey<T> key) {
            Object o = this.values.get(key);
            if (o != null) {
                return (T)o;
            }
            if (this.prev != null) {
                return this.prev.get(key);
            }
            return null;
        }

        private <T> T remove(VariableKey<T> key) {
            Object o = this.values.remove(key);
            if (o != null) {
                return (T)o;
            }
            if (this.prev != null) {
                return this.prev.remove(key);
            }
            return null;
        }

        private <T> void put(VariableKey<T> key, T value) {
            this.values.put(key, value);
        }
    }
}

