/*
 * Decompiled with CFR 0.152.
 */
package kihira.tails.common;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonSyntaxException;
import cpw.mods.fml.client.event.ConfigChangedEvent;
import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.ModContainer;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.network.NetworkCheckHandler;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.SimpleNetworkWrapper;
import cpw.mods.fml.common.versioning.ArtifactVersion;
import cpw.mods.fml.common.versioning.DefaultArtifactVersion;
import cpw.mods.fml.common.versioning.VersionParser;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import kihira.tails.client.FakeEntity;
import kihira.tails.client.render.FakeEntityRenderHelper;
import kihira.tails.client.render.PlayerRenderHelper;
import kihira.tails.client.render.RenderPart;
import kihira.tails.common.PartInfo;
import kihira.tails.common.PartsData;
import kihira.tails.proxy.CommonProxy;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(modid="Tails", name="Tails", version="1.7.10-1.3.1", dependencies="after:foxlib")
public class Tails {
    public static final String MOD_ID = "Tails";
    public static final Logger logger = LogManager.getLogger((String)"Tails");
    public static final SimpleNetworkWrapper networkWrapper = NetworkRegistry.INSTANCE.newSimpleChannel("Tails");
    public static final Gson gson = new GsonBuilder().excludeFieldsWithoutExposeAnnotation().create();
    public static Configuration configuration;
    public static boolean libraryEnabled;
    public static boolean hasRemote;
    @SidedProxy(clientSide="kihira.tails.proxy.ClientProxy", serverSide="kihira.tails.proxy.CommonProxy")
    public static CommonProxy proxy;
    @Mod.Instance
    public static Tails instance;
    public static PartsData localPartsData;

    @Mod.EventHandler
    public void onPreInit(FMLPreInitializationEvent e) {
        proxy.init();
        if (e.getSide().isClient()) {
            configuration = new Configuration(e.getSuggestedConfigurationFile());
            this.loadConfig();
            RenderPart.registerRenderHelper(EntityPlayer.class, new PlayerRenderHelper());
            RenderPart.registerRenderHelper(FakeEntity.class, new FakeEntityRenderHelper());
        }
    }

    @SubscribeEvent
    public void onConfigChange(ConfigChangedEvent.OnConfigChangedEvent event) {
        if (event.modID.equals(MOD_ID)) {
            this.loadConfig();
        }
    }

    @NetworkCheckHandler
    public boolean checkRemoteVersions(Map<String, String> versions, Side side) {
        if (versions.containsKey(MOD_ID)) {
            String clientVer = ((ModContainer)Loader.instance().getReversedModObjectList().get((Object)this)).getVersion();
            if (VersionParser.parseRange((String)("[" + clientVer + ",)")).containsVersion((ArtifactVersion)new DefaultArtifactVersion(versions.get(MOD_ID)))) {
                logger.warn(String.format("Remote version not in acceptable version bounds! Local (%s) is %s, Remote is %s", side.toString(), clientVer, versions.get(MOD_ID)));
            } else {
                logger.debug(String.format("Remote version is in acceptable version bounds. Local (%s) is %s, Remote is %s", side.toString(), clientVer, versions.get(MOD_ID)));
                hasRemote = true;
            }
        }
        return true;
    }

    public void loadConfig() {
        try {
            localPartsData = (PartsData)gson.fromJson(configuration.getString("Local Player Data", "general", "Local Players data. Delete to remove all customisation data. Do not try to edit manually", ""), PartsData.class);
            PartInfo tailInfo = null;
            if (configuration.hasKey("general", "Local Tail Info")) {
                tailInfo = (PartInfo)gson.fromJson(configuration.getString("Local Tail Info", "general", "DEPRECIATED. CAN SAFELY REMOVE", ""), PartInfo.class);
            }
            if (tailInfo != null) {
                if (localPartsData == null) {
                    localPartsData = new PartsData();
                }
                tailInfo.partType = PartsData.PartType.TAIL;
                localPartsData.setPartInfo(PartsData.PartType.TAIL, tailInfo);
                Property prop = configuration.get("general", "Local Tail Info", "");
                prop.set("");
                Tails.setLocalPartsData(localPartsData);
            }
        }
        catch (JsonSyntaxException e) {
            e.printStackTrace();
        }
        libraryEnabled = configuration.getBoolean("Enable Library", "general", true, "Whether to enable the library system for sharing tails. This mostly matters on servers.");
        if (configuration.hasChanged()) {
            configuration.save();
        }
    }

    public static void setLocalPartsData(PartsData partsData) {
        localPartsData = partsData;
        Property prop = configuration.get("general", "Local Player Data", "");
        prop.set(gson.toJson((Object)localPartsData));
        configuration.save();
    }
}

