/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.entity;

import com.google.common.base.Strings;
import cpw.mods.fml.common.network.ByteBufUtils;
import cpw.mods.fml.common.registry.IEntityAdditionalSpawnData;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.client.entity.AbstractClientPlayer;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAIWander;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.management.PreYggdrasilConverter;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import openblocks.common.entity.ai.EntityAIBreakBlock;
import openblocks.common.entity.ai.EntityAIPickupPlayer;
import openmods.Log;

public class EntityMiniMe
extends EntityCreature
implements IEntityAdditionalSpawnData {
    @SideOnly(value=Side.CLIENT)
    private ResourceLocation locationSkin;
    private UUID owner;
    private String ownerSkin = "";
    private String loadedSkin;
    private int pickupCooldown = 0;
    private boolean wasRidden = false;

    public EntityMiniMe(World world, UUID owner, String ownerSkin) {
        this(world);
        this.owner = owner;
        this.ownerSkin = Strings.emptyToNull((String)ownerSkin);
    }

    public EntityMiniMe(World world) {
        super(world);
        this.func_70105_a(0.6f, 0.95f);
        this.func_110163_bv();
        this.func_70661_as().func_75491_a(true);
        this.func_70661_as().func_75495_e(true);
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIPickupPlayer(this));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAIBreakBlock((EntityLiving)this));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIWander((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    public void func_70030_z() {
        super.func_70030_z();
        if (this.pickupCooldown > 0) {
            --this.pickupCooldown;
        }
        if (this.wasRidden && this.field_70153_n == null) {
            this.wasRidden = false;
            this.setPickupCooldown(1200);
        } else if (this.field_70153_n != null) {
            this.wasRidden = true;
        }
    }

    public double func_70042_X() {
        return (double)this.field_70131_O + 0.15;
    }

    public int getPickupCooldown() {
        return this.pickupCooldown;
    }

    public void setPickupCooldown(int cooldown) {
        this.pickupCooldown = cooldown;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(10.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.3);
    }

    @SideOnly(value=Side.CLIENT)
    public ResourceLocation getLocationSkin() {
        String newSkin = this.getPlayerSkin();
        if (this.locationSkin == null || !newSkin.equals(this.loadedSkin)) {
            this.locationSkin = AbstractClientPlayer.func_110311_f((String)newSkin);
            AbstractClientPlayer.func_110304_a((ResourceLocation)this.locationSkin, (String)newSkin);
        }
        this.loadedSkin = newSkin;
        return this.locationSkin;
    }

    public String getPlayerSkin() {
        return this.func_94056_bM() ? this.func_94057_bL() : this.ownerSkin;
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public boolean func_70650_aV() {
        return true;
    }

    public boolean func_70631_g_() {
        return true;
    }

    public UUID getOwner() {
        return this.owner;
    }

    public void writeSpawnData(ByteBuf data) {
        ByteBufUtils.writeUTF8String((ByteBuf)data, (String)Strings.nullToEmpty((String)this.ownerSkin));
    }

    public void readSpawnData(ByteBuf data) {
        this.ownerSkin = ByteBufUtils.readUTF8String((ByteBuf)data);
    }

    public void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        if (this.owner != null) {
            tag.func_74778_a("OwnerUUID", this.owner.toString());
        }
        tag.func_74778_a("OwnerSkin", this.ownerSkin);
        tag.func_74768_a("pickupCooldown", this.pickupCooldown);
    }

    public void func_70037_a(NBTTagCompound tag) {
        String uuidString;
        super.func_70037_a(tag);
        if (tag.func_150297_b("owner", 8)) {
            String ownerName = tag.func_74779_i("owner");
            uuidString = PreYggdrasilConverter.func_152719_a((String)ownerName);
            this.ownerSkin = ownerName;
        } else {
            uuidString = tag.func_74779_i("OwnerUUID");
            this.ownerSkin = tag.func_74779_i("OwnerSkin");
        }
        try {
            this.owner = UUID.fromString(uuidString);
        }
        catch (IllegalArgumentException e) {
            Log.warn((Throwable)e, (String)"Failed to parse UUID: %s", (Object[])new Object[]{uuidString});
        }
        if (tag.func_74764_b("pickupCooldown")) {
            this.pickupCooldown = tag.func_74762_e("pickupCooldown");
        }
    }
}

