/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.IIcon;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.fluids.IFluidTank;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openblocks.common.item.ItemTankBlock;
import openblocks.common.tileentity.TileEntityTank;
import openmods.Log;
import openmods.block.OpenBlock;
import openmods.infobook.BookDocumentation;
import openmods.utils.ItemUtils;

@BookDocumentation
public class BlockTank
extends OpenBlock {
    public BlockTank() {
        super(Material.field_151576_e);
        this.setRenderMode(OpenBlock.RenderMode.BOTH);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon getIcon() {
        return this.field_149761_L;
    }

    public boolean canBeReplacedByLeaves(IBlockAccess world, int x, int y, int z) {
        return false;
    }

    public boolean isFlammable(IBlockAccess world, int x, int y, int z, ForgeDirection face) {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public boolean isSideSolid(IBlockAccess world, int x, int y, int z, ForgeDirection side) {
        return true;
    }

    public int getLightValue(IBlockAccess world, int x, int y, int z) {
        if (!Config.tanksEmitLight) {
            return 0;
        }
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityTank.class));
        return tile != null ? tile.getFluidLightLevel() : 0;
    }

    public ItemStack getPickBlock(MovingObjectPosition target, World world, int x, int y, int z) {
        IFluidTank tank;
        ItemStack result = new ItemStack((Block)this);
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityTank.class));
        if (tile != null && (tank = tile.getTank()).getFluidAmount() > 0) {
            NBTTagCompound tankTag = tile.getItemNBT();
            if (tankTag.func_74764_b("Amount")) {
                tankTag.func_74768_a("Amount", tank.getCapacity());
            }
            NBTTagCompound nbt = ItemUtils.getItemTag((ItemStack)result);
            nbt.func_74782_a("tank", (NBTBase)tankTag);
        }
        return result;
    }

    public boolean func_149740_M() {
        return true;
    }

    public int func_149736_g(World world, int x, int y, int z, int side) {
        TileEntityTank tile = (TileEntityTank)((Object)BlockTank.getTileEntity((IBlockAccess)world, (int)x, (int)y, (int)z, TileEntityTank.class));
        double value = tile.getFluidRatio() * 15.0;
        if (value == 0.0) {
            return 0;
        }
        int trunc = MathHelper.func_76128_c((double)value);
        return Math.max(trunc, 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(Item item, CreativeTabs tab, List result) {
        result.add(new ItemStack(item));
        if (tab == null && Config.displayAllFilledTanks) {
            for (Fluid fluid : FluidRegistry.getRegisteredFluids().values()) {
                try {
                    ItemStack tankStack = ItemTankBlock.createFilledTank(fluid);
                    if (tankStack != null) {
                        result.add(tankStack);
                        continue;
                    }
                    Log.debug((String)"Failed to create filled tank stack for fluid '%s'. Not registered?", (Object[])new Object[]{fluid.getName()});
                }
                catch (Throwable t) {
                    throw new RuntimeException(String.format("Failed to create item for fluid '%s'Until this is fixed, you can bypass this code with config option 'tanks.displayAllFluids'", fluid.getName()), t);
                }
            }
        }
    }
}

