/*
 * Decompiled with CFR 0.152.
 */
package openblocks.common.block;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import openblocks.Config;
import openblocks.common.block.OpenBlock;
import openmods.infobook.BookDocumentation;

@BookDocumentation
public class BlockSponge
extends OpenBlock {
    private static final int TICK_RATE = 100;
    private static final Random RANDOM = new Random();

    public BlockSponge() {
        super(Material.field_151583_m);
        this.func_149672_a(field_149775_l);
        this.func_149675_a(true);
        this.setHarvestLevel("axe", 1);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.clearupLiquid(world, x, y, z);
    }

    public int func_149738_a(World par1World) {
        return 100;
    }

    public void afterBlockPlaced(World world, EntityPlayer player, ItemStack stack, int x, int y, int z, ForgeDirection side, ForgeDirection blockSide, float hitX, float hitY, float hitZ, int meta) {
        this.clearupLiquid(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, 100 + RANDOM.nextInt(5));
    }

    private void clearupLiquid(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return;
        }
        boolean hitLava = false;
        for (int dx = -Config.spongeRange; dx <= Config.spongeRange; ++dx) {
            for (int dy = -Config.spongeRange; dy <= Config.spongeRange; ++dy) {
                for (int dz = -Config.spongeRange; dz <= Config.spongeRange; ++dz) {
                    Block block = world.func_147439_a(x + dx, y + dy, z + dz);
                    Material material = block.func_149688_o();
                    if (!material.func_76224_d()) continue;
                    hitLava |= material == Material.field_151587_i;
                    world.func_147468_f(x + dx, y + dy, z + dz);
                }
            }
        }
        if (hitLava) {
            world.func_147452_c(x, y, z, (Block)this, 0, 0);
        }
    }

    public boolean func_149696_a(World world, int x, int y, int z, int eventId, int eventParam) {
        if (world.field_72995_K) {
            for (int i = 0; i < 20; ++i) {
                double px = (double)x + RANDOM.nextDouble() * 0.1;
                double py = (double)y + 1.0 + RANDOM.nextDouble();
                double pz = (double)z + RANDOM.nextDouble();
                world.func_72869_a("largesmoke", px, py, pz, 0.0, 0.0, 0.0);
            }
        } else {
            world.func_147465_d(x, y, z, (Block)Blocks.field_150480_ab, 0, 3);
        }
        return true;
    }

    public void func_149674_a(World world, int x, int y, int z, Random random) {
        this.clearupLiquid(world, x, y, z);
        world.func_147464_a(x, y, z, (Block)this, 100 + RANDOM.nextInt(5));
    }
}

