/*
 * Decompiled with CFR 0.152.
 */
package openblocks.client.renderer.tileentity;

import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import openblocks.client.renderer.tileentity.tank.ITankRenderFluidData;
import openblocks.common.tileentity.TileEntityTank;
import openmods.utils.Diagonal;
import openmods.utils.TextureUtils;
import org.lwjgl.opengl.GL11;

public class TileEntityTankRenderer
extends TileEntitySpecialRenderer {
    RenderBlocks renderBlocks = new RenderBlocks();

    public void func_147500_a(TileEntity te, double x, double y, double z, float f) {
        TileEntityTank tankTile = (TileEntityTank)te;
        if (tankTile.func_145837_r()) {
            return;
        }
        ITankRenderFluidData data = tankTile.getRenderFluidData();
        if (data.hasFluid()) {
            this.func_147499_a(TextureMap.field_110575_b);
            GL11.glPushMatrix();
            GL11.glTranslated((double)x, (double)y, (double)z);
            GL11.glDisable((int)3042);
            float time = (float)te.func_145831_w().func_82737_E() + f;
            TileEntityTankRenderer.renderFluid(data, time);
            GL11.glPopMatrix();
        }
    }

    public static void renderFluid(ITankRenderFluidData data, float time) {
        int color;
        GL11.glDisable((int)2896);
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        FluidStack fluidStack = data.getFluid();
        Fluid fluid = fluidStack.getFluid();
        IIcon texture = fluid.getStillIcon();
        if (texture != null) {
            TextureUtils.bindTextureToClient((ResourceLocation)TileEntityTankRenderer.getFluidSheet(fluid));
            color = fluid.getColor(fluidStack);
        } else {
            TextureUtils.bindDefaultTerrainTexture();
            texture = Minecraft.func_71410_x().func_147117_R().func_110572_b("missingno");
            color = -1;
        }
        Tessellator t = Tessellator.field_78398_a;
        double se = data.getCornerFluidLevel(Diagonal.SE, time);
        double ne = data.getCornerFluidLevel(Diagonal.NE, time);
        double sw = data.getCornerFluidLevel(Diagonal.SW, time);
        double nw = data.getCornerFluidLevel(Diagonal.NW, time);
        double center = data.getCenterFluidLevel(time);
        double uMin = texture.func_94209_e();
        double uMax = texture.func_94212_f();
        double vMin = texture.func_94206_g();
        double vMax = texture.func_94210_h();
        double vHeight = vMax - vMin;
        float r = (float)(color >> 16 & 0xFF) / 255.0f;
        float g = (float)(color >> 8 & 0xFF) / 255.0f;
        float b = (float)(color & 0xFF) / 255.0f;
        t.func_78382_b();
        t.func_78386_a(r, g, b);
        if (data.shouldRenderFluidWall(ForgeDirection.NORTH) && (nw > 0.0 || ne > 0.0)) {
            t.func_78374_a(1.0, 0.0, 0.0, uMax, vMin);
            t.func_78374_a(0.0, 0.0, 0.0, uMin, vMin);
            t.func_78374_a(0.0, nw, 0.0, uMin, vMin + vHeight * nw);
            t.func_78374_a(1.0, ne, 0.0, uMax, vMin + vHeight * ne);
        }
        if (data.shouldRenderFluidWall(ForgeDirection.SOUTH) && (se > 0.0 || sw > 0.0)) {
            t.func_78374_a(1.0, 0.0, 1.0, uMin, vMin);
            t.func_78374_a(1.0, se, 1.0, uMin, vMin + vHeight * se);
            t.func_78374_a(0.0, sw, 1.0, uMax, vMin + vHeight * sw);
            t.func_78374_a(0.0, 0.0, 1.0, uMax, vMin);
        }
        if (data.shouldRenderFluidWall(ForgeDirection.EAST) && (ne > 0.0 || se > 0.0)) {
            t.func_78374_a(1.0, 0.0, 0.0, uMin, vMin);
            t.func_78374_a(1.0, ne, 0.0, uMin, vMin + vHeight * ne);
            t.func_78374_a(1.0, se, 1.0, uMax, vMin + vHeight * se);
            t.func_78374_a(1.0, 0.0, 1.0, uMax, vMin);
        }
        if (data.shouldRenderFluidWall(ForgeDirection.WEST) && (sw > 0.0 || nw > 0.0)) {
            t.func_78374_a(0.0, 0.0, 1.0, uMin, vMin);
            t.func_78374_a(0.0, sw, 1.0, uMin, vMin + vHeight * sw);
            t.func_78374_a(0.0, nw, 0.0, uMax, vMin + vHeight * nw);
            t.func_78374_a(0.0, 0.0, 0.0, uMax, vMin);
        }
        if (data.shouldRenderFluidWall(ForgeDirection.UP)) {
            double uMid = (uMax + uMin) / 2.0;
            double vMid = (vMax + vMin) / 2.0;
            t.func_78374_a(0.5, center, 0.5, uMid, vMid);
            t.func_78374_a(1.0, se, 1.0, uMax, vMin);
            t.func_78374_a(1.0, ne, 0.0, uMin, vMin);
            t.func_78374_a(0.0, nw, 0.0, uMin, vMax);
            t.func_78374_a(0.0, sw, 1.0, uMax, vMax);
            t.func_78374_a(1.0, se, 1.0, uMax, vMin);
            t.func_78374_a(0.5, center, 0.5, uMid, vMid);
            t.func_78374_a(0.0, nw, 0.0, uMin, vMax);
        }
        if (data.shouldRenderFluidWall(ForgeDirection.DOWN)) {
            t.func_78374_a(1.0, 0.0, 0.0, uMax, vMin);
            t.func_78374_a(1.0, 0.0, 1.0, uMin, vMin);
            t.func_78374_a(0.0, 0.0, 1.0, uMin, vMax);
            t.func_78374_a(0.0, 0.0, 0.0, uMax, vMax);
        }
        t.func_78381_a();
        GL11.glEnable((int)2896);
    }

    public static ResourceLocation getFluidSheet(FluidStack liquid) {
        if (liquid == null) {
            return TextureMap.field_110575_b;
        }
        return TileEntityTankRenderer.getFluidSheet(liquid.getFluid());
    }

    public static ResourceLocation getFluidSheet(Fluid liquid) {
        return TextureMap.field_110575_b;
    }
}

