/*
 * Decompiled with CFR 0.152.
 */
package openblocks.api;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraftforge.common.MinecraftForge;
import openblocks.Config;
import openblocks.api.IFlimFlamAction;
import openblocks.api.IFlimFlamEffect;
import openmods.Log;
import openmods.config.properties.ConfigurationChange;

public class FlimFlamRegistry {
    private static final List<IFlimFlamEffect> FLIM_FLAMS = Lists.newArrayList();
    private static final List<IFlimFlamEffect> UNMODIFIABLE_VIEW = Collections.unmodifiableList(FLIM_FLAMS);
    private static final Map<String, IFlimFlamEffect> FLIM_FLAMS_BY_NAME = Maps.newHashMap();
    public static final Blacklist BLACKLIST = new Blacklist();

    public static FlimFlamMeta registerFlimFlam(String name, int cost, int weight, IFlimFlamAction effect) {
        FlimFlamMeta meta = new FlimFlamMeta(name, cost, weight, effect);
        FlimFlamRegistry.registerFlimFlam(name, meta);
        return meta;
    }

    protected static IFlimFlamEffect registerFlimFlam(String name, IFlimFlamEffect meta) {
        FLIM_FLAMS.add(meta);
        FLIM_FLAMS_BY_NAME.put(name, meta);
        return meta;
    }

    public static List<IFlimFlamEffect> getFlimFlams() {
        return UNMODIFIABLE_VIEW;
    }

    public static IFlimFlamEffect getFlimFlamByName(String name) {
        return FLIM_FLAMS_BY_NAME.get(name);
    }

    public static List<String> getAllFlimFlamsNames() {
        return ImmutableList.copyOf(FLIM_FLAMS_BY_NAME.keySet());
    }

    public static class FlimFlamMeta
    implements IFlimFlamEffect {
        private boolean isSilent;
        private boolean isSafe;
        private final String name;
        private final int cost;
        private final int weight;
        private int lowerLuck;
        private int upperLuck;
        private final IFlimFlamAction effect;

        public FlimFlamMeta(String name, int cost, int weight, IFlimFlamAction effect) {
            this.name = name;
            this.cost = cost;
            this.weight = weight;
            this.effect = effect;
            if (cost < 0) {
                this.setRange(Integer.MIN_VALUE, cost);
            } else {
                this.setRange(cost, Integer.MAX_VALUE);
            }
        }

        public FlimFlamMeta markSafe() {
            this.isSafe = true;
            return this;
        }

        public FlimFlamMeta markSilent() {
            this.isSilent = true;
            return this;
        }

        public FlimFlamMeta setRange(int a, int b) {
            if (a < b) {
                this.lowerLuck = a;
                this.upperLuck = b;
            } else {
                this.lowerLuck = b;
                this.upperLuck = a;
            }
            return this;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public int weight() {
            return this.weight;
        }

        @Override
        public int cost() {
            return this.cost;
        }

        @Override
        public boolean isSafe() {
            return this.isSafe;
        }

        @Override
        public boolean isSilent() {
            return this.isSilent;
        }

        @Override
        public IFlimFlamAction action() {
            return this.effect;
        }

        @Override
        public boolean canApply(int luck) {
            return this.lowerLuck <= luck && luck <= this.upperLuck;
        }
    }

    public static class Blacklist {
        private Set<String> blacklist;

        private void loadBlacklist() {
            this.blacklist = Sets.newHashSet();
            HashSet validNames = Sets.newHashSet(FlimFlamRegistry.getAllFlimFlamsNames());
            for (String s : Config.flimFlamBlacklist) {
                if (validNames.contains(s)) {
                    this.blacklist.add(s);
                    Log.info((String)"Blacklisting flim-flam %s", (Object[])new Object[]{s});
                    continue;
                }
                Log.warn((String)"Trying to blacklist unknown flimflam name '%s'", (Object[])new Object[]{s});
            }
        }

        public boolean isBlacklisted(IFlimFlamEffect effect) {
            if (this.blacklist == null) {
                this.loadBlacklist();
            }
            return Config.safeFlimFlams && !effect.isSafe() || this.blacklist.contains(effect.name());
        }

        @SubscribeEvent
        public void onReconfig(ConfigurationChange.Post evt) {
            if (evt.check("tomfoolery", "flimFlamBlacklist")) {
                this.blacklist = null;
            }
        }

        public void init() {
            this.loadBlacklist();
            MinecraftForge.EVENT_BUS.register((Object)this);
        }
    }
}

