/*
 * Decompiled with CFR 0.152.
 */
package cofh.thermalexpansion.gui.client.plate;

import cofh.api.tileentity.ISecurable;
import cofh.core.gui.GuiBaseAdv;
import cofh.core.gui.element.TabInfo;
import cofh.core.gui.element.TabSecurity;
import cofh.core.render.IconRegistry;
import cofh.lib.gui.GuiBase;
import cofh.lib.gui.element.ElementBase;
import cofh.lib.gui.element.ElementButton;
import cofh.lib.gui.element.ElementFluid;
import cofh.lib.gui.element.ElementIcon;
import cofh.lib.gui.element.ElementSimpleToolTip;
import cofh.lib.gui.element.TabBase;
import cofh.thermalexpansion.block.plate.TilePlateSignal;
import cofh.thermalexpansion.gui.container.ContainerTEBase;
import cofh.thermalfoundation.fluid.TFFluids;
import java.util.UUID;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class GuiPlateSignal
extends GuiBaseAdv {
    static final String TEX_PATH = "thermalexpansion:textures/gui/Plate.png";
    static final ResourceLocation TEXTURE = new ResourceLocation("thermalexpansion:textures/gui/Plate.png");
    TilePlateSignal myTile;
    UUID playerName;
    ElementButton decDistance;
    ElementButton incDistance;
    ElementButton decIntensity;
    ElementButton incIntensity;
    ElementButton decDuration;
    ElementButton incDuration;
    ElementIcon plateTop;

    public GuiPlateSignal(InventoryPlayer inventoryPlayer, TileEntity tileEntity) {
        super((Container)new ContainerTEBase(inventoryPlayer, tileEntity, false, false), TEXTURE);
        this.myTile = (TilePlateSignal)tileEntity;
        ((GuiBase)this).name = this.myTile.func_145825_b();
        this.playerName = inventoryPlayer.field_70458_d.func_146103_bH().getId();
        ((GuiBase)this).drawInventory = false;
        ((GuiScreen)this).field_146295_m = 100;
        this.generateInfo("tab.thermalexpansion.plate.signal", 2);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addTab((TabBase)new TabInfo((GuiBase)this, this.myInfo));
        if (this.myTile.enableSecurity() && this.myTile.isSecured()) {
            this.addTab((TabBase)new TabSecurity((GuiBase)this, (ISecurable)this.myTile, this.playerName));
        }
        this.addElement(new ElementSimpleToolTip((GuiBase)this, 13, 24).setToolTip("info.cofh.distance").setSize(24, 24).setTexture("cofh:textures/gui/elements/Info_Distance.png", 32, 32));
        this.addElement(new ElementSimpleToolTip((GuiBase)this, 49, 24).setToolTip("info.cofh.strength").setSize(24, 24).setTexture("cofh:textures/gui/elements/Info_Signal.png", 32, 32));
        this.addElement(new ElementSimpleToolTip((GuiBase)this, 85, 24).setToolTip("info.cofh.duration").setSize(24, 24).setTexture("cofh:textures/gui/elements/Info_Duration.png", 32, 32));
        this.addElement(new ElementFluid((GuiBase)this, 134, 32).setFluid(TFFluids.fluidRedstone).setSize(16, 16));
        this.decDistance = new ElementButton((GuiBase)this, 10, 66, "decDistance", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incDistance = new ElementButton((GuiBase)this, 26, 66, "incDistance", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decIntensity = new ElementButton((GuiBase)this, 46, 66, "decIntensity", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incIntensity = new ElementButton((GuiBase)this, 62, 66, "incIntensity", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.decDuration = new ElementButton((GuiBase)this, 82, 66, "decDuration", 176, 0, 176, 14, 176, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.incDuration = new ElementButton((GuiBase)this, 98, 66, "incDuration", 190, 0, 190, 14, 190, 28, 14, 14, TEX_PATH).setToolTipLocalized(true);
        this.addElement((ElementBase)this.decDistance);
        this.addElement((ElementBase)this.incDistance);
        this.addElement((ElementBase)this.decIntensity);
        this.addElement((ElementBase)this.incIntensity);
        this.addElement((ElementBase)this.decDuration);
        this.addElement((ElementBase)this.incDuration);
        this.plateTop = new ElementIcon((GuiBase)this, 134, 32, IconRegistry.getIcon((String)"PlateTop", (int)this.myTile.getFacing()));
        this.addElement((ElementBase)this.plateTop);
    }

    public void func_73876_c() {
        super.func_73876_c();
        if (!this.myTile.canAccess()) {
            ((GuiScreen)this).field_146297_k.field_71439_g.func_71053_j();
        }
    }

    public void handleElementButtonClick(String string, int n) {
        int n2 = 1;
        float f = 0.7f;
        byte by = this.myTile.distance;
        byte by2 = this.myTile.intensity;
        byte by3 = this.myTile.duration;
        if (GuiScreen.func_146272_n()) {
            n2 = 10;
            f = 0.9f;
            if (n == 1) {
                n2 = 5;
                f = 0.8f;
            }
        }
        if (string.equalsIgnoreCase("decDistance")) {
            this.myTile.distance = (byte)(this.myTile.distance - n2);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("incDistance")) {
            this.myTile.distance = (byte)(this.myTile.distance + n2);
            f += 0.1f;
        } else if (string.equalsIgnoreCase("decIntensity")) {
            this.myTile.intensity = (byte)(this.myTile.intensity - n2);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("incIntensity")) {
            this.myTile.intensity = (byte)(this.myTile.intensity + n2);
            f += 0.1f;
        } else if (string.equalsIgnoreCase("decDuration")) {
            this.myTile.duration = (byte)(this.myTile.duration - n2);
            f -= 0.1f;
        } else if (string.equalsIgnoreCase("incDuration")) {
            this.myTile.duration = (byte)(this.myTile.duration + n2);
            f += 0.1f;
        }
        GuiPlateSignal.playSound((String)"random.click", (float)1.0f, (float)f);
        this.myTile.sendModePacket();
        this.myTile.distance = by;
        this.myTile.intensity = by2;
        this.myTile.duration = by3;
    }

    protected void updateElementInformation() {
        if (this.myTile.distance > 0) {
            this.decDistance.setActive();
        } else {
            this.decDistance.setDisabled();
        }
        if (this.myTile.distance < 15) {
            this.incDistance.setActive();
        } else {
            this.incDistance.setDisabled();
        }
        if (this.myTile.intensity > 0) {
            this.decIntensity.setActive();
        } else {
            this.decIntensity.setDisabled();
        }
        if (this.myTile.intensity < 15) {
            this.incIntensity.setActive();
        } else {
            this.incIntensity.setDisabled();
        }
        if (this.myTile.duration > 2) {
            this.decDuration.setActive();
        } else {
            this.decDuration.setDisabled();
        }
        if (this.myTile.duration < 40) {
            this.incDuration.setActive();
        } else {
            this.incDuration.setDisabled();
        }
        this.plateTop.setIcon(IconRegistry.getIcon((String)"PlateTop", (int)this.myTile.getFacing()));
    }

    protected void func_146979_b(int n, int n2) {
        int n3 = 26;
        int n4 = 62;
        int n5 = 98;
        String string = String.format("%-8s", "" + (this.myTile.distance + 1));
        String string2 = String.format("%-8s", "" + this.myTile.intensity);
        String string3 = String.format("%-8s", "" + this.myTile.duration);
        if (this.myTile.distance < 10) {
            n3 += 6;
        }
        if (this.myTile.intensity < 10) {
            n4 += 6;
        }
        if (this.myTile.duration < 10) {
            n5 += 6;
        }
        ((GuiScreen)this).field_146289_q.func_78276_b(string, n3, 56, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(string2, n4, 56, 0x404040);
        ((GuiScreen)this).field_146289_q.func_78276_b(string3, n5, 56, 0x404040);
        super.func_146979_b(n, n2);
    }

    protected void func_73864_a(int n, int n2, int n3) {
        if (134 <= ((GuiBase)this).mouseX && ((GuiBase)this).mouseX < 150 && 32 <= ((GuiBase)this).mouseY && ((GuiBase)this).mouseY < 48) {
            int n4 = this.myTile.getFacing();
            float f = 0.7f;
            if (n3 == 1) {
                n4 += 5;
                f -= 0.1f;
            } else {
                ++n4;
                f += 0.1f;
            }
            if (this.myTile.setFacing(n4 %= 6)) {
                GuiPlateSignal.playSound((String)"random.click", (float)1.0f, (float)f);
                this.myTile.sendModePacket();
            }
        } else {
            super.func_73864_a(n, n2, n3);
        }
    }
}

