/*
 * Decompiled with CFR 0.152.
 */
package com.robrit.moofluids.common.util;

import java.awt.Color;
import java.util.ArrayList;

public class ColorHelper {
    private static final int COLOR_COMPONENT_MAX_VALUE = 255;

    public static Color getMeanColour(int[] dataArray) {
        short[] allRedStored = new short[dataArray.length];
        short[] allGreenStored = new short[dataArray.length];
        short[] allBlueStored = new short[dataArray.length];
        for (int pixelIndex = 0; pixelIndex < dataArray.length; ++pixelIndex) {
            allRedStored[pixelIndex] = (short)(dataArray[pixelIndex] >> 16 & 0xFF);
            allGreenStored[pixelIndex] = (short)(dataArray[pixelIndex] >> 8 & 0xFF);
            allBlueStored[pixelIndex] = (short)(dataArray[pixelIndex] & 0xFF);
        }
        int aggregateRed = 0;
        int aggregateGreen = 0;
        int aggregateBlue = 0;
        for (int colourIndex = 0; colourIndex < dataArray.length; ++colourIndex) {
            aggregateRed += allRedStored[colourIndex];
            aggregateGreen += allGreenStored[colourIndex];
            aggregateBlue += allBlueStored[colourIndex];
        }
        int meanRed = 255;
        int meanGreen = 255;
        int meanBlue = 255;
        meanRed = (short)(aggregateRed / (allRedStored.length > 0 ? allRedStored.length : 1));
        meanGreen = (short)(aggregateGreen / (allGreenStored.length > 0 ? allGreenStored.length : 1));
        meanBlue = (short)(aggregateBlue / (allBlueStored.length > 0 ? allBlueStored.length : 1));
        return new Color(meanRed, meanGreen, meanBlue, 128);
    }

    public static Color getMeanColour(int[][] data2dArray) {
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (int dataIndexX = 0; dataIndexX < data2dArray.length; ++dataIndexX) {
            for (int dataIndexY = 0; dataIndexY < data2dArray[dataIndexX].length; ++dataIndexY) {
                list.add(data2dArray[dataIndexX][dataIndexY]);
            }
        }
        int[] data1dArray = new int[list.size()];
        for (int dataIndex = 0; dataIndex < data1dArray.length; ++dataIndex) {
            data1dArray[dataIndex] = (Integer)list.get(dataIndex);
        }
        return ColorHelper.getMeanColour(data1dArray);
    }
}

