/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.items.netmonitor;

import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.common.network.simpleimpl.IMessageHandler;
import cpw.mods.fml.common.network.simpleimpl.MessageContext;
import io.netty.buffer.ByteBuf;
import java.util.HashMap;
import java.util.Map;
import mcjty.rftools.BlockInfo;
import mcjty.rftools.items.netmonitor.GuiNetworkMonitor;
import mcjty.varia.Coordinate;

public class PacketConnectedBlocksReady
implements IMessage,
IMessageHandler<PacketConnectedBlocksReady, IMessage> {
    private int minx;
    private int miny;
    private int minz;
    private Map<Coordinate, BlockInfo> blockInfoMap;

    public void fromBytes(ByteBuf buf) {
        this.minx = buf.readInt();
        this.miny = buf.readInt();
        this.minz = buf.readInt();
        int size = buf.readInt();
        this.blockInfoMap = new HashMap<Coordinate, BlockInfo>();
        for (int i = 0; i < size; ++i) {
            Coordinate coordinate = new Coordinate(buf.readShort() + this.minx, buf.readShort() + this.miny, buf.readShort() + this.minz);
            BlockInfo blockInfo = new BlockInfo(coordinate, buf.readInt(), buf.readInt());
            this.blockInfoMap.put(coordinate, blockInfo);
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.minx);
        buf.writeInt(this.miny);
        buf.writeInt(this.minz);
        buf.writeInt(this.blockInfoMap.size());
        for (Map.Entry<Coordinate, BlockInfo> me : this.blockInfoMap.entrySet()) {
            Coordinate c = me.getKey();
            buf.writeShort(c.getX() - this.minx);
            buf.writeShort(c.getY() - this.miny);
            buf.writeShort(c.getZ() - this.minz);
            buf.writeInt(me.getValue().getEnergyStored());
            buf.writeInt(me.getValue().getMaxEnergyStored());
        }
    }

    public PacketConnectedBlocksReady() {
    }

    public PacketConnectedBlocksReady(Map<Coordinate, BlockInfo> blockInfoMap, int minx, int miny, int minz) {
        this.blockInfoMap = new HashMap<Coordinate, BlockInfo>(blockInfoMap);
        this.minx = minx;
        this.miny = miny;
        this.minz = minz;
    }

    public IMessage onMessage(PacketConnectedBlocksReady message, MessageContext ctx) {
        GuiNetworkMonitor.setServerConnectedBlocks(message.blockInfoMap);
        return null;
    }
}

