/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.commands;

import mcjty.rftools.commands.AbstractRfToolsCommand;
import mcjty.rftools.dimension.DimensionStorage;
import mcjty.rftools.dimension.RfToolsDimensionManager;
import net.minecraft.command.ICommandSender;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;

public class CmdDelDimension
extends AbstractRfToolsCommand {
    @Override
    public String getHelp() {
        return "<dimension>";
    }

    @Override
    public String getCommand() {
        return "deldim";
    }

    @Override
    public int getPermissionLevel() {
        return 3;
    }

    @Override
    public boolean isClientSide() {
        return false;
    }

    @Override
    public void execute(ICommandSender sender, String[] args) {
        if (args.length < 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "The dimension parameters is missing!"));
            return;
        }
        if (args.length > 2) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Too many parameters!"));
            return;
        }
        int dim = this.fetchInt(sender, args, 1, 0);
        World world = sender.func_130014_f_();
        RfToolsDimensionManager dimensionManager = RfToolsDimensionManager.getDimensionManager(world);
        if (dimensionManager.getDimensionDescriptor(dim) == null) {
            sender.func_145747_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + "Not an RFTools dimension!"));
            return;
        }
        dimensionManager.removeDimension(dim);
        dimensionManager.save(world);
        DimensionStorage dimensionStorage = DimensionStorage.getDimensionStorage(world);
        dimensionStorage.removeDimension(dim);
        dimensionStorage.save(world);
        sender.func_145747_a((IChatComponent)new ChatComponentText("Dimension deleted."));
    }
}

