/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spawner;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.api.Infusable;
import mcjty.container.GenericContainerBlock;
import mcjty.container.WrenchUsage;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spawner.GuiMatterBeamer;
import mcjty.rftools.blocks.spawner.MatterBeamerContainer;
import mcjty.rftools.blocks.spawner.MatterBeamerTileEntity;
import mcjty.varia.Coordinate;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class MatterBeamerBlock
extends GenericContainerBlock
implements Infusable {
    private IIcon iconSideOn;

    public MatterBeamerBlock() {
        super(Material.field_151573_f, MatterBeamerTileEntity.class);
        this.func_149663_c("matterBeamerBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This block converts matter into a beam");
            list.add(EnumChatFormatting.WHITE + "of energy. It can then send that beam to");
            list.add(EnumChatFormatting.WHITE + "a connected spawner. Connect by using a wrench.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power usage");
            list.add(EnumChatFormatting.YELLOW + "and increased speed.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        TileEntity te = accessor.getTileEntity();
        if (te instanceof MatterBeamerTileEntity) {
            MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)te;
            Coordinate coordinate = matterBeamerTileEntity.getDestination();
            if (coordinate == null) {
                currenttip.add(EnumChatFormatting.RED + "Not connected to a spawner!");
            } else {
                currenttip.add(EnumChatFormatting.GREEN + "Connected!");
            }
        }
        return currenttip;
    }

    @Override
    public int getGuiID() {
        return RFTools.GUI_MATTER_BEAMER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        MatterBeamerTileEntity beamerTileEntity = (MatterBeamerTileEntity)tileEntity;
        MatterBeamerContainer beamerContainer = new MatterBeamerContainer(entityPlayer, beamerTileEntity);
        return new GuiMatterBeamer(beamerTileEntity, beamerContainer);
    }

    @Override
    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new MatterBeamerContainer(entityPlayer, (MatterBeamerTileEntity)tileEntity);
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sx, float sy, float sz) {
        WrenchUsage wrenchUsed = this.testWrenchUsage(x, y, z, player);
        if (wrenchUsed == WrenchUsage.NORMAL) {
            if (world.field_72995_K) {
                MatterBeamerTileEntity matterBeamerTileEntity = (MatterBeamerTileEntity)world.func_147438_o(x, y, z);
                world.func_72980_b((double)x, (double)y, (double)z, "note.pling", 1.0f, 1.0f, false);
                matterBeamerTileEntity.useWrench(player);
            }
            return true;
        }
        if (wrenchUsed == WrenchUsage.SNEAKING) {
            this.breakAndRemember(world, player, x, y, z);
            return true;
        }
        return this.openGui(world, x, y, z, player);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:machineBeamerOff");
        this.iconSideOn = iconRegister.func_94245_a("rftools:machineBeamer");
    }

    @Override
    public IIcon func_149673_e(IBlockAccess blockAccess, int x, int y, int z, int side) {
        int meta = blockAccess.func_72805_g(x, y, z);
        if ((meta & 1) > 0) {
            return this.iconSideOn;
        }
        return this.iconSide;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.iconSide;
    }
}

