/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.spaceprojector;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.container.GenericContainerBlock;
import mcjty.container.WrenchUsage;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberControllerTileEntity;
import mcjty.rftools.blocks.spaceprojector.SpaceChamberRepository;
import mcp.mobius.waila.api.IWailaConfigHandler;
import mcp.mobius.waila.api.IWailaDataAccessor;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class SpaceChamberControllerBlock
extends GenericContainerBlock {
    public SpaceChamberControllerBlock() {
        super(Material.field_151573_f, SpaceChamberControllerTileEntity.class);
        this.func_149663_c("spaceChamberControllerBlock");
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            list.add(EnumChatFormatting.GREEN + "Channel: " + channel);
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            list.add(EnumChatFormatting.WHITE + "This block is one of the eight corners of an");
            list.add(EnumChatFormatting.WHITE + "area of space you want to project elsewhere");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public List<String> getWailaBody(ItemStack itemStack, List<String> currenttip, IWailaDataAccessor accessor, IWailaConfigHandler config) {
        super.getWailaBody(itemStack, currenttip, accessor, config);
        NBTTagCompound tagCompound = accessor.getNBTData();
        if (tagCompound != null) {
            int channel = tagCompound.func_74762_e("channel");
            currenttip.add(EnumChatFormatting.GREEN + "Channel: " + channel);
        }
        return currenttip;
    }

    @Override
    public int getGuiID() {
        return -1;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sx, float sy, float sz) {
        WrenchUsage wrenchUsed = this.testWrenchUsage(x, y, z, player);
        if (wrenchUsed == WrenchUsage.NORMAL) {
            if (world.field_72995_K) {
                world.func_72980_b((double)x, (double)y, (double)z, "note.pling", 1.0f, 1.0f, false);
            } else {
                SpaceChamberControllerTileEntity chamberControllerTileEntity = (SpaceChamberControllerTileEntity)world.func_147438_o(x, y, z);
                chamberControllerTileEntity.createChamber(player);
            }
            return true;
        }
        if (wrenchUsed == WrenchUsage.SNEAKING) {
            this.breakAndRemember(world, player, x, y, z);
            return true;
        }
        return this.openGui(world, x, y, z, player);
    }

    @Override
    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entityLivingBase, ItemStack itemStack) {
        super.func_149689_a(world, x, y, z, entityLivingBase, itemStack);
        if (!world.field_72995_K) {
            SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(world);
            SpaceChamberControllerTileEntity te = (SpaceChamberControllerTileEntity)world.func_147438_o(x, y, z);
            if (te.getChannel() == -1) {
                int id = chamberRepository.newChannel();
                te.setChannel(id);
                chamberRepository.save(world);
            }
            this.func_149695_a(world, x, y, z, this);
        }
    }

    public void func_149749_a(World world, int x, int y, int z, Block block, int meta) {
        if (!world.field_72995_K) {
            SpaceChamberRepository chamberRepository = SpaceChamberRepository.getChannels(world);
            SpaceChamberControllerTileEntity te = (SpaceChamberControllerTileEntity)world.func_147438_o(x, y, z);
            if (te.getChannel() != -1) {
                chamberRepository.deleteChannel(te.getChannel());
                chamberRepository.save(world);
            }
        }
        super.func_149749_a(world, x, y, z, block, meta);
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public int func_149701_w() {
        return 1;
    }

    @Override
    public void func_149651_a(IIconRegister iconRegister) {
        this.iconSide = iconRegister.func_94245_a("rftools:machineSpaceChamberController");
    }

    @Override
    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int side) {
        return this.iconSide;
    }

    @Override
    public IIcon func_149691_a(int side, int meta) {
        return this.iconSide;
    }
}

