/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.screens.modulesclient;

import java.util.ArrayList;
import java.util.List;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.ColorChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalAlignment;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.AbstractWidget;
import mcjty.gui.widgets.BlockRender;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.ColorChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.ToggleButton;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.screens.ModuleGuiChanged;
import mcjty.rftools.blocks.screens.modulesclient.FormatStyle;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class ScreenModuleGuiBuilder {
    private Minecraft mc;
    private Gui gui;
    private NBTTagCompound currentData;
    private ModuleGuiChanged moduleGuiChanged;
    private Panel panel;
    private List<Widget> row = new ArrayList<Widget>();

    public ScreenModuleGuiBuilder(Minecraft mc, Gui gui, NBTTagCompound currentData, ModuleGuiChanged moduleGuiChanged) {
        this.gui = gui;
        this.mc = mc;
        this.moduleGuiChanged = moduleGuiChanged;
        this.currentData = currentData;
        this.panel = new Panel(mc, gui).setLayout(new VerticalLayout());
    }

    public Panel build() {
        this.nl();
        return this.panel;
    }

    public ScreenModuleGuiBuilder label(String text) {
        Object label = new Label(this.mc, this.gui).setText(text);
        this.row.add((Widget)label);
        return this;
    }

    public ScreenModuleGuiBuilder leftLabel(String text) {
        Object label = ((Label)new Label(this.mc, this.gui).setText(text)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT);
        this.row.add((Widget)label);
        return this;
    }

    public ScreenModuleGuiBuilder text(final String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField(this.mc, this.gui).setDesiredHeight(16)).setTooltips(tooltip)).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                ScreenModuleGuiBuilder.this.currentData.func_74778_a(tagname, newText);
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }
        });
        this.row.add(textField);
        if (this.currentData != null) {
            textField.setText(this.currentData.func_74779_i(tagname));
        }
        return this;
    }

    public ScreenModuleGuiBuilder integer(final String tagname, String ... tooltip) {
        TextField textField = ((TextField)((TextField)new TextField(this.mc, this.gui).setDesiredHeight(16)).setTooltips(tooltip)).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                int value;
                try {
                    value = Integer.parseInt(newText);
                }
                catch (NumberFormatException e) {
                    value = 0;
                }
                ScreenModuleGuiBuilder.this.currentData.func_74768_a(tagname, value);
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }
        });
        this.row.add(textField);
        if (this.currentData != null) {
            textField.setText(Integer.toString(this.currentData.func_74762_e(tagname)));
        }
        return this;
    }

    public ScreenModuleGuiBuilder toggle(final String tagname, String label, String ... tooltip) {
        final ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, this.gui).setText(label)).setTooltips(tooltip)).setDesiredHeight(13)).setCheckMarker(true);
        toggleButton.addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                ScreenModuleGuiBuilder.this.currentData.func_74757_a(tagname, toggleButton.isPressed());
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }
        });
        this.row.add(toggleButton);
        if (this.currentData != null) {
            toggleButton.setPressed(this.currentData.func_74767_n(tagname));
        }
        return this;
    }

    public ScreenModuleGuiBuilder toggleNegative(final String tagname, String label, String ... tooltip) {
        final ToggleButton toggleButton = ((ToggleButton)((ToggleButton)((ToggleButton)new ToggleButton(this.mc, this.gui).setText(label)).setTooltips(tooltip)).setDesiredHeight(13)).setCheckMarker(true);
        toggleButton.addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                ScreenModuleGuiBuilder.this.currentData.func_74757_a(tagname, !toggleButton.isPressed());
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }
        });
        this.row.add(toggleButton);
        if (this.currentData != null) {
            toggleButton.setPressed(!this.currentData.func_74767_n(tagname));
        } else {
            toggleButton.setPressed(true);
        }
        return this;
    }

    public ScreenModuleGuiBuilder color(final String tagname, String ... tooltip) {
        int currentColor;
        ColorChoiceLabel colorSelector = ((ColorChoiceLabel)((ColorChoiceLabel)((ColorChoiceLabel)new ColorChoiceLabel(this.mc, this.gui).setTooltips(tooltip)).addColors(0xFFFFFF, 0xFF0000, 65280, 255, 0xFFFF00, 0xFF00FF, 65535).setDesiredWidth(15)).setDesiredHeight(14)).addChoiceEvent(new ColorChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, Integer newColor) {
                ScreenModuleGuiBuilder.this.currentData.func_74768_a(tagname, newColor.intValue());
                ScreenModuleGuiBuilder.this.moduleGuiChanged.updateData();
            }
        });
        this.row.add(colorSelector);
        if (this.currentData != null && (currentColor = this.currentData.func_74762_e(tagname)) != 0) {
            colorSelector.setCurrentColor(currentColor);
        }
        return this;
    }

    public ScreenModuleGuiBuilder format() {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupFormatCombo(this.mc, this.gui, this.currentData, this.moduleGuiChanged);
        this.row.add(label);
        return this;
    }

    public ScreenModuleGuiBuilder mode(String componentName) {
        ChoiceLabel label = ScreenModuleGuiBuilder.setupModeCombo(this.mc, this.gui, componentName, this.currentData, this.moduleGuiChanged);
        this.row.add(label);
        return this;
    }

    public ScreenModuleGuiBuilder monitor() {
        String monitoring;
        if (this.currentData.func_74764_b("monitorx")) {
            int dim = this.currentData.func_74762_e("dim");
            World world = this.mc.field_71439_g.field_70170_p;
            if (dim == world.field_73011_w.field_76574_g) {
                int x = this.currentData.func_74762_e("monitorx");
                int y = this.currentData.func_74762_e("monitory");
                int z = this.currentData.func_74762_e("monitorz");
                monitoring = this.currentData.func_74779_i("monitorname");
                Block block = world.func_147439_a(x, y, z);
                this.row.add(new BlockRender(this.mc, this.gui).setRenderItem(block).setDesiredWidth(20));
                this.row.add(((AbstractWidget)((Label)new Label(this.mc, this.gui).setText(x + "," + y + "," + z)).setHorizontalAlignment(HorizontalAlignment.ALIGH_LEFT)).setDesiredWidth(150));
            } else {
                monitoring = "<unreachable>";
            }
        } else {
            monitoring = "<not set>";
        }
        this.row.add((Widget)new Label(this.mc, this.gui).setText(monitoring));
        return this;
    }

    public ScreenModuleGuiBuilder nl() {
        if (this.row.size() == 1) {
            this.panel.addChild((Widget)this.row.get(0).setDesiredHeight(16));
            this.row.clear();
        } else if (!this.row.isEmpty()) {
            Panel rowPanel = (Panel)new Panel(this.mc, this.gui).setLayout(new HorizontalLayout()).setDesiredHeight(16);
            for (Widget widget : this.row) {
                rowPanel.addChild(widget);
            }
            this.panel.addChild(rowPanel);
            this.row.clear();
        }
        return this;
    }

    private static ChoiceLabel setupFormatCombo(Minecraft mc, Gui gui, final NBTTagCompound currentData, final ModuleGuiChanged moduleGuiChanged) {
        String modeFull = FormatStyle.MODE_FULL.getName();
        String modeCompact = FormatStyle.MODE_COMPACT.getName();
        String modeCommas = FormatStyle.MODE_COMMAS.getName();
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(60)).setDesiredHeight(13)).addChoices(modeFull, modeCompact, modeCommas).setChoiceTooltip(modeFull, "Full format: 3123555").setChoiceTooltip(modeCompact, "Compact format: 3.1M").setChoiceTooltip(modeCommas, "Comma format: 3,123,555").addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                currentData.func_74768_a("format", FormatStyle.getStyle(newChoice).ordinal());
                moduleGuiChanged.updateData();
            }
        });
        FormatStyle currentFormat = FormatStyle.values()[currentData.func_74762_e("format")];
        modeButton.setChoice(currentFormat.getName());
        return modeButton;
    }

    private static ChoiceLabel setupModeCombo(Minecraft mc, Gui gui, final String componentName, final NBTTagCompound currentData, final ModuleGuiChanged moduleGuiChanged) {
        String modeNone = "None";
        final String modePertick = componentName + "/t";
        final String modePct = componentName + "%";
        ChoiceLabel modeButton = ((ChoiceLabel)((ChoiceLabel)new ChoiceLabel(mc, gui).setDesiredWidth(60)).setDesiredHeight(13)).addChoices(modeNone, componentName, modePertick, modePct).setChoiceTooltip(modeNone, "No text is shown").setChoiceTooltip(componentName, "Show the amount of " + componentName).setChoiceTooltip(modePertick, "Show the average " + componentName + "/tick", "gain or loss").setChoiceTooltip(modePct, "Show the amount of " + componentName, "as a percentage").addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                if (componentName.equals(newChoice)) {
                    currentData.func_74757_a("showdiff", false);
                    currentData.func_74757_a("showpct", false);
                    currentData.func_74757_a("hidetext", false);
                } else if (modePertick.equals(newChoice)) {
                    currentData.func_74757_a("showdiff", true);
                    currentData.func_74757_a("showpct", false);
                    currentData.func_74757_a("hidetext", false);
                } else if (modePct.equals(newChoice)) {
                    currentData.func_74757_a("showdiff", false);
                    currentData.func_74757_a("showpct", true);
                    currentData.func_74757_a("hidetext", false);
                } else {
                    currentData.func_74757_a("showdiff", false);
                    currentData.func_74757_a("showpct", false);
                    currentData.func_74757_a("hidetext", true);
                }
                moduleGuiChanged.updateData();
            }
        });
        if (currentData.func_74767_n("hidetext")) {
            modeButton.setChoice(modeNone);
        } else if (currentData.func_74767_n("showdiff")) {
            modeButton.setChoice(modePertick);
        } else if (currentData.func_74767_n("showpct")) {
            modeButton.setChoice(modePct);
        } else {
            modeButton.setChoice(componentName);
        }
        return modeButton;
    }
}

