/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.logic;

import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mcjty.container.GenericGuiContainer;
import mcjty.gui.Window;
import mcjty.gui.events.ButtonEvent;
import mcjty.gui.events.ChoiceEvent;
import mcjty.gui.events.TextEvent;
import mcjty.gui.layout.HorizontalLayout;
import mcjty.gui.layout.VerticalLayout;
import mcjty.gui.widgets.Button;
import mcjty.gui.widgets.ChoiceLabel;
import mcjty.gui.widgets.ImageChoiceLabel;
import mcjty.gui.widgets.Label;
import mcjty.gui.widgets.Panel;
import mcjty.gui.widgets.TextField;
import mcjty.gui.widgets.Widget;
import mcjty.rftools.blocks.logic.SequencerMode;
import mcjty.rftools.blocks.logic.SequencerTileEntity;
import mcjty.rftools.network.Argument;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.inventory.Container;
import net.minecraft.util.ResourceLocation;

public class GuiSequencer
extends GenericGuiContainer<SequencerTileEntity> {
    public static final int SEQUENCER_WIDTH = 160;
    public static final int SEQUENCER_HEIGHT = 184;
    private List<ImageChoiceLabel> bits = new ArrayList<ImageChoiceLabel>();
    private ChoiceLabel mode;
    private TextField speedField;
    private static final ResourceLocation iconGuiElements = new ResourceLocation("rftools", "textures/gui/guielements.png");

    public GuiSequencer(SequencerTileEntity sequencerTileEntity, Container container) {
        super(sequencerTileEntity, container);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        int k = (this.field_146294_l - 160) / 2;
        int l = (this.field_146295_m - 184) / 2;
        Panel toplevel = ((Panel)new Panel(this.field_146297_k, (Gui)this).setFilledRectThickness(2)).setLayout(new VerticalLayout());
        this.initGuiGrid(toplevel);
        Button clearButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Clear")).setTooltips(new String[]{"Clear the grid"})).setDesiredHeight(13)).setDesiredWidth(45)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSequencer.this.fillGrid(false);
            }
        });
        Button fillButton = ((Button)((Button)((Button)((Button)new Button(this.field_146297_k, (Gui)this).setText("Fill")).setTooltips(new String[]{"Fill the grid"})).setDesiredHeight(13)).setDesiredWidth(45)).addButtonEvent(new ButtonEvent(){

            @Override
            public void buttonClicked(Widget parent) {
                GuiSequencer.this.fillGrid(true);
            }
        });
        Panel buttonPanel = (Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(clearButton)).addChild(fillButton);
        toplevel.addChild(buttonPanel);
        this.initGuiMode();
        Object label = new Label(this.field_146297_k, (Gui)this).setText("Delay:");
        this.speedField = new TextField(this.field_146297_k, (Gui)this).addTextEvent(new TextEvent(){

            @Override
            public void textChanged(Widget parent, String newText) {
                GuiSequencer.this.setDelay();
            }
        });
        int delay = ((SequencerTileEntity)this.tileEntity).getDelay();
        if (delay <= 0) {
            delay = 1;
        }
        this.speedField.setText(String.valueOf(delay));
        Panel bottomPanel = (Panel)((Panel)((Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).addChild(this.mode)).addChild((Widget)label)).addChild(this.speedField);
        toplevel.addChild(bottomPanel);
        toplevel.setBounds(new Rectangle(k, l, 160, 184));
        this.window = new Window((GuiScreen)this, toplevel);
    }

    private void initGuiGrid(Panel toplevel) {
        for (int row = 0; row < 8; ++row) {
            Panel rowPanel = (Panel)new Panel(this.field_146297_k, (Gui)this).setLayout(new HorizontalLayout()).setDesiredHeight(13);
            toplevel.addChild(rowPanel);
            for (int col = 0; col < 8; ++col) {
                final int bit = row * 8 + col;
                ImageChoiceLabel choiceLabel = ((ImageChoiceLabel)new ImageChoiceLabel(this.field_146297_k, (Gui)this).addChoiceEvent(new ChoiceEvent(){

                    @Override
                    public void choiceChanged(Widget parent, String newChoice) {
                        GuiSequencer.this.changeBit(bit, newChoice);
                    }
                }).setDesiredHeight(12)).addChoice("0", "Disabled", iconGuiElements, 160, 0).addChoice("1", "Enabled", iconGuiElements, 176, 0);
                choiceLabel.setCurrentChoice(((SequencerTileEntity)this.tileEntity).getCycleBit(bit) ? 1 : 0);
                this.bits.add(choiceLabel);
                rowPanel.addChild(choiceLabel);
            }
        }
    }

    private void initGuiMode() {
        this.mode = (ChoiceLabel)((ChoiceLabel)new ChoiceLabel(this.field_146297_k, (Gui)this).setDesiredHeight(13)).setDesiredWidth(55);
        this.mode.addChoices(SequencerMode.MODE_ONCE1.getDescription());
        this.mode.addChoices(SequencerMode.MODE_ONCE2.getDescription());
        this.mode.addChoices(SequencerMode.MODE_LOOP1.getDescription());
        this.mode.addChoices(SequencerMode.MODE_LOOP2.getDescription());
        this.mode.addChoices(SequencerMode.MODE_LOOP3.getDescription());
        this.mode.addChoices(SequencerMode.MODE_LOOP4.getDescription());
        this.mode.addChoices(SequencerMode.MODE_STEP.getDescription());
        this.mode.setChoiceTooltip(SequencerMode.MODE_ONCE1.getDescription(), "When a redstone signal is", "received, loop the cycle once.", "Ignore further pulses");
        this.mode.setChoiceTooltip(SequencerMode.MODE_ONCE2.getDescription(), "When a redstone signal is", "received, loop the cycle once.", "Restart if new pulse arrives");
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP1.getDescription(), "Loop the cycle all the time.", "Ignore redstone signals");
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP2.getDescription(), "Loop the cycle all the time.", "Restart on redstone pulse");
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP3.getDescription(), "Loop the cycle when redstone.", "signal is present. Continue at current step");
        this.mode.setChoiceTooltip(SequencerMode.MODE_LOOP4.getDescription(), "Loop the cycle when redstone.", "signal is present. Restart on no signal");
        this.mode.setChoiceTooltip(SequencerMode.MODE_STEP.getDescription(), "Do one step in the cycle", "for every redstone pulse");
        this.mode.setChoice(((SequencerTileEntity)this.tileEntity).getMode().getDescription());
        this.mode.addChoiceEvent(new ChoiceEvent(){

            @Override
            public void choiceChanged(Widget parent, String newChoice) {
                GuiSequencer.this.changeMode();
            }
        });
    }

    private void setDelay() {
        int delay;
        String d = this.speedField.getText();
        try {
            delay = Integer.parseInt(d);
        }
        catch (NumberFormatException e) {
            delay = 1;
        }
        ((SequencerTileEntity)this.tileEntity).setDelay(delay);
        this.sendServerCommand("setDelay", new Argument("delay", delay));
    }

    private void fillGrid(boolean value) {
        for (int bit = 0; bit < 64; ++bit) {
            this.bits.get(bit).setCurrentChoice(value ? 1 : 0);
        }
        ((SequencerTileEntity)this.tileEntity).setCycleBits(0, 63, value);
        this.sendServerCommand("setBits", new Argument("start", 0), new Argument("stop", 63), new Argument("choice", value));
    }

    private void changeBit(int bit, String choice) {
        boolean newChoice = "1".equals(choice);
        ((SequencerTileEntity)this.tileEntity).setCycleBit(bit, newChoice);
        this.sendServerCommand("setBit", new Argument("bit", bit), new Argument("choice", newChoice));
    }

    private void changeMode() {
        SequencerMode newMode = SequencerMode.getMode(this.mode.getCurrentChoice());
        ((SequencerTileEntity)this.tileEntity).setMode(newMode);
        this.sendServerCommand("mode", new Argument("mode", newMode.getDescription()));
    }

    protected void func_146976_a(float v, int i, int i2) {
        this.window.draw();
    }
}

