/*
 * Decompiled with CFR 0.152.
 */
package mcjty.rftools.blocks.crafter;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mcjty.api.Infusable;
import mcjty.container.GenericContainerBlock;
import mcjty.rftools.RFTools;
import mcjty.rftools.blocks.crafter.CrafterBaseTE;
import mcjty.rftools.blocks.crafter.CrafterBlockTileEntity1;
import mcjty.rftools.blocks.crafter.CrafterBlockTileEntity2;
import mcjty.rftools.blocks.crafter.CrafterContainer;
import mcjty.rftools.blocks.crafter.GuiCrafter;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.world.World;
import org.lwjgl.input.Keyboard;

public class CrafterBlock
extends GenericContainerBlock
implements Infusable {
    private String frontName;

    public CrafterBlock(String blockName, String frontName, Class<? extends TileEntity> tileEntityClass) {
        super(Material.field_151573_f, tileEntityClass);
        this.func_149663_c(blockName);
        this.frontName = frontName;
        this.func_149647_a(RFTools.tabRfTools);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addInformation(ItemStack itemStack, EntityPlayer player, List list, boolean whatIsThis) {
        super.addInformation(itemStack, player, list, whatIsThis);
        NBTTagCompound tagCompound = itemStack.func_77978_p();
        if (tagCompound != null) {
            NBTTagList bufferTagList = tagCompound.func_150295_c("Items", 10);
            NBTTagList recipeTagList = tagCompound.func_150295_c("Recipes", 10);
            list.add(EnumChatFormatting.GREEN + "Contents: " + bufferTagList.func_74745_c() + " stacks");
            int rc = 0;
            for (int i = 0; i < recipeTagList.func_74745_c(); ++i) {
                ItemStack stack;
                NBTTagCompound tagRecipe = recipeTagList.func_150305_b(i);
                NBTTagCompound resultCompound = tagRecipe.func_74775_l("Result");
                if (resultCompound == null || (stack = ItemStack.func_77949_a((NBTTagCompound)resultCompound)) == null) continue;
                ++rc;
            }
            list.add(EnumChatFormatting.GREEN + "Recipes: " + rc + " recipes");
        }
        if (Keyboard.isKeyDown((int)42) || Keyboard.isKeyDown((int)54)) {
            int amount = this.tileEntityClass.equals(CrafterBlockTileEntity1.class) ? 2 : (this.tileEntityClass.equals(CrafterBlockTileEntity2.class) ? 4 : 8);
            list.add(EnumChatFormatting.WHITE + "This machine can handle up to " + amount + " recipes");
            list.add(EnumChatFormatting.WHITE + "at once and allows recipes to use the crafting results");
            list.add(EnumChatFormatting.WHITE + "of previous steps.");
            list.add(EnumChatFormatting.YELLOW + "Infusing bonus: reduced power consumption.");
        } else {
            list.add(EnumChatFormatting.WHITE + "<Press Shift>");
        }
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer player, int side, float sx, float sy, float sz) {
        return this.onBlockActivatedDefaultWrench(world, x, y, z, player);
    }

    public void func_149695_a(World world, int x, int y, int z, Block block) {
        this.checkRedstone(world, x, y, z);
    }

    @Override
    public String getIdentifyingIconName() {
        return this.frontName;
    }

    @Override
    public int getGuiID() {
        return RFTools.GUI_CRAFTER;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public GuiContainer createClientGui(EntityPlayer entityPlayer, TileEntity tileEntity) {
        CrafterBaseTE crafterBlockTileEntity = (CrafterBaseTE)tileEntity;
        CrafterContainer crafterContainer = new CrafterContainer(entityPlayer, crafterBlockTileEntity);
        return new GuiCrafter(crafterBlockTileEntity, crafterContainer);
    }

    @Override
    public Container createServerContainer(EntityPlayer entityPlayer, TileEntity tileEntity) {
        return new CrafterContainer(entityPlayer, (CrafterBaseTE)tileEntity);
    }
}

