/*
 * Decompiled with CFR 0.152.
 */
package ganymedes01.headcrumbs.eventHandlers;

import cpw.mods.fml.common.Loader;
import cpw.mods.fml.common.eventhandler.Event;
import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import ganymedes01.headcrumbs.Headcrumbs;
import ganymedes01.headcrumbs.ModItems;
import ganymedes01.headcrumbs.entity.EntityCelebrity;
import ganymedes01.headcrumbs.libs.SkullTypes;
import ganymedes01.headcrumbs.utils.HeadUtils;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSource;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingDropsEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;

public class HandlerEvents {
    @SubscribeEvent
    public void onCheckSpawn(LivingSpawnEvent.CheckSpawn event) {
        String name;
        if (event.entityLiving instanceof EntityCelebrity && ((name = event.world.field_73011_w.func_80007_l()).equals("Twilight Forest") || name.equals("Erebus") || HandlerEvents.isDimensionBlackListed(event.world.field_73011_w.field_76574_g))) {
            event.setResult(Event.Result.DENY);
        }
    }

    private static boolean isDimensionBlackListed(int dimensionId) {
        for (int id : Headcrumbs.blacklistedDimensions) {
            if (dimensionId != id) continue;
            return true;
        }
        return false;
    }

    @SubscribeEvent
    public void playerDrop(LivingDeathEvent event) {
        EntityLivingBase entity = event.entityLiving;
        if (entity.field_70170_p.func_82736_K().func_82766_b("keepInventory") && entity instanceof EntityPlayerMP) {
            ArrayList<EntityItem> drops = new ArrayList<EntityItem>();
            ItemStack weapon = this.getWeapon(event.source);
            int looting = EnchantmentHelper.func_77506_a((int)Enchantment.field_77335_o.field_77352_x, (ItemStack)weapon);
            this.drop(event.entityLiving, event.source, looting, drops);
            if (!drops.isEmpty()) {
                for (EntityItem item : drops) {
                    ((EntityPlayerMP)entity).func_71012_a(item);
                }
            }
        }
    }

    @SubscribeEvent
    public void dropEvent(LivingDropsEvent event) {
        this.drop(event.entityLiving, event.source, event.lootingLevel, event.drops);
    }

    private void drop(EntityLivingBase entity, DamageSource source, int looting, List<EntityItem> drops) {
        if (entity.field_70170_p.field_72995_K) {
            return;
        }
        if (entity.func_110143_aJ() > 0.0f) {
            return;
        }
        boolean isPoweredCreeper = Headcrumbs.enableChargedCreeperKills && this.isPoweredCreeper(source);
        int beheading = this.getBeaheadingLevel(this.getWeapon(source));
        if (isPoweredCreeper || this.shouldDoRandomDrop(entity.field_70170_p.field_73012_v, beheading, looting)) {
            ItemStack stack = HeadUtils.getHeadfromEntity(entity);
            if (stack == null) {
                return;
            }
            if ((isPoweredCreeper || this.canDropThisHead(stack, beheading)) && (this.isPlayerHead(stack) || Headcrumbs.enableMobsAndAnimalHeads)) {
                this.addDrop(stack, entity, drops);
            }
        }
    }

    private boolean isPoweredCreeper(DamageSource source) {
        Entity entity;
        if (source.func_94541_c() && source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) != null && entity instanceof EntityCreeper) {
            return ((EntityCreeper)entity).func_70830_n();
        }
        return false;
    }

    private boolean canDropThisHead(ItemStack head, int beheading) {
        if (beheading > 0) {
            return head.func_77973_b() != Items.field_151144_bL && !this.isPlayerHead(head);
        }
        return head.func_77973_b() == Items.field_151144_bL ? head.func_77960_j() != 1 && Headcrumbs.enableVanillaHeadsDrop : true;
    }

    private boolean isPlayerHead(ItemStack stack) {
        return stack.func_77973_b() == ModItems.skull && stack.func_77960_j() == SkullTypes.player.ordinal();
    }

    private boolean shouldDoRandomDrop(Random rand, int beheading, int looting) {
        if (beheading > 0) {
            return rand.nextInt(100) < beheading * 10;
        }
        int chance = Math.max(1, Headcrumbs.headDropChance / Math.max(looting + 1, 1));
        return Headcrumbs.enableRandomHeadDrop && rand.nextInt(chance) == 0;
    }

    private int getBeaheadingLevel(ItemStack weapon) {
        if (Loader.isModLoaded((String)"TConstruct")) {
            try {
                Class<?> TinkerTools = Class.forName("tconstruct.tools.TinkerTools");
                Field field = TinkerTools.getDeclaredField("cleaver");
                field.setAccessible(true);
                Item cleaver = (Item)field.get(null);
                int beheading = weapon.func_77978_p().func_74775_l("InfiTool").func_74762_e("Beheading");
                if (cleaver == weapon.func_77973_b()) {
                    beheading += 2;
                }
                return beheading;
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return 0;
    }

    private ItemStack getWeapon(DamageSource source) {
        Entity entity;
        if (source instanceof EntityDamageSource && (entity = ((EntityDamageSource)source).func_76346_g()) instanceof EntityPlayer) {
            return ((EntityPlayer)entity).func_71045_bC();
        }
        return null;
    }

    private void addDrop(ItemStack stack, EntityLivingBase entity, List<EntityItem> list) {
        if (stack.field_77994_a <= 0) {
            return;
        }
        EntityItem entityItem = new EntityItem(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, stack);
        entityItem.field_145804_b = 10;
        list.add(entityItem);
    }
}

