/*
 * Decompiled with CFR 0.152.
 */
package tconstruct.library.tools;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import java.util.Map;
import mantle.items.abstracts.CraftingItem;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IIcon;
import net.minecraft.util.StatCollector;
import tconstruct.library.TConstructRegistry;
import tconstruct.library.tools.CustomMaterial;
import tconstruct.library.tools.ToolMaterial;
import tconstruct.library.util.IToolPart;
import tconstruct.library.util.TextureHelper;
import tconstruct.util.config.PHConstruct;

public class DynamicToolPart
extends CraftingItem
implements IToolPart {
    public String partName;
    public String texture;
    public IIcon defaultIcon;
    public Class<? extends CustomMaterial> customMaterialClass;
    private boolean hidden = false;

    public DynamicToolPart(String texture, String name) {
        this(texture, name, (Class<? extends CustomMaterial>)null);
    }

    public DynamicToolPart(String texture, String name, Class<? extends CustomMaterial> customMaterialClass) {
        this(texture, name, "tinker", customMaterialClass);
    }

    public DynamicToolPart(String texture, String name, String domain) {
        this(texture, name, domain, null);
    }

    public DynamicToolPart(String texture, String name, String domain, Class<? extends CustomMaterial> customMaterialClass) {
        super(null, null, "parts/", domain, (CreativeTabs)TConstructRegistry.partTab);
        this.func_77655_b("tconstruct." + name);
        this.partName = name;
        this.texture = texture;
        this.customMaterialClass = customMaterialClass;
    }

    public DynamicToolPart hide() {
        this.hidden = true;
        return this;
    }

    @Override
    public int getMaterialID(ItemStack stack) {
        if (TConstructRegistry.toolMaterials.keySet().contains(stack.func_77960_j())) {
            return stack.func_77960_j();
        }
        return -1;
    }

    public String func_77653_i(ItemStack stack) {
        String material = "";
        String matName = "";
        if (this.customMaterialClass == null) {
            ToolMaterial toolmat = TConstructRegistry.getMaterial(this.getMaterialID(stack));
            if (toolmat == null) {
                return super.func_77653_i(stack);
            }
            material = toolmat.localizationString.substring(9);
            matName = toolmat.prefixName();
        } else {
            CustomMaterial customMaterial = TConstructRegistry.getCustomMaterial(this.getMaterialID(stack), this.customMaterialClass);
            if (customMaterial == null) {
                return super.func_77653_i(stack);
            }
            material = "";
            if (customMaterial.input != null) {
                material = customMaterial.input.func_77977_a();
                int firstPeriodIndex = material.indexOf(46);
                if (firstPeriodIndex >= 0) {
                    material = material.substring(firstPeriodIndex + 1);
                }
                matName = customMaterial.input.func_82833_r();
            } else {
                material = customMaterial.oredict;
                matName = customMaterial.oredict;
            }
        }
        if (StatCollector.func_94522_b((String)("toolpart." + this.partName + "." + material))) {
            return StatCollector.func_74838_a((String)("toolpart." + this.partName + "." + material));
        }
        if (StatCollector.func_94522_b((String)("toolpart.material." + material))) {
            matName = StatCollector.func_74838_a((String)("toolpart.material." + material));
        }
        return StatCollector.func_74838_a((String)("toolpart." + this.partName)).replaceAll("%%material", matName);
    }

    public String func_77667_c(ItemStack stack) {
        int id = this.getMaterialID(stack);
        if (id == -1) {
            return this.func_77658_a();
        }
        String material = "unknown";
        if (this.customMaterialClass == null) {
            ToolMaterial toolmat = TConstructRegistry.getMaterial(this.getMaterialID(stack));
            material = toolmat.materialName;
        } else {
            CustomMaterial customMaterial = TConstructRegistry.getCustomMaterial(this.getMaterialID(stack), this.customMaterialClass);
            material = customMaterial.input != null ? customMaterial.input.func_77977_a() : customMaterial.oredict;
        }
        return "toolpart." + this.partName + "." + material;
    }

    public void func_150895_a(Item item, CreativeTabs tab, List list) {
        if (this.hidden) {
            return;
        }
        for (Integer matID : TConstructRegistry.defaultToolPartMaterials) {
            ItemStack stack = new ItemStack(item, 1, matID.intValue());
            if (this.getMaterialID(stack) == -1) continue;
            list.add(stack);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IIconRegister iconRegister) {
        int max = -1;
        for (Integer n : TConstructRegistry.toolMaterials.keySet()) {
            if (n <= max) continue;
            max = n;
        }
        this.icons = new IIcon[max + 1];
        if (!PHConstruct.minimalTextures) {
            for (Map.Entry entry : TConstructRegistry.toolMaterials.entrySet()) {
                String tex = this.modTexPrefix + ":" + this.folder + ((ToolMaterial)entry.getValue()).materialName.toLowerCase() + this.texture;
                if (!TextureHelper.itemTextureExists(tex)) continue;
                this.icons[((Integer)entry.getKey()).intValue()] = iconRegister.func_94245_a(tex);
            }
        }
        this.defaultIcon = iconRegister.func_94245_a(this.modTexPrefix + ":" + this.folder + this.texture);
    }

    @SideOnly(value=Side.CLIENT)
    public IIcon func_77617_a(int meta) {
        if (meta > this.icons.length) {
            return this.defaultIcon;
        }
        if (this.icons[meta] == null) {
            return this.defaultIcon;
        }
        return this.icons[meta];
    }

    public int func_82790_a(ItemStack stack, int renderpass) {
        int matId = this.getMaterialID(stack);
        if (matId > this.icons.length) {
            return super.func_82790_a(stack, renderpass);
        }
        if (matId >= 0 && this.icons[matId] == null) {
            if (this.customMaterialClass == null) {
                return TConstructRegistry.getMaterial(this.getMaterialID(stack)).primaryColor();
            }
            return TConstructRegistry.getCustomMaterial((int)this.getMaterialID((ItemStack)stack), this.customMaterialClass).color;
        }
        return super.func_82790_a(stack, renderpass);
    }
}

