/*
 * Decompiled with CFR 0.152.
 */
package mekanism.api.gas;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.eventhandler.Event;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import mekanism.api.Coord4D;
import mekanism.api.ListUtils;
import mekanism.api.gas.Gas;
import mekanism.api.gas.GasStack;
import mekanism.api.gas.GasTransmission;
import mekanism.api.gas.IGasHandler;
import mekanism.api.transmitters.DynamicNetwork;
import mekanism.api.transmitters.IGridTransmitter;
import mekanism.api.transmitters.ITransmitterNetwork;
import mekanism.api.transmitters.TransmissionType;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.util.ForgeDirection;

public class GasNetwork
extends DynamicNetwork<IGasHandler, GasNetwork> {
    public int transferDelay = 0;
    public boolean didTransfer;
    public boolean prevTransfer;
    public float gasScale;
    public Gas refGas;
    public GasStack gasStored;
    public int prevStored;
    public int prevTransferAmount = 0;

    public GasNetwork(IGridTransmitter<GasNetwork> ... varPipes) {
        this.transmitters.addAll(Arrays.asList(varPipes));
        this.register();
    }

    public GasNetwork(Collection<IGridTransmitter<GasNetwork>> collection) {
        this.transmitters.addAll(collection);
        this.register();
    }

    public GasNetwork(Set<GasNetwork> networks) {
        for (GasNetwork net : networks) {
            if (net == null) continue;
            if (FMLCommonHandler.instance().getEffectiveSide().isClient()) {
                if (net.refGas != null && net.gasScale > this.gasScale) {
                    this.gasScale = net.gasScale;
                    this.refGas = net.refGas;
                    this.gasStored = net.gasStored;
                    net.gasScale = 0.0f;
                    net.refGas = null;
                    net.gasStored = null;
                }
            } else if (net.gasStored != null) {
                if (this.gasStored == null) {
                    this.gasStored = net.gasStored;
                } else {
                    this.gasStored.amount += net.gasStored.amount;
                }
                net.gasStored = null;
            }
            this.addAllTransmitters(net.transmitters);
            net.deregister();
        }
        this.gasScale = this.getScale();
        this.register();
    }

    @Override
    public void onNetworksCreated(List<GasNetwork> networks) {
        if (this.gasStored != null && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int[] caps = new int[networks.size()];
            int cap = 0;
            for (GasNetwork network : networks) {
                caps[networks.indexOf((Object)network)] = network.getCapacity();
                cap += network.getCapacity();
            }
            this.gasStored.amount = Math.min(cap, this.gasStored.amount);
            int[] values = ListUtils.calcPercentInt(ListUtils.percent(caps), this.gasStored.amount);
            for (GasNetwork network : networks) {
                int index = networks.indexOf(network);
                if (values[index] <= 0) continue;
                network.gasStored = new GasStack(this.gasStored.getGas(), values[index]);
                network.refGas = this.gasStored.getGas();
            }
        }
        this.gasScale = 0.0f;
        this.refGas = null;
        this.gasStored = null;
    }

    public synchronized int getGasNeeded() {
        return this.getCapacity() - (this.gasStored != null ? this.gasStored.amount : 0);
    }

    public synchronized int tickEmit(GasStack stack) {
        int sent;
        int toSend;
        List<Object> availableAcceptors = Arrays.asList(this.getAcceptors(stack.getGas()).toArray());
        Collections.shuffle(availableAcceptors);
        int prevSending = toSend = stack.amount;
        if (!availableAcceptors.isEmpty()) {
            int divider = availableAcceptors.size();
            int remaining = toSend % divider;
            int sending = (toSend - remaining) / divider;
            for (Object obj : availableAcceptors) {
                if (!(obj instanceof IGasHandler)) continue;
                IGasHandler acceptor = (IGasHandler)obj;
                int currentSending = sending;
                if (remaining > 0) {
                    ++currentSending;
                    --remaining;
                }
                toSend -= acceptor.receiveGas(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), new GasStack(stack.getGas(), currentSending));
            }
        }
        if ((sent = prevSending - toSend) > 0 && FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            this.didTransfer = true;
            this.transferDelay = 2;
        }
        return sent;
    }

    public synchronized int emit(GasStack stack) {
        if (this.gasStored != null && this.gasStored.getGas() != stack.getGas()) {
            return 0;
        }
        int toUse = Math.min(this.getGasNeeded(), stack.amount);
        if (this.gasStored == null) {
            this.gasStored = stack.copy();
            this.gasStored.amount = toUse;
        } else {
            this.gasStored.amount += toUse;
        }
        return toUse;
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        if (FMLCommonHandler.instance().getEffectiveSide().isServer()) {
            int stored;
            this.prevTransferAmount = 0;
            if (this.transferDelay == 0) {
                this.didTransfer = false;
            } else {
                --this.transferDelay;
            }
            int n = stored = this.gasStored != null ? this.gasStored.amount : 0;
            if (stored != this.prevStored) {
                this.needsUpdate = true;
            }
            this.prevStored = stored;
            if (this.didTransfer != this.prevTransfer || this.needsUpdate) {
                MinecraftForge.EVENT_BUS.post((Event)new GasTransferEvent(this, this.gasStored, this.didTransfer));
                this.needsUpdate = false;
            }
            this.prevTransfer = this.didTransfer;
            if (this.gasStored != null) {
                this.prevTransferAmount = this.tickEmit(this.gasStored);
                this.gasStored.amount -= this.prevTransferAmount;
                if (this.gasStored.amount <= 0) {
                    this.gasStored = null;
                }
            }
        }
    }

    @Override
    public void clientTick() {
        super.clientTick();
        this.gasScale = Math.max(this.gasScale, this.getScale());
        if (this.didTransfer && this.gasScale < 1.0f) {
            this.gasScale = Math.max(this.getScale(), Math.min(1.0f, this.gasScale + 0.02f));
        } else if (!this.didTransfer && this.gasScale > 0.0f) {
            this.gasScale = Math.max(this.getScale(), Math.max(0.0f, this.gasScale - 0.02f));
            if (this.gasScale == 0.0f) {
                this.gasStored = null;
            }
        }
    }

    @Override
    public synchronized Set<IGasHandler> getAcceptors(Object ... data) {
        Gas type = (Gas)data[0];
        HashSet<IGasHandler> toReturn = new HashSet<IGasHandler>();
        for (IGasHandler acceptor : ((Map)this.possibleAcceptors.clone()).values()) {
            if (this.acceptorDirections.get(acceptor) == null || !acceptor.canReceiveGas(((ForgeDirection)this.acceptorDirections.get(acceptor)).getOpposite(), type)) continue;
            toReturn.add(acceptor);
        }
        return toReturn;
    }

    @Override
    public synchronized void refresh() {
        Set iterTubes = (Set)this.transmitters.clone();
        Iterator it = iterTubes.iterator();
        boolean networkChanged = false;
        while (it.hasNext()) {
            IGridTransmitter conductor = (IGridTransmitter)it.next();
            if (conductor == null || conductor.getTile().func_145837_r()) {
                it.remove();
                networkChanged = true;
                this.transmitters.remove(conductor);
                continue;
            }
            conductor.setTransmitterNetwork(this);
        }
        if (networkChanged) {
            this.updateCapacity();
        }
    }

    @Override
    public synchronized void refresh(IGridTransmitter<GasNetwork> transmitter) {
        IGasHandler[] acceptors = GasTransmission.getConnectedAcceptors(transmitter.getTile());
        this.clearAround(transmitter);
        for (IGasHandler acceptor : acceptors) {
            ForgeDirection side = ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor));
            if (side == null || acceptor == null || acceptor instanceof IGridTransmitter || !transmitter.canConnectToAcceptor(side, true)) continue;
            this.possibleAcceptors.put(Coord4D.get((TileEntity)acceptor), acceptor);
            this.acceptorDirections.put(acceptor, ForgeDirection.getOrientation((int)Arrays.asList(acceptors).indexOf(acceptor)));
        }
    }

    public float getScale() {
        return Math.min(1.0f, this.gasStored == null || this.getCapacity() == 0 ? 0.0f : (float)this.gasStored.amount / (float)this.getCapacity());
    }

    public String toString() {
        return "[GasNetwork] " + this.transmitters.size() + " transmitters, " + this.possibleAcceptors.size() + " acceptors.";
    }

    @Override
    public boolean canMerge(List<ITransmitterNetwork<?, ?>> networks) {
        Gas found = null;
        for (ITransmitterNetwork<?, ?> network : networks) {
            if (!(network instanceof GasNetwork)) continue;
            GasNetwork net = (GasNetwork)network;
            if (net.gasStored == null) continue;
            if (found != null && found != net.gasStored.getGas()) {
                return false;
            }
            found = net.gasStored.getGas();
        }
        return true;
    }

    protected GasNetwork create(IGridTransmitter<GasNetwork> ... varTransmitters) {
        GasNetwork network = new GasNetwork(varTransmitters);
        network.refGas = this.refGas;
        if (this.gasStored != null) {
            if (network.gasStored == null) {
                network.gasStored = this.gasStored;
            } else {
                network.gasStored.amount += this.gasStored.amount;
            }
        }
        network.gasScale = network.getScale();
        this.gasScale = 0.0f;
        this.refGas = null;
        this.gasStored = null;
        return network;
    }

    protected GasNetwork create(Collection<IGridTransmitter<GasNetwork>> collection) {
        GasNetwork network = new GasNetwork(collection);
        network.refGas = this.refGas;
        if (this.gasStored != null) {
            if (network.gasStored == null) {
                network.gasStored = this.gasStored;
            } else {
                network.gasStored.amount += this.gasStored.amount;
            }
        }
        network.gasScale = network.getScale();
        network.updateCapacity();
        return network;
    }

    protected GasNetwork create(Set<GasNetwork> networks) {
        return new GasNetwork(networks);
    }

    @Override
    public TransmissionType getTransmissionType() {
        return TransmissionType.GAS;
    }

    @Override
    public String getNeededInfo() {
        return Integer.toString(this.getGasNeeded());
    }

    @Override
    public String getStoredInfo() {
        return this.gasStored != null ? this.gasStored.getGas().getLocalizedName() + " (" + this.gasStored.amount + ")" : "None";
    }

    @Override
    public String getFlowInfo() {
        return Integer.toString(this.prevTransferAmount) + "/t";
    }

    public static class GasTransferEvent
    extends Event {
        public final GasNetwork gasNetwork;
        public final GasStack transferType;
        public final boolean didTransfer;

        public GasTransferEvent(GasNetwork network, GasStack type, boolean did) {
            this.gasNetwork = network;
            this.transferType = type;
            this.didTransfer = did;
        }
    }
}

