/*
 * Decompiled with CFR 0.152.
 */
package crazypants.util;

import cofh.api.transport.IItemDuct;
import cpw.mods.fml.common.Loader;
import crazypants.enderio.Log;
import crazypants.util.IItemReceptor;
import crazypants.util.Lang;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.InventoryLargeChest;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraftforge.common.util.ForgeDirection;

public class ItemUtil {
    public static final List<IItemReceptor> receptors;

    public static String getDurabilityString(ItemStack item) {
        if (item == null) {
            return null;
        }
        return Lang.localize("item.darkSteel.tooltip.durability") + " " + (item.func_77958_k() - item.func_77960_j()) + "/" + item.func_77958_k();
    }

    public static NBTTagCompound getOrCreateNBT(ItemStack stack) {
        if (stack.field_77990_d == null) {
            stack.field_77990_d = new NBTTagCompound();
        }
        return stack.field_77990_d;
    }

    public static int doInsertItem(Object into, ItemStack item, ForgeDirection side) {
        if (into == null || item == null) {
            return 0;
        }
        if (into instanceof ISidedInventory) {
            return ItemUtil.doInsertItem((ISidedInventory)into, item, side);
        }
        if (into instanceof IInventory) {
            return ItemUtil.doInsertItem(ItemUtil.getInventory((IInventory)into), item);
        }
        if (into instanceof IItemDuct) {
            return ItemUtil.doInsertItem((IItemDuct)into, item, side);
        }
        for (IItemReceptor rec : receptors) {
            if (!rec.canInsertIntoObject(into, side)) continue;
            return rec.doInsertItem(into, item, side);
        }
        return 0;
    }

    public static int doInsertItem(IItemDuct con, ItemStack item, ForgeDirection inventorySide) {
        int startedWith = item.field_77994_a;
        ItemStack remaining = con.insertItem(inventorySide, item);
        if (remaining == null) {
            return startedWith;
        }
        return startedWith - remaining.field_77994_a;
    }

    public static int doInsertItem(ISidedInventory sidedInv, ItemStack item, ForgeDirection inventorySide) {
        int[] slots;
        if (inventorySide == null) {
            inventorySide = ForgeDirection.UNKNOWN;
        }
        if ((slots = sidedInv.func_94128_d(inventorySide.ordinal())) == null) {
            return 0;
        }
        int numInserted = 0;
        int numToInsert = item.field_77994_a;
        for (int i = 0; i < slots.length && numToInsert > 0; ++i) {
            int slot = slots[i];
            if (!sidedInv.func_102007_a(slot, item, inventorySide.ordinal())) continue;
            ItemStack contents = sidedInv.func_70301_a(slot);
            ItemStack toInsert = item.func_77946_l();
            toInsert.field_77994_a = Math.min(toInsert.field_77994_a, sidedInv.func_70297_j_());
            toInsert.field_77994_a = Math.min(toInsert.field_77994_a, toInsert.func_77976_d());
            toInsert.field_77994_a = Math.min(toInsert.field_77994_a, numToInsert);
            int inserted = 0;
            if (contents == null) {
                inserted = toInsert.field_77994_a;
            } else if (contents.func_77969_a(item) && ItemStack.func_77970_a((ItemStack)contents, (ItemStack)item)) {
                int space = sidedInv.func_70297_j_() - contents.field_77994_a;
                space = Math.min(space, contents.func_77976_d() - contents.field_77994_a);
                toInsert.field_77994_a = contents.field_77994_a + (inserted += Math.min(space, toInsert.field_77994_a));
            } else {
                toInsert.field_77994_a = 0;
            }
            if (inserted <= 0) continue;
            numInserted += inserted;
            numToInsert -= inserted;
            sidedInv.func_70299_a(slot, toInsert);
        }
        if (numInserted > 0) {
            sidedInv.func_70296_d();
        }
        return numInserted;
    }

    public static int doInsertItem(IInventory inv, ItemStack item) {
        int numInserted = 0;
        int numToInsert = item.field_77994_a;
        for (int slot = 0; slot < inv.func_70302_i_() && numToInsert > 0; ++slot) {
            ItemStack contents = inv.func_70301_a(slot);
            if (ItemUtil.isStackFull(contents)) continue;
            ItemStack toInsert = item.func_77946_l();
            toInsert.field_77994_a = Math.min(toInsert.field_77994_a, inv.func_70297_j_());
            toInsert.field_77994_a = Math.min(toInsert.field_77994_a, toInsert.func_77976_d());
            toInsert.field_77994_a = Math.min(toInsert.field_77994_a, numToInsert);
            int inserted = 0;
            if (contents == null) {
                inserted = toInsert.field_77994_a;
            } else if (contents.func_77969_a(item) && ItemStack.func_77970_a((ItemStack)contents, (ItemStack)item)) {
                int space = inv.func_70297_j_() - contents.field_77994_a;
                space = Math.min(space, contents.func_77976_d() - contents.field_77994_a);
                toInsert.field_77994_a = contents.field_77994_a + (inserted += Math.min(space, toInsert.field_77994_a));
            } else {
                toInsert.field_77994_a = 0;
            }
            if (!inv.func_94041_b(slot, toInsert)) {
                inserted = 0;
            }
            if (inserted <= 0) continue;
            numInserted += inserted;
            numToInsert -= inserted;
            inv.func_70299_a(slot, toInsert);
        }
        if (numInserted > 0) {
            inv.func_70296_d();
        }
        return numInserted;
    }

    public static boolean isStackFull(ItemStack contents) {
        if (contents == null) {
            return false;
        }
        return contents.field_77994_a >= contents.func_77976_d();
    }

    public static IInventory getInventory(IInventory inv) {
        if (inv instanceof TileEntityChest) {
            TileEntityChest chest = (TileEntityChest)inv;
            TileEntityChest neighbour = null;
            if (chest.field_145991_k != null) {
                neighbour = chest.field_145991_k;
            } else if (chest.field_145990_j != null) {
                neighbour = chest.field_145990_j;
            } else if (chest.field_145992_i != null) {
                neighbour = chest.field_145992_i;
            } else if (chest.field_145988_l != null) {
                neighbour = chest.field_145988_l;
            }
            if (neighbour != null) {
                return new InventoryLargeChest("", inv, (IInventory)neighbour);
            }
            return inv;
        }
        return inv;
    }

    public static boolean areStackMergable(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null || !s1.func_77985_e() || !s2.func_77985_e()) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    public static boolean areStacksEqual(ItemStack s1, ItemStack s2) {
        if (s1 == null || s2 == null) {
            return false;
        }
        if (!s1.func_77969_a(s2)) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)s1, (ItemStack)s2);
    }

    static {
        block2: {
            receptors = new ArrayList<IItemReceptor>();
            try {
                Class.forName("crazypants.util.BuildcraftUtil");
            }
            catch (Exception e) {
                if (!Loader.isModLoaded((String)"BuildCraft|Transport")) break block2;
                Log.warn("ItemUtil: Could not register Build Craft pipe handler. Machines will not be able to output to BC pipes.");
            }
        }
    }
}

