/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.teleport;

import cpw.mods.fml.common.FMLCommonHandler;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import crazypants.enderio.BlockEio;
import crazypants.enderio.EnderIO;
import crazypants.enderio.ModObject;
import crazypants.enderio.TileEntityEio;
import crazypants.enderio.config.Config;
import crazypants.enderio.gui.IResourceTooltipProvider;
import crazypants.enderio.machine.IMachineRecipe;
import crazypants.enderio.machine.MachineRecipeInput;
import crazypants.enderio.machine.MachineRecipeRegistry;
import crazypants.enderio.machine.painter.BasicPainterTemplate;
import crazypants.enderio.machine.painter.PainterUtil;
import crazypants.enderio.network.PacketHandler;
import crazypants.enderio.teleport.ConnectionHandler;
import crazypants.enderio.teleport.ContainerTravelAccessable;
import crazypants.enderio.teleport.ContainerTravelAuth;
import crazypants.enderio.teleport.GuiTravelAccessable;
import crazypants.enderio.teleport.GuiTravelAuth;
import crazypants.enderio.teleport.ITravelAccessable;
import crazypants.enderio.teleport.TileTravelAnchor;
import crazypants.enderio.teleport.packet.PacketAccessMode;
import crazypants.enderio.teleport.packet.PacketConfigSync;
import crazypants.enderio.teleport.packet.PacketDrainStaff;
import crazypants.enderio.teleport.packet.PacketLabel;
import crazypants.enderio.teleport.packet.PacketOpenAuthGui;
import crazypants.enderio.teleport.packet.PacketTravelEvent;
import crazypants.util.IFacade;
import crazypants.util.Lang;
import net.minecraft.block.Block;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.renderer.texture.IIconRegister;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.IChatComponent;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class BlockTravelAnchor
extends BlockEio
implements IGuiHandler,
ITileEntityProvider,
IResourceTooltipProvider,
IFacade {
    public static int renderId = -1;
    IIcon selectedOverlayIcon;
    IIcon highlightOverlayIcon;

    public static BlockTravelAnchor create() {
        PacketHandler.INSTANCE.registerMessage(PacketAccessMode.class, PacketAccessMode.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketLabel.class, PacketLabel.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketTravelEvent.class, PacketTravelEvent.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketDrainStaff.class, PacketDrainStaff.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketOpenAuthGui.class, PacketOpenAuthGui.class, PacketHandler.nextID(), Side.SERVER);
        PacketHandler.INSTANCE.registerMessage(PacketConfigSync.class, PacketConfigSync.class, PacketHandler.nextID(), Side.CLIENT);
        ConnectionHandler ch = new ConnectionHandler();
        FMLCommonHandler.instance().bus().register((Object)ch);
        BlockTravelAnchor result = new BlockTravelAnchor();
        result.init();
        return result;
    }

    private BlockTravelAnchor() {
        super(ModObject.blockTravelAnchor.unlocalisedName, TileTravelAnchor.class);
        if (!Config.travelAnchorEnabled) {
            this.func_149647_a(null);
        }
    }

    @Override
    protected void init() {
        super.init();
        EnderIO.guiHandler.registerGuiHandler(18, this);
        EnderIO.guiHandler.registerGuiHandler(19, this);
        MachineRecipeRegistry.instance.registerRecipe(ModObject.blockPainter.unlocalisedName, new PainterTemplate());
    }

    @Override
    public void func_149651_a(IIconRegister iIconRegister) {
        super.func_149651_a(iIconRegister);
        this.highlightOverlayIcon = iIconRegister.func_94245_a("enderio:blockTravelAnchorHighlight");
        this.selectedOverlayIcon = iIconRegister.func_94245_a("enderio:blockTravelAnchorSelected");
    }

    public IIcon func_149673_e(IBlockAccess world, int x, int y, int z, int blockSide) {
        TileTravelAnchor tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor && (tef = (TileTravelAnchor)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149691_a(blockSide, tef.getSourceBlockMetadata());
        }
        return super.func_149673_e(world, x, y, z, blockSide);
    }

    public TileEntity func_149915_a(World var1, int var2) {
        return new TileTravelAnchor();
    }

    public void func_149689_a(World world, int x, int y, int z, EntityLivingBase entity, ItemStack par6ItemStack) {
        TileEntity te;
        if (entity instanceof EntityPlayer && (te = world.func_147438_o(x, y, z)) instanceof TileTravelAnchor) {
            TileTravelAnchor ta = (TileTravelAnchor)te;
            ta.setPlacedBy((EntityPlayer)entity);
            Block b = PainterUtil.getSourceBlock(par6ItemStack);
            ta.setSourceBlock(b);
            ta.setSourceBlockMetadata(PainterUtil.getSourceBlockMetadata(par6ItemStack));
            world.func_147471_g(x, y, z);
        }
    }

    @Override
    public boolean openGui(World world, int x, int y, int z, EntityPlayer entityPlayer, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            ITravelAccessable ta = (ITravelAccessable)te;
            if (ta.canUiBeAccessed(entityPlayer)) {
                entityPlayer.openGui((Object)EnderIO.instance, 18, world, x, y, z);
            } else if (world.field_72995_K && !entityPlayer.func_70093_af()) {
                entityPlayer.func_146105_b((IChatComponent)new ChatComponentText(Lang.localize("gui.travelAccessable.privateBlock1") + " " + ta.getPlacedBy() + " " + Lang.localize("gui.travelAccessable.privateBlock2")));
            }
        }
        return true;
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new ContainerTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new ContainerTravelAuth(player.field_71071_by);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof ITravelAccessable) {
            if (ID == 18) {
                return new GuiTravelAccessable(player.field_71071_by, (ITravelAccessable)te, world);
            }
            return new GuiTravelAuth(player, (ITravelAccessable)te, world);
        }
        return null;
    }

    @Override
    protected void processDrop(World world, int x, int y, int z, TileEntityEio te, ItemStack drop) {
        TileTravelAnchor anchor = (TileTravelAnchor)te;
        if (anchor == null) {
            return;
        }
        ItemStack itemStack = new ItemStack((Block)this);
        Block srcBlk = anchor.getSourceBlock();
        if (srcBlk != null) {
            itemStack = this.createItemStackForSourceBlock(anchor.getSourceBlock(), anchor.getSourceBlockMetadata());
            drop.field_77990_d = (NBTTagCompound)itemStack.field_77990_d.func_74737_b();
        }
    }

    @Override
    public boolean doNormalDrops(World world, int x, int y, int z) {
        return false;
    }

    @SideOnly(value=Side.CLIENT)
    public int func_149720_d(IBlockAccess world, int x, int y, int z) {
        TileTravelAnchor tef;
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor && (tef = (TileTravelAnchor)te).getSourceBlock() != null) {
            return tef.getSourceBlock().func_149720_d(world, x, y, z);
        }
        return super.func_149720_d(world, x, y, z);
    }

    public int func_149645_b() {
        return renderId;
    }

    @Override
    public String getUnlocalizedNameForTooltip(ItemStack itemStack) {
        return this.func_149739_a();
    }

    public ItemStack createItemStackForSourceBlock(Block block, int damage) {
        if (block == this) {
            return new ItemStack((Block)this);
        }
        ItemStack result = new ItemStack((Block)this, 1, damage);
        PainterUtil.setSourceBlock(result, block, damage);
        return result;
    }

    public boolean func_149662_c() {
        return false;
    }

    @Override
    public int getFacadeMetadata(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor) {
            return ((TileTravelAnchor)te).getSourceBlockMetadata();
        }
        return 0;
    }

    @Override
    public Block getFacade(IBlockAccess world, int x, int y, int z, int side) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileTravelAnchor) {
            return ((TileTravelAnchor)te).getSourceBlock();
        }
        return this;
    }

    public final class PainterTemplate
    extends BasicPainterTemplate {
        public PainterTemplate() {
            super(BlockTravelAnchor.this);
        }

        @Override
        public IMachineRecipe.ResultStack[] getCompletedResult(float chance, MachineRecipeInput ... inputs) {
            ItemStack paintSource = MachineRecipeInput.getInputForSlot(1, inputs);
            if (paintSource == null) {
                return new IMachineRecipe.ResultStack[0];
            }
            return new IMachineRecipe.ResultStack[]{new IMachineRecipe.ResultStack(BlockTravelAnchor.this.createItemStackForSourceBlock(Block.func_149634_a((Item)paintSource.func_77973_b()), paintSource.func_77960_j()))};
        }
    }
}

