/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.transceiver;

import crazypants.enderio.machine.transceiver.ChannelType;
import net.minecraft.nbt.NBTTagCompound;

public class Channel {
    private final String name;
    final String user;
    final ChannelType type;

    public static Channel readFromNBT(NBTTagCompound root) {
        if (!root.func_74764_b("name")) {
            return null;
        }
        String name = root.func_74779_i("name");
        String user = null;
        if (root.func_74764_b("user")) {
            user = root.func_74779_i("user");
        }
        ChannelType type = ChannelType.values()[root.func_74765_d("type")];
        return new Channel(name, user, type);
    }

    public Channel(String name, String user, ChannelType type) {
        this.name = this.trim(name);
        this.user = user;
        this.type = type;
    }

    public boolean isPublic() {
        return this.user == null;
    }

    public void writeToNBT(NBTTagCompound root) {
        if (this.name == null || this.name.isEmpty()) {
            return;
        }
        root.func_74778_a("name", this.name);
        root.func_74777_a("type", (short)this.type.ordinal());
        if (this.user != null && this.user.length() > 0) {
            root.func_74778_a("user", this.user);
        }
    }

    private String trim(String str) {
        if (str == null) {
            return null;
        }
        if ((str = str.trim()).isEmpty()) {
            return null;
        }
        return str;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getName() == null ? 0 : this.getName().hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.user == null ? 0 : this.user.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Channel other = (Channel)obj;
        if (this.getName() == null ? other.getName() != null : !this.getName().equals(other.getName())) {
            return false;
        }
        if (this.type != other.type) {
            return false;
        }
        return !(this.user == null ? other.user != null : !this.user.equals(other.user));
    }

    public String getName() {
        return this.name;
    }

    public ChannelType getType() {
        return this.type;
    }

    public String getUser() {
        return this.user;
    }

    public String toString() {
        return "Channel [name=" + this.name + ", user=" + this.user + ", type=" + (Object)((Object)this.type) + "]";
    }
}

