/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.hypercube;

import crazypants.enderio.Log;
import crazypants.enderio.machine.hypercube.Channel;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class HyperCubeConfig {
    private static final String KEY_PUBLIC_CHANNELS = "public.chanels";
    private static final String DELIM = "~";
    private static final String DELIM_ESC = "/:/";
    private static final String KEY_USERS = "users";
    private static final String KEY_USER_CHANNEL = ".channels";
    private final Properties props = new Properties();
    private final List<Channel> publicChannels = new ArrayList<Channel>();
    private final Map<String, List<Channel>> userChannels = new HashMap<String, List<Channel>>();
    private final File file;

    public HyperCubeConfig(File file) {
        this.file = file;
        if (file.exists()) {
            this.load(file);
        }
    }

    public List<Channel> getPublicChannels() {
        return this.publicChannels;
    }

    public void setPublicChannels(Collection<Channel> chans) {
        this.publicChannels.clear();
        this.publicChannels.addAll(chans);
    }

    public Map<String, List<Channel>> getUserChannels() {
        return this.userChannels;
    }

    public void setUserChannels(Map<String, List<Channel>> channels) {
        this.userChannels.clear();
        this.userChannels.putAll(channels);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void save() {
        this.props.clear();
        this.setChannelListProperty(KEY_PUBLIC_CHANNELS, this.publicChannels);
        StringBuilder userListStr = new StringBuilder();
        Iterator<Map.Entry<String, List<Channel>>> itr = this.userChannels.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry<String, List<Channel>> entry = itr.next();
            String user = entry.getKey();
            List<Channel> channels = entry.getValue();
            if (user != null && channels != null && !channels.isEmpty()) {
                userListStr.append(user.toString());
                this.setChannelListProperty(user + KEY_USER_CHANNEL, channels);
            }
            if (!itr.hasNext()) continue;
            userListStr.append(DELIM);
        }
        if (userListStr.length() > 0) {
            this.props.setProperty(KEY_USERS, userListStr.toString());
        }
        FileOutputStream fos = null;
        try {
            this.file.getParentFile().mkdirs();
            fos = new FileOutputStream(this.file);
            this.props.store(fos, null);
        }
        catch (IOException ex) {
            try {
                Log.warn("HyperCubeConfig: could not save hypercube config:" + ex);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fos);
                throw throwable;
            }
            IOUtils.closeQuietly((OutputStream)fos);
        }
        IOUtils.closeQuietly((OutputStream)fos);
    }

    private void setChannelListProperty(String key, List<Channel> channels) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < channels.size(); ++i) {
            String name = channels.get((int)i).name;
            if (name != null) {
                name = name.trim();
                if ((name = name.replaceAll(DELIM, DELIM_ESC)).length() > 0) {
                    sb.append(name);
                }
            }
            if (i == channels.size() - 1) continue;
            sb.append(DELIM);
        }
        this.props.setProperty(key, sb.toString());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void load(File file) {
        String[] usersSplit;
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            this.props.load(fis);
        }
        catch (Exception e) {
            try {
                Log.error("HyperCubeConfig: Could not load config file: " + e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly(fis);
                throw throwable;
            }
            IOUtils.closeQuietly((InputStream)fis);
            return;
        }
        IOUtils.closeQuietly((InputStream)fis);
        this.publicChannels.clear();
        this.loadChannelList(KEY_PUBLIC_CHANNELS, null, this.publicChannels);
        this.userChannels.clear();
        ArrayList<String> users = new ArrayList<String>();
        String usersStr = this.props.getProperty(KEY_USERS, "");
        for (String user : usersSplit = usersStr.split(DELIM)) {
            if (user == null) continue;
            users.add(user);
        }
        for (String user : users) {
            ArrayList<Channel> channels = new ArrayList<Channel>();
            this.loadChannelList(user + KEY_USER_CHANNEL, user, channels);
            if (channels.isEmpty()) continue;
            this.userChannels.put(user, channels);
        }
    }

    private void loadChannelList(String key, String user, List<Channel> channels) {
        String[] chanSplit;
        String chans = this.props.getProperty(key, "");
        for (String chan : chanSplit = chans.split(DELIM)) {
            if (chan == null || (chan = chan.trim()).isEmpty()) continue;
            channels.add(new Channel(chan.replaceAll(DELIM_ESC, DELIM), user));
        }
    }
}

