/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.generator.combustion;

import cpw.mods.fml.relauncher.Side;
import crazypants.enderio.ModObject;
import crazypants.enderio.machine.AbstractMachineBlock;
import crazypants.enderio.machine.AbstractMachineEntity;
import crazypants.enderio.machine.generator.combustion.ContainerCombustionEngine;
import crazypants.enderio.machine.generator.combustion.GuiCombustionGenerator;
import crazypants.enderio.machine.generator.combustion.PacketCombustionTank;
import crazypants.enderio.machine.generator.combustion.TileCombustionGenerator;
import crazypants.enderio.network.PacketHandler;
import crazypants.util.FluidUtil;
import crazypants.util.Util;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IIcon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class BlockCombustionGenerator
extends AbstractMachineBlock<TileCombustionGenerator> {
    public static int renderId = -1;

    public static BlockCombustionGenerator create() {
        PacketHandler.INSTANCE.registerMessage(PacketCombustionTank.class, PacketCombustionTank.class, PacketHandler.nextID(), Side.CLIENT);
        BlockCombustionGenerator gen = new BlockCombustionGenerator();
        gen.init();
        return gen;
    }

    protected BlockCombustionGenerator() {
        super(ModObject.blockCombustionGenerator, TileCombustionGenerator.class);
    }

    public int func_149717_k() {
        return 0;
    }

    @Override
    public boolean func_149727_a(World world, int x, int y, int z, EntityPlayer entityPlayer, int par6, float par7, float par8, float par9) {
        int filled;
        TileEntity te = world.func_147438_o(x, y, z);
        if (!(te instanceof TileCombustionGenerator)) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        TileCombustionGenerator gen = (TileCombustionGenerator)te;
        ItemStack item = entityPlayer.field_71071_by.func_70448_g();
        if (item == null) {
            return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
        }
        FluidStack fluid = FluidUtil.getFluidFromItem(item);
        if (fluid != null && (filled = gen.fill(ForgeDirection.UP, fluid, false)) >= fluid.amount) {
            gen.fill(ForgeDirection.UP, fluid, true);
            if (!entityPlayer.field_71075_bZ.field_75098_d) {
                entityPlayer.field_71071_by.func_70299_a(entityPlayer.field_71071_by.field_70461_c, Util.consumeItem(item));
            }
            return true;
        }
        return super.func_149727_a(world, x, y, z, entityPlayer, par6, par7, par8, par9);
    }

    public Object getServerGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCombustionGenerator) {
            return new ContainerCombustionEngine(player.field_71071_by, (TileCombustionGenerator)te);
        }
        return null;
    }

    public Object getClientGuiElement(int ID, EntityPlayer player, World world, int x, int y, int z) {
        TileEntity te = world.func_147438_o(x, y, z);
        if (te instanceof TileCombustionGenerator) {
            return new GuiCombustionGenerator(player.field_71071_by, (TileCombustionGenerator)te);
        }
        return null;
    }

    @Override
    protected int getGuiId() {
        return 21;
    }

    @Override
    public int func_149645_b() {
        return renderId;
    }

    public boolean func_149686_d() {
        return false;
    }

    public boolean func_149662_c() {
        return false;
    }

    public IIcon getBackIcon() {
        return this.iconBuffer[0][2];
    }

    @Override
    public String getMachineFrontIconKey(boolean active) {
        if (active) {
            return "enderio:combustionGenFrontOn";
        }
        return "enderio:combustionGenFront";
    }

    @Override
    public String getBackIconKey(boolean active) {
        return "enderio:blankMachinePanel";
    }

    @Override
    public void func_149734_b(World world, int x, int y, int z, Random rand) {
        if (this.isActive((IBlockAccess)world, x, y, z)) {
            TileEntity te = world.func_147438_o(x, y, z);
            int facing = 3;
            if (te instanceof AbstractMachineEntity) {
                AbstractMachineEntity me = (AbstractMachineEntity)te;
                facing = me.facing;
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)facing);
            float startX = (float)x + (dir.offsetX == 0 ? 0.5f : 0.0f);
            float startY = (float)y + 0.5f;
            float startZ = (float)z + (dir.offsetZ == 0 ? 0.5f : 0.0f);
            if (dir.offsetX == 1) {
                startX += 1.0f;
            } else if (dir.offsetZ == 1) {
                startZ += 1.0f;
            }
            for (int i = 0; i < 2; ++i) {
                float xOffset = 0.0f;
                float yOffset = 0.0f;
                float zOffset = 0.0f;
                world.func_72869_a("smoke", (double)(startX + xOffset), (double)(startY + yOffset), (double)(startZ + zOffset), 0.0, 0.0, 0.0);
            }
        }
    }
}

