/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.farm.farmers;

import crazypants.enderio.config.Config;
import crazypants.enderio.machine.farm.TileFarmStation;
import crazypants.enderio.machine.farm.farmers.HarvestResult;
import crazypants.enderio.machine.farm.farmers.IHarvestResult;
import crazypants.enderio.machine.farm.farmers.PickableFarmer;
import crazypants.util.BlockCoord;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraftforge.common.util.ForgeDirection;

public class NaturaBerryFarmer
extends PickableFarmer {
    public NaturaBerryFarmer(Block plantedBlock, int plantedBlockMeta, int grownBlockMeta, ItemStack seeds) {
        super(plantedBlock, plantedBlockMeta, grownBlockMeta, seeds);
    }

    @Override
    public IHarvestResult harvestBlock(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (block != this.getPlantedBlock()) {
            return null;
        }
        if (!farm.hasHoe()) {
            farm.setNotification("noHoe");
            return null;
        }
        HarvestResult res = new HarvestResult();
        BlockCoord checkBlock = bc;
        for (int i = 0; i < 5 && farm.hasHoe(); ++i) {
            IHarvestResult blockRes;
            meta = farm.getBlockMeta(checkBlock);
            block = farm.getBlock(checkBlock);
            if (super.canHarvest(farm, bc, block, meta) && (blockRes = super.harvestBlock(farm, checkBlock, block, meta)) != null) {
                res.getHarvestedBlocks().add(checkBlock);
                List<EntityItem> addToDrops = blockRes.getDrops();
                for (EntityItem stack : addToDrops) {
                    res.getDrops().add(stack);
                }
            }
            checkBlock = checkBlock.getLocation(ForgeDirection.UP);
        }
        if (res.getHarvestedBlocks().isEmpty()) {
            return null;
        }
        return res;
    }

    @Override
    public boolean canHarvest(TileFarmStation farm, BlockCoord bc, Block block, int meta) {
        if (!Config.farmEssenceBerriesEnabled && "tile.ore.berries.two".equals(block.func_149739_a()) && meta == this.grownBlockMeta) {
            return false;
        }
        BlockCoord checkBlock = bc;
        for (int i = 0; i < 5; ++i) {
            meta = farm.getBlockMeta(checkBlock);
            block = checkBlock.getBlock(farm.func_145831_w());
            if (super.canHarvest(farm, checkBlock, block, meta)) {
                return true;
            }
            checkBlock = checkBlock.getLocation(ForgeDirection.UP);
        }
        return false;
    }
}

