/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.enchanter;

import crazypants.enderio.Log;
import crazypants.enderio.machine.enchanter.EnchanterRecipe;
import crazypants.enderio.machine.enchanter.EnchanterRecipeParser;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;

public class EnchanterRecipeManager {
    private static EnchanterRecipeManager instance = new EnchanterRecipeManager();
    private final List<EnchanterRecipe> recipes = new ArrayList<EnchanterRecipe>();

    public static EnchanterRecipeManager getInstance() {
        return instance;
    }

    public void loadRecipesFromConfig() {
        List<EnchanterRecipe> res = EnchanterRecipeParser.loadRecipeConfig();
        if (res != null) {
            this.recipes.addAll(res);
        }
        Log.info("Loaded " + this.recipes.size() + " recipes for Enchanter");
    }

    public EnchanterRecipe getEnchantmentRecipeForInput(ItemStack itemStack) {
        if (itemStack == null) {
            return null;
        }
        for (EnchanterRecipe recipe : this.recipes) {
            if (!recipe.isInput(itemStack)) continue;
            return recipe;
        }
        return null;
    }

    public void addCustomRecipes(String xml) {
        try {
            List<EnchanterRecipe> newRec = EnchanterRecipeParser.parse(xml);
            EnchanterRecipeParser.merge(this.recipes, newRec);
        }
        catch (Exception e) {
            Log.error("EnchanterRecipeManager: Error processing custom Enchanter recipes: " + e);
        }
    }

    public List<EnchanterRecipe> getRecipes() {
        return this.recipes;
    }
}

