/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.machine.capbank.render;

import crazypants.enderio.EnderIO;
import crazypants.enderio.machine.capbank.TileCapBank;
import crazypants.enderio.machine.capbank.network.CapBankClientNetwork;
import crazypants.enderio.machine.capbank.render.IInfoRenderer;
import crazypants.enderio.machine.power.PowerDisplayUtil;
import crazypants.render.ColorUtil;
import crazypants.render.RenderUtil;
import crazypants.util.Lang;
import java.util.Locale;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public class IoDisplay
implements IInfoRenderer {
    @Override
    public void render(TileCapBank cb, ForgeDirection dir, double x, double y, double z, float partialTick) {
        if (dir.offsetY != 0) {
            return;
        }
        CapBankClientNetwork nw = (CapBankClientNetwork)cb.getNetwork();
        if (nw == null) {
            return;
        }
        CapBankClientNetwork.IOInfo info = nw.getIODisplayInfo(cb.field_145851_c, cb.field_145848_d, cb.field_145849_e, dir);
        if (info.isInside()) {
            return;
        }
        boolean selfIlum = true;
        int brightness = 0;
        if (!selfIlum) {
            brightness = cb.func_145831_w().func_72802_i(cb.field_145851_c + dir.offsetX, cb.field_145848_d + dir.offsetY, cb.field_145849_e + dir.offsetZ, 0);
            int l1 = brightness % 65536;
            int l2 = brightness / 65536;
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)l1, (float)l2);
        } else {
            OpenGlHelper.func_77475_a((int)OpenGlHelper.field_77476_b, (float)240.0f, (float)240.0f);
        }
        boolean drawBackground = true;
        if (drawBackground) {
            RenderUtil.bindBlockTexture();
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78382_b();
            if (!selfIlum) {
                tes.func_78380_c(brightness);
            }
            tes.func_78386_a(1.0f, 1.0f, 1.0f);
            float scale = 0.85f;
            float offset = (1.0f - scale) / 2.0f;
            IIcon icon = EnderIO.blockCapBank.getInfoPanelIcon();
            float minU = icon.func_94209_e();
            float maxU = icon.func_94212_f();
            float minV = icon.func_94206_g();
            float maxV = icon.func_94210_h();
            switch (dir) {
                case NORTH: {
                    float y0 = offset - (float)(info.height - 1);
                    float y1 = 1.0f - offset;
                    float x0 = offset;
                    float x1 = (float)info.width - offset;
                    float z0 = 0.0f;
                    tes.func_78375_b(0.0f, 0.0f, -1.0f);
                    tes.func_78374_a((double)x1, (double)y0, (double)z0, (double)minU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    tes.func_78374_a((double)x1, (double)y1, (double)z0, (double)minU, (double)maxV);
                    break;
                }
                case SOUTH: {
                    float y0 = offset - (float)(info.height - 1);
                    float y1 = 1.0f - offset;
                    float x0 = offset - (float)(info.width - 1);
                    float x1 = 1.0f - offset;
                    float z1 = 1.0f;
                    tes.func_78375_b(0.0f, 0.0f, 1.0f);
                    tes.func_78374_a((double)x0, (double)y0, (double)z1, (double)maxU, (double)minV);
                    tes.func_78374_a((double)x1, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.func_78374_a((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z1, (double)maxU, (double)maxV);
                    break;
                }
                case EAST: {
                    float y0 = offset - (float)(info.height - 1);
                    float y1 = 1.0f - offset;
                    float z0 = offset;
                    float z1 = (float)info.width - offset;
                    float x1 = 1.0f;
                    tes.func_78375_b(1.0f, 0.0f, 0.0f);
                    tes.func_78374_a((double)x1, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    tes.func_78374_a((double)x1, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.func_78374_a((double)x1, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.func_78374_a((double)x1, (double)y0, (double)z0, (double)maxU, (double)minV);
                    break;
                }
                case WEST: {
                    float y0 = offset - (float)(info.height - 1);
                    float y1 = 1.0f - offset;
                    float z0 = offset - (float)(info.width - 1);
                    float z1 = 1.0f - offset;
                    float x0 = 0.0f;
                    tes.func_78375_b(-1.0f, 0.0f, 0.0f);
                    tes.func_78374_a((double)x0, (double)y0, (double)z0, (double)maxU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y0, (double)z1, (double)minU, (double)minV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z1, (double)minU, (double)maxV);
                    tes.func_78374_a((double)x0, (double)y1, (double)z0, (double)maxU, (double)maxV);
                    break;
                }
                default: {
                    throw new AssertionError();
                }
            }
            tes.func_78381_a();
        }
        nw.requestPowerUpdate(cb, 20);
        int change = Math.round(nw.getAverageChangePerTick());
        HeadingText heading = HeadingText.STABLE;
        if (change > 0) {
            heading = HeadingText.GAIN;
        } else if (change < 0) {
            heading = HeadingText.LOSS;
        }
        FontRenderer fr = Minecraft.func_71410_x().field_71466_p;
        String changeText = this.getChangeText(change, fr);
        float size = 0.15f * (float)Math.min(info.width, info.height);
        float scale = size / (float)fr.field_78288_b;
        ForgeDirection right = dir.getRotation(ForgeDirection.UP);
        GL11.glPushMatrix();
        GL11.glTranslatef((float)((float)dir.offsetX * 1.02f / 2.0f + 0.5f + (float)(right.offsetX * (info.width - 1)) * 0.5f), (float)(1.0f + size * 0.5f - (float)info.height * 0.5f), (float)((float)dir.offsetZ * 1.02f / 2.0f + 0.5f + (float)(right.offsetZ * (info.width - 1)) * 0.5f));
        GL11.glRotatef((float)-180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        if (dir == ForgeDirection.NORTH) {
            GL11.glRotatef((float)-180.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.EAST) {
            GL11.glRotatef((float)-90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        } else if (dir == ForgeDirection.WEST) {
            GL11.glRotatef((float)90.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        }
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(-size), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(heading.text, -fr.func_78256_a(heading.text) / 2, 0, 0);
        GL11.glPopMatrix();
        GL11.glPushMatrix();
        GL11.glTranslatef((float)0.0f, (float)(size / 2.0f), (float)0.0f);
        GL11.glScalef((float)scale, (float)scale, (float)scale);
        fr.func_78276_b(changeText, -fr.func_78256_a(changeText) / 2, 0, heading.color);
        GL11.glPopMatrix();
        GL11.glPopMatrix();
    }

    protected String getChangeText(int change, FontRenderer fr) {
        String txt = PowerDisplayUtil.INT_NF.format(change = Math.abs(change));
        int width = fr.func_78256_a(txt);
        if (width > 38 && change > 1000) {
            txt = PowerDisplayUtil.INT_NF.format(change /= 1000) + "K";
        }
        return txt;
    }

    static enum HeadingText {
        STABLE(ColorUtil.getRGB(0, 0, 0)),
        GAIN(ColorUtil.getRGB(0.0f, 0.25f, 0.0f)),
        LOSS(ColorUtil.getRGB(0.25f, 0.0f, 0.0f));

        final String text = Lang.localize("capbank.iodisplay.".concat(this.name().toLowerCase(Locale.ENGLISH)));
        final int color;

        private HeadingText(int color) {
            this.color = color;
        }
    }
}

