/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.render;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.ConduitRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.vecmath.Vertex;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;

public class DefaultConduitRenderer
implements ConduitRenderer {
    protected float transmissionScaleFactor;

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return true;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight, RenderBlocks rb) {
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        if (!rb.func_147744_b()) {
            for (CollidableComponent component : components) {
                IIcon tex;
                if (!this.renderComponent(component)) continue;
                float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(component));
                if (this.isNSEWUD(component.dir) && conduit.getTransmitionTextureForState(component) != null) {
                    tessellator.func_78380_c((int)worldLight);
                    tex = conduit.getTransmitionTextureForState(component);
                    this.renderTransmission(conduit, tex, component, selfIllum);
                }
                if ((tex = conduit.getTextureForState(component)) == null) continue;
                tessellator.func_78380_c((int)worldLight);
                this.renderConduit(tex, conduit, component, selfIllum);
            }
        }
    }

    @Override
    public void renderDynamicEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit con, double x, double y, double z, float partialTick, float worldLight) {
    }

    protected void renderConduit(IIcon tex, IConduit conduit, CollidableComponent component, float brightness) {
        if (this.isNSEWUD(component.dir)) {
            float scaleFactor = 0.75f;
            float xLen = Math.abs(component.dir.offsetX) == 1 ? 1.0f : scaleFactor;
            float yLen = Math.abs(component.dir.offsetY) == 1 ? 1.0f : scaleFactor;
            float zLen = Math.abs(component.dir.offsetZ) == 1 ? 1.0f : scaleFactor;
            BoundingBox cube = component.bound;
            BoundingBox bb = cube.scale(xLen, yLen, zLen);
            this.drawSection(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false);
            if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
                tex = EnderIO.blockConduitBundle.getConnectorIcon(component.data);
                List<Vertex> corners = component.bound.getCornersWithUvForFace(component.dir, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
                Tessellator tessellator = Tessellator.field_78398_a;
                for (Vertex c : corners) {
                    CubeRenderer.addVecWithUV(c.xyz, c.uv.x, c.uv.y);
                }
            }
        } else {
            this.drawSection(component.bound, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
        }
    }

    protected void renderTransmission(IConduit conduit, IIcon tex, CollidableComponent component, float selfIllum) {
        float scaleFactor = 0.6f;
        float xLen = Math.abs(component.dir.offsetX) == 1 ? 1.0f : scaleFactor;
        float yLen = Math.abs(component.dir.offsetY) == 1 ? 1.0f : scaleFactor;
        float zLen = Math.abs(component.dir.offsetZ) == 1 ? 1.0f : scaleFactor;
        BoundingBox cube = component.bound;
        BoundingBox bb = cube.scale(xLen, yLen, zLen);
        this.drawSection(bb, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false);
    }

    protected boolean renderComponent(CollidableComponent component) {
        return true;
    }

    protected boolean isNSEWUD(ForgeDirection dir) {
        return dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH || dir == ForgeDirection.EAST || dir == ForgeDirection.WEST || dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
    }

    protected void drawSection(BoundingBox bound, float minU, float maxU, float minV, float maxV, ForgeDirection dir, boolean isTransmission) {
        float cm;
        boolean rotateTopBottom;
        Tessellator tessellator = Tessellator.field_78398_a;
        if (isTransmission) {
            this.setVerticesForTransmission(bound, dir);
        } else {
            CubeRenderer.setupVertices(bound);
        }
        if (dir == ForgeDirection.NORTH || dir == ForgeDirection.UP || dir == ForgeDirection.EAST) {
            float tmp = minU;
            minU = maxU;
            maxU = tmp;
        }
        boolean rotateSides = dir == ForgeDirection.UP || dir == ForgeDirection.DOWN;
        boolean bl = rotateTopBottom = dir == ForgeDirection.NORTH || dir == ForgeDirection.SOUTH;
        if (dir != ForgeDirection.NORTH && dir != ForgeDirection.SOUTH) {
            float tmp;
            tessellator.func_78375_b(0.0f, 0.0f, -1.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.NORTH);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
            }
            if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
            tessellator.func_78375_b(0.0f, 0.0f, 1.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.SOUTH);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], minU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], minU, maxV);
            }
            if (dir == ForgeDirection.WEST || dir == ForgeDirection.EAST) {
                tmp = minU;
                minU = maxU;
                maxU = tmp;
            }
        }
        if (dir != ForgeDirection.UP && dir != ForgeDirection.DOWN) {
            tessellator.func_78375_b(0.0f, 1.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.UP);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateTopBottom) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], maxU, minV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], maxU, minV);
            }
            tessellator.func_78375_b(0.0f, -1.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.DOWN);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateTopBottom) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
            }
        }
        if (dir != ForgeDirection.EAST && dir != ForgeDirection.WEST) {
            tessellator.func_78375_b(1.0f, 0.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.EAST);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], maxU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[2], minU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[6], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[5], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[1], minU, minV);
            }
            tessellator.func_78375_b(-1.0f, 0.0f, 0.0f);
            if (!isTransmission) {
                cm = RenderUtil.getColorMultiplierForFace(ForgeDirection.WEST);
                tessellator.func_78386_a(cm, cm, cm);
            }
            if (rotateSides) {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, maxV);
            } else {
                CubeRenderer.addVecWithUV(CubeRenderer.verts[0], minU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[4], maxU, minV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[7], maxU, maxV);
                CubeRenderer.addVecWithUV(CubeRenderer.verts[3], minU, maxV);
            }
        }
        tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
    }

    protected void setVerticesForTransmission(BoundingBox bound, ForgeDirection dir) {
        float xs = dir.offsetX == 0 ? this.transmissionScaleFactor : 1.0f;
        float ys = dir.offsetY == 0 ? this.transmissionScaleFactor : 1.0f;
        float zs = dir.offsetZ == 0 ? this.transmissionScaleFactor : 1.0f;
        CubeRenderer.setupVertices(bound.scale(xs, ys, zs));
    }

    public BoundingBox[] toCubes(BoundingBox bb) {
        float width = bb.maxX - bb.minX;
        float height = bb.maxY - bb.minY;
        float depth = bb.maxZ - bb.minZ;
        if (width > 0.0f && height > 0.0f && depth > 0.0f) {
            if (width / depth > 1.5f || depth / width > 1.5f) {
                if (width > depth) {
                    int numSplits = Math.round(width / depth);
                    float newWidth = width / (float)numSplits;
                    BoundingBox[] result = new BoundingBox[numSplits];
                    float lastMax = bb.minX;
                    for (int i = 0; i < numSplits; ++i) {
                        float max = lastMax + newWidth;
                        result[i] = new BoundingBox(lastMax, bb.minY, bb.minZ, max, bb.maxY, bb.maxZ);
                        lastMax = max;
                    }
                    return result;
                }
                int numSplits = Math.round(depth / width);
                float newWidth = depth / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minZ;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, bb.minY, lastMax, bb.maxX, bb.maxY, max);
                    lastMax = max;
                }
                return result;
            }
            if ((double)(height / width) > 1.5) {
                int numSplits = Math.round(height / width);
                float newWidth = height / (float)numSplits;
                BoundingBox[] result = new BoundingBox[numSplits];
                float lastMax = bb.minY;
                for (int i = 0; i < numSplits; ++i) {
                    float max = lastMax + newWidth;
                    result[i] = new BoundingBox(bb.minX, lastMax, bb.minZ, bb.maxX, max, bb.maxZ);
                    lastMax = max;
                }
                return result;
            }
        }
        return new BoundingBox[]{bb};
    }

    @Override
    public boolean isDynamic() {
        return false;
    }
}

