/*
 * Decompiled with CFR 0.152.
 */
package crazypants.enderio.conduit.liquid;

import crazypants.enderio.EnderIO;
import crazypants.enderio.conduit.ConnectionMode;
import crazypants.enderio.conduit.IConduit;
import crazypants.enderio.conduit.IConduitBundle;
import crazypants.enderio.conduit.geom.CollidableComponent;
import crazypants.enderio.conduit.liquid.ConduitTank;
import crazypants.enderio.conduit.liquid.LiquidConduit;
import crazypants.enderio.conduit.render.ConduitBundleRenderer;
import crazypants.enderio.conduit.render.DefaultConduitRenderer;
import crazypants.render.BoundingBox;
import crazypants.render.CubeRenderer;
import crazypants.render.RenderUtil;
import crazypants.util.ForgeDirectionOffsets;
import crazypants.vecmath.Vector2f;
import crazypants.vecmath.Vector3d;
import crazypants.vecmath.Vector3f;
import crazypants.vecmath.Vertex;
import java.util.Collection;
import java.util.List;
import net.minecraft.client.renderer.RenderBlocks;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.util.IIcon;
import net.minecraftforge.common.util.ForgeDirection;
import net.minecraftforge.fluids.FluidStack;

public class LiquidConduitRenderer
extends DefaultConduitRenderer {
    private float downRatio;
    private float flatRatio;
    private float upRatio;

    @Override
    public boolean isRendererForConduit(IConduit conduit) {
        return conduit instanceof LiquidConduit;
    }

    @Override
    public void renderEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight, RenderBlocks rb) {
        this.calculateRatios((LiquidConduit)conduit);
        super.renderEntity(conduitBundleRenderer, te, conduit, x, y, z, partialTick, worldLight, rb);
    }

    @Override
    protected void renderConduit(IIcon tex, IConduit conduit, CollidableComponent component, float brightness) {
        if (this.isNSEWUD(component.dir)) {
            BoundingBox[] cubes;
            LiquidConduit lc = (LiquidConduit)conduit;
            FluidStack fluid = lc.getFluidType();
            if (fluid != null) {
                LiquidConduitRenderer.renderFluidOutline(component, fluid);
            }
            for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
                this.drawSection(cube, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, false);
            }
        } else {
            this.drawSection(component.bound, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
        }
        if (conduit.getConnectionMode(component.dir) == ConnectionMode.DISABLED) {
            tex = EnderIO.blockConduitBundle.getConnectorIcon(component.data);
            List<Vertex> corners = component.bound.getCornersWithUvForFace(component.dir, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h());
            Tessellator tessellator = Tessellator.field_78398_a;
            for (Vertex c : corners) {
                CubeRenderer.addVecWithUV(c.xyz, c.uv.x, c.uv.y);
            }
            for (int i = corners.size() - 1; i >= 0; --i) {
                Vertex c;
                c = corners.get(i);
                CubeRenderer.addVecWithUV(c.xyz, c.uv.x, c.uv.y);
            }
        }
    }

    public static void renderFluidOutline(CollidableComponent component, FluidStack fluid) {
        LiquidConduitRenderer.renderFluidOutline(component, fluid, 1.0, 0.8125f);
    }

    public static void renderFluidOutline(CollidableComponent component, FluidStack fluid, double scaleFactor, float outlineWidth) {
        BoundingBox bbb;
        IIcon texture = fluid.getFluid().getStillIcon();
        if (texture == null && (texture = fluid.getFluid().getIcon()) == null) {
            return;
        }
        if (scaleFactor == 1.0) {
            bbb = component.bound;
        } else {
            double xScale = Math.abs(component.dir.offsetX) == 1 ? 1.0 : scaleFactor;
            double yScale = Math.abs(component.dir.offsetY) == 1 ? 1.0 : scaleFactor;
            double zScale = Math.abs(component.dir.offsetZ) == 1 ? 1.0 : scaleFactor;
            bbb = component.bound.scale(xScale, yScale, zScale);
        }
        for (ForgeDirection face : ForgeDirection.VALID_DIRECTIONS) {
            if (face == component.dir || face == component.dir.getOpposite()) continue;
            Tessellator tes = Tessellator.field_78398_a;
            tes.func_78375_b((float)face.offsetX, (float)face.offsetY, (float)face.offsetZ);
            Vector3d offset = ForgeDirectionOffsets.offsetScaled(face, -0.005);
            Vector2f uv = new Vector2f();
            List<ForgeDirection> edges = RenderUtil.getEdgesForFace(face);
            for (ForgeDirection edge : edges) {
                if (edge == component.dir || edge == component.dir.getOpposite()) continue;
                float xLen = 1.0f - (float)Math.abs(edge.offsetX) * outlineWidth;
                float yLen = 1.0f - (float)Math.abs(edge.offsetY) * outlineWidth;
                float zLen = 1.0f - (float)Math.abs(edge.offsetZ) * outlineWidth;
                BoundingBox bb = bbb.scale(xLen, yLen, zLen);
                List<Vector3f> corners = bb.getCornersForFace(face);
                for (Vector3f unitCorn : corners) {
                    Vector3d corner = new Vector3d(unitCorn);
                    corner.add(offset);
                    corner.x += (double)((float)((double)edge.offsetX * 0.5 * (double)bbb.sizeX()) - Math.signum(edge.offsetX) * xLen / 2.0f * bbb.sizeX() * 2.0f);
                    corner.y += (double)((float)((double)edge.offsetY * 0.5 * (double)bbb.sizeY()) - Math.signum(edge.offsetY) * yLen / 2.0f * bbb.sizeY() * 2.0f);
                    corner.z += (double)((float)((double)edge.offsetZ * 0.5 * (double)bbb.sizeZ()) - Math.signum(edge.offsetZ) * zLen / 2.0f * bbb.sizeZ() * 2.0f);
                    RenderUtil.getUvForCorner(uv, corner, 0, 0, 0, face, texture);
                    tes.func_78374_a(corner.x, corner.y, corner.z, (double)uv.x, (double)uv.y);
                }
            }
        }
    }

    @Override
    protected void renderTransmission(IConduit con, IIcon tex, CollidableComponent component, float brightness) {
    }

    @Override
    public boolean isDynamic() {
        return true;
    }

    @Override
    public void renderDynamicEntity(ConduitBundleRenderer conduitBundleRenderer, IConduitBundle te, IConduit conduit, double x, double y, double z, float partialTick, float worldLight) {
        if (((LiquidConduit)conduit).getTank().getFilledRatio() <= 0.0f) {
            return;
        }
        Collection<CollidableComponent> components = conduit.getCollidableComponents();
        Tessellator tessellator = Tessellator.field_78398_a;
        this.calculateRatios((LiquidConduit)conduit);
        this.transmissionScaleFactor = conduit.getTransmitionGeometryScale();
        for (CollidableComponent component : components) {
            BoundingBox[] cubes;
            if (!this.renderComponent(component)) continue;
            float selfIllum = Math.max(worldLight, conduit.getSelfIlluminationForState(component));
            if (!this.isNSEWUD(component.dir) || conduit.getTransmitionTextureForState(component) == null) continue;
            tessellator.func_78386_a(1.0f, 1.0f, 1.0f);
            IIcon tex = conduit.getTransmitionTextureForState(component);
            for (BoundingBox cube : cubes = this.toCubes(component.bound)) {
                this.drawSection(cube, tex.func_94209_e(), tex.func_94212_f(), tex.func_94206_g(), tex.func_94210_h(), component.dir, true);
            }
        }
    }

    @Override
    protected void setVerticesForTransmission(BoundingBox bound, ForgeDirection id) {
        float yScale = this.getRatioForConnection(id);
        float xs = id.offsetX == 0 ? 0.9f : 1.0f;
        float ys = id.offsetY == 0 ? Math.min(yScale, 0.9f) : yScale;
        float zs = id.offsetZ == 0 ? 0.9f : 1.0f;
        float sizeY = bound.sizeY();
        bound = bound.scale(xs, ys, zs);
        float transY = (bound.sizeY() - sizeY) / 2.0f;
        Vector3d translation = new Vector3d(0.0, transY, 0.0);
        CubeRenderer.setupVertices(bound.translate(translation));
    }

    private void calculateRatios(LiquidConduit conduit) {
        ConduitTank tank = conduit.getTank();
        int totalAmount = tank.getFluidAmount();
        int upCapacity = 0;
        if (conduit.containsConduitConnection(ForgeDirection.UP) || conduit.containsExternalConnection(ForgeDirection.UP)) {
            upCapacity = 250;
        }
        int downCapacity = 0;
        if (conduit.containsConduitConnection(ForgeDirection.DOWN) || conduit.containsExternalConnection(ForgeDirection.DOWN)) {
            downCapacity = 250;
        }
        int flatCapacity = tank.getCapacity() - upCapacity - downCapacity;
        int usedCapacity = 0;
        if (downCapacity > 0) {
            int inDown = Math.min(totalAmount, downCapacity);
            usedCapacity += inDown;
            this.downRatio = (float)inDown / (float)downCapacity;
        }
        if (flatCapacity > 0 && usedCapacity < totalAmount) {
            int inFlat = Math.min(flatCapacity, totalAmount - usedCapacity);
            usedCapacity += inFlat;
            this.flatRatio = (float)inFlat / (float)flatCapacity;
        } else {
            this.flatRatio = 0.0f;
        }
        if (upCapacity > 0 && usedCapacity < totalAmount) {
            int inUp = Math.min(upCapacity, totalAmount - usedCapacity);
            this.upRatio = (float)inUp / (float)upCapacity;
        } else {
            this.upRatio = 0.0f;
        }
    }

    private float getRatioForConnection(ForgeDirection id) {
        if (id == ForgeDirection.UP) {
            return this.upRatio;
        }
        if (id == ForgeDirection.DOWN) {
            return this.downRatio;
        }
        return this.flatRatio;
    }
}

