/*
 * Decompiled with CFR 0.152.
 */
package net.minecraftforge.lex.yunomakegoodmap;

import cpw.mods.fml.relauncher.ReflectionHelper;
import java.lang.reflect.Field;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderHell;
import net.minecraft.world.biome.BiomeGenBase;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraft.world.gen.ChunkProviderHell;
import net.minecraft.world.gen.MapGenBase;
import net.minecraftforge.lex.yunomakegoodmap.YUNoMakeGoodMap;

public class WorldProviderHellVoid
extends WorldProviderHell {
    public IChunkProvider func_76555_c() {
        if (YUNoMakeGoodMap.instance.shouldBeVoid(this.field_76579_a)) {
            return new ChunkProviderHellVoid(this.field_76579_a, this.field_76579_a.func_72905_C());
        }
        return new ChunkProviderHell(this.field_76579_a, this.field_76579_a.func_72905_C());
    }

    public static class ChunkProviderHellVoid
    extends ChunkProviderHell {
        private World world;
        private Field genWorldF;

        public ChunkProviderHellVoid(World world, long seed) {
            super(world, seed);
            this.world = world;
            this.genWorldF = ReflectionHelper.findField(MapGenBase.class, (String[])new String[]{"field_75039_c", "worldObj"});
            this.genWorldF.setAccessible(true);
        }

        public Chunk func_73158_c(int x, int z) {
            return this.func_73154_d(x, z);
        }

        public void func_73153_a(IChunkProvider provider, int x, int z) {
            if (YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(this.world)) {
                this.field_73172_c.func_75051_a(this.world, this.world.field_73012_v, x, z);
            }
            int spawnX = this.world.func_72912_H().func_76079_c() / 8;
            int spawnY = this.world.func_72912_H().func_76075_d();
            int spawnZ = this.world.func_72912_H().func_76074_e() / 8;
            if (x == spawnX / 16 && z == spawnZ / 16) {
                YUNoMakeGoodMap.instance.getPlatformType(this.world).generate(this.world, spawnX, spawnY, spawnZ);
            }
        }

        public Chunk func_73154_d(int x, int z) {
            Block[] data = new Block[32768];
            if (YUNoMakeGoodMap.instance.shouldGenerateNetherFortress(this.world)) {
                this.field_73172_c.func_151539_a((IChunkProvider)this, this.world, x, z, data);
            } else {
                try {
                    this.genWorldF.set(this.field_73172_c, this.world);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to set world object, either enable nether fortres gen or find a fix:", e);
                }
            }
            Chunk ret = new Chunk(this.world, data, x, z);
            BiomeGenBase[] biomes = this.world.func_72959_q().func_76933_b(null, x * 16, z * 16, 16, 16);
            byte[] ids = ret.func_76605_m();
            for (int i = 0; i < ids.length; ++i) {
                ids[i] = (byte)biomes[i].field_76756_M;
            }
            ret.func_76603_b();
            return ret;
        }
    }
}

