/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.swing.panels.timingserver;

import java.awt.Component;
import javax.swing.JButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;
import mcp.mobius.opis.api.ITabPanel;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataEvent;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import mcp.mobius.opis.network.PacketBase;
import mcp.mobius.opis.network.enums.AccessLevel;
import mcp.mobius.opis.network.enums.Message;
import mcp.mobius.opis.swing.SelectedTab;
import mcp.mobius.opis.swing.actions.ActionRunOpis;
import mcp.mobius.opis.swing.widgets.JButtonAccess;
import mcp.mobius.opis.swing.widgets.JPanelMsgHandler;
import mcp.mobius.opis.swing.widgets.JTableStats;
import net.miginfocom.swing.MigLayout;

public class PanelTimingEvents
extends JPanelMsgHandler
implements ITabPanel {
    private JButtonAccess btnRun;

    public PanelTimingEvents() {
        this.setLayout(new MigLayout("", "[grow][]", "[][grow]"));
        this.btnRun = new JButtonAccess("Run Opis", AccessLevel.PRIVILEGED);
        this.add((Component)this.btnRun, "cell 1 0");
        this.btnRun.addActionListener(new ActionRunOpis());
        JScrollPane scrollPane = new JScrollPane();
        this.add((Component)scrollPane, "cell 0 1 2 1,grow");
        this.table = new JTableStats(new String[]{"Event", "Mod", "Class", "Handler", "Calls", "Timing"}, new Class[]{CachedString.class, CachedString.class, CachedString.class, CachedString.class, Long.class, DataTiming.class}, new int[]{2, 2, 2, 2, 0, 0});
        scrollPane.setViewportView(this.table);
    }

    @Override
    public boolean handleMessage(Message msg, PacketBase rawdata) {
        switch (msg) {
            case LIST_TIMING_EVENTS: {
                this.cacheData(msg, rawdata);
                this.getTable().setTableData(rawdata.array);
                DefaultTableModel model = this.table.getModel();
                int row = this.getTable().clearTable(DataEvent.class);
                for (ISerializable o : rawdata.array) {
                    DataEvent data = (DataEvent)o;
                    model.addRow(new Object[]{data.event, data.mod, data.package_, data.handler, data.nCalls, data.update});
                }
                this.getTable().dataUpdated(row);
                break;
            }
            case STATUS_START: {
                this.getBtnRun().setText("Running...");
                break;
            }
            case STATUS_STOP: {
                this.getBtnRun().setText("Run Opis");
                break;
            }
            case STATUS_RUNNING: {
                this.getBtnRun().setText("Running...");
                break;
            }
            default: {
                return false;
            }
        }
        return true;
    }

    @Override
    public SelectedTab getSelectedTab() {
        return SelectedTab.TIMINGEVENTS;
    }

    public JButton getBtnRun() {
        return this.btnRun;
    }

    @Override
    public boolean refreshOnString() {
        return true;
    }
}

