/*
 * Decompiled with CFR 0.152.
 */
package mcp.mobius.opis.data.holders.newtypes;

import com.google.common.collect.Table;
import com.google.common.io.ByteArrayDataInput;
import com.google.common.io.ByteArrayDataOutput;
import mcp.mobius.opis.data.holders.ISerializable;
import mcp.mobius.opis.data.holders.newtypes.CachedString;
import mcp.mobius.opis.data.holders.newtypes.DataTiming;
import opisapache.math3.stat.descriptive.DescriptiveStatistics;

public class DataEvent
implements ISerializable,
Comparable {
    public CachedString event;
    public CachedString handler;
    public CachedString package_;
    public CachedString mod;
    public long nCalls;
    public DataTiming update;

    public DataEvent fill(Table.Cell<Class, String, DescriptiveStatistics> cellData, String modName) {
        String[] nameRaw = ((String)cellData.getColumnKey()).split("\\|");
        String handlerName = nameRaw[1];
        try {
            String[] splitHandler = handlerName.split("_");
            handlerName = splitHandler[2] + "." + splitHandler[3];
        }
        catch (Exception e) {
            // empty catch block
        }
        this.package_ = new CachedString(nameRaw[0]);
        this.handler = new CachedString(handlerName);
        this.event = new CachedString(((Class)cellData.getRowKey()).getName().replace("net.minecraftforge.event.", ""));
        this.nCalls = ((DescriptiveStatistics)cellData.getValue()).getN();
        this.mod = new CachedString(modName);
        this.update = new DataTiming(((DescriptiveStatistics)cellData.getValue()).getGeometricMean());
        return this;
    }

    @Override
    public void writeToStream(ByteArrayDataOutput stream) {
        this.event.writeToStream(stream);
        this.package_.writeToStream(stream);
        this.handler.writeToStream(stream);
        this.update.writeToStream(stream);
        this.mod.writeToStream(stream);
        stream.writeLong(this.nCalls);
    }

    public static DataEvent readFromStream(ByteArrayDataInput stream) {
        DataEvent retVal = new DataEvent();
        retVal.event = CachedString.readFromStream(stream);
        retVal.package_ = CachedString.readFromStream(stream);
        retVal.handler = CachedString.readFromStream(stream);
        retVal.update = DataTiming.readFromStream(stream);
        retVal.mod = CachedString.readFromStream(stream);
        retVal.nCalls = stream.readLong();
        return retVal;
    }

    public int compareTo(Object o) {
        return this.update.compareTo(((DataEvent)o).update);
    }
}

